/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.extra;

import com.jsoniter.spi.Binding;
import com.jsoniter.spi.ClassDescriptor;
import com.jsoniter.spi.EmptyExtension;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.JsoniterSpi;

public class NamingStrategySupport {
    private static boolean enabled;
    public static NamingStrategy SNAKE_CASE;
    public static NamingStrategy UPPER_CAMEL_CASE;
    public static NamingStrategy LOWER_CASE;
    public static NamingStrategy KEBAB_CASE;

    public static synchronized void enable(final NamingStrategy namingStrategy) {
        if (enabled) {
            throw new JsonException("NamingStrategySupport.enable can only be called once");
        }
        enabled = true;
        JsoniterSpi.registerExtension(new EmptyExtension(){

            @Override
            public void updateClassDescriptor(ClassDescriptor desc) {
                for (Binding binding : desc.allBindings()) {
                    binding.name = namingStrategy.translate(binding.name);
                }
            }
        });
    }

    static {
        SNAKE_CASE = new NamingStrategy(){

            @Override
            public String translate(String input) {
                if (input == null) {
                    return input;
                }
                int length = input.length();
                StringBuilder result = new StringBuilder(length * 2);
                int resultLength = 0;
                boolean wasPrevTranslated = false;
                for (int i = 0; i < length; ++i) {
                    char c = input.charAt(i);
                    if (i <= 0 && c == '_') continue;
                    if (Character.isUpperCase(c)) {
                        if (!wasPrevTranslated && resultLength > 0 && result.charAt(resultLength - 1) != '_') {
                            result.append('_');
                            ++resultLength;
                        }
                        c = Character.toLowerCase(c);
                        wasPrevTranslated = true;
                    } else {
                        wasPrevTranslated = false;
                    }
                    result.append(c);
                    ++resultLength;
                }
                return resultLength > 0 ? result.toString() : input;
            }
        };
        UPPER_CAMEL_CASE = new NamingStrategy(){

            @Override
            public String translate(String input) {
                char uc;
                if (input == null || input.length() == 0) {
                    return input;
                }
                char c = input.charAt(0);
                if (c == (uc = Character.toUpperCase(c))) {
                    return input;
                }
                StringBuilder sb = new StringBuilder(input);
                sb.setCharAt(0, uc);
                return sb.toString();
            }
        };
        LOWER_CASE = new NamingStrategy(){

            @Override
            public String translate(String input) {
                return input.toLowerCase();
            }
        };
        KEBAB_CASE = new NamingStrategy(){

            @Override
            public String translate(String input) {
                if (input == null) {
                    return input;
                }
                int length = input.length();
                if (length == 0) {
                    return input;
                }
                StringBuilder result = new StringBuilder(length + (length >> 1));
                int upperCount = 0;
                for (int i = 0; i < length; ++i) {
                    char ch = input.charAt(i);
                    char lc = Character.toLowerCase(ch);
                    if (lc == ch) {
                        if (upperCount > 1) {
                            result.insert(result.length() - 1, '-');
                        }
                        upperCount = 0;
                    } else {
                        if (upperCount == 0 && i > 0) {
                            result.append('-');
                        }
                        ++upperCount;
                    }
                    result.append(lc);
                }
                return result.toString();
            }
        };
    }

    public static interface NamingStrategy {
        public String translate(String var1);
    }
}

