/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.output;

import com.jsoniter.any.Any;
import com.jsoniter.output.AsciiOutputStream;
import com.jsoniter.output.Codegen;
import com.jsoniter.output.CodegenImplNative;
import com.jsoniter.output.EncodingMode;
import com.jsoniter.output.StreamImplNumber;
import com.jsoniter.output.StreamImplString;
import com.jsoniter.spi.Encoder;
import com.jsoniter.spi.JsonException;
import com.jsoniter.spi.TypeLiteral;
import java.io.IOException;
import java.io.OutputStream;

public class JsonStream
extends OutputStream {
    public static int defaultIndentionStep = 0;
    public int indentionStep = defaultIndentionStep;
    private int indention = 0;
    private OutputStream out;
    byte[] buf;
    int count;
    private static final ThreadLocal<JsonStream> tlsStream = new ThreadLocal<JsonStream>(){

        @Override
        protected JsonStream initialValue() {
            return new JsonStream(null, 4096);
        }
    };
    private static final ThreadLocal<AsciiOutputStream> tlsAsciiOutputStream = new ThreadLocal<AsciiOutputStream>(){

        @Override
        protected AsciiOutputStream initialValue() {
            return new AsciiOutputStream();
        }
    };

    public JsonStream(OutputStream out, int bufSize) {
        if (bufSize < 32) {
            throw new JsonException("buffer size must be larger than 32: " + bufSize);
        }
        this.out = out;
        this.buf = new byte[bufSize];
    }

    public void reset(OutputStream out) {
        this.out = out;
        this.count = 0;
    }

    @Override
    public final void write(int b) throws IOException {
        if (this.count == this.buf.length) {
            this.flushBuffer();
        }
        this.buf[this.count++] = (byte)b;
    }

    public final void write(byte b1, byte b2) throws IOException {
        if (this.count >= this.buf.length - 1) {
            this.flushBuffer();
        }
        this.buf[this.count++] = b1;
        this.buf[this.count++] = b2;
    }

    public final void write(byte b1, byte b2, byte b3) throws IOException {
        if (this.count >= this.buf.length - 2) {
            this.flushBuffer();
        }
        this.buf[this.count++] = b1;
        this.buf[this.count++] = b2;
        this.buf[this.count++] = b3;
    }

    public final void write(byte b1, byte b2, byte b3, byte b4) throws IOException {
        if (this.count >= this.buf.length - 3) {
            this.flushBuffer();
        }
        this.buf[this.count++] = b1;
        this.buf[this.count++] = b2;
        this.buf[this.count++] = b3;
        this.buf[this.count++] = b4;
    }

    public final void write(byte b1, byte b2, byte b3, byte b4, byte b5) throws IOException {
        if (this.count >= this.buf.length - 4) {
            this.flushBuffer();
        }
        this.buf[this.count++] = b1;
        this.buf[this.count++] = b2;
        this.buf[this.count++] = b3;
        this.buf[this.count++] = b4;
        this.buf[this.count++] = b5;
    }

    public final void write(byte b1, byte b2, byte b3, byte b4, byte b5, byte b6) throws IOException {
        if (this.count >= this.buf.length - 5) {
            this.flushBuffer();
        }
        this.buf[this.count++] = b1;
        this.buf[this.count++] = b2;
        this.buf[this.count++] = b3;
        this.buf[this.count++] = b4;
        this.buf[this.count++] = b5;
        this.buf[this.count++] = b6;
    }

    @Override
    public final void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buf.length - this.count) {
            if (len >= this.buf.length) {
                this.flushBuffer();
                this.out.write(b, off, len);
                return;
            }
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count += len;
    }

    @Override
    public void flush() throws IOException {
        this.flushBuffer();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.count > 0) {
            this.flushBuffer();
        }
        this.out.close();
        this.out = null;
        this.count = 0;
    }

    final void flushBuffer() throws IOException {
        this.out.write(this.buf, 0, this.count);
        this.count = 0;
    }

    public final void writeVal(String val) throws IOException {
        if (val == null) {
            this.writeNull();
        } else {
            StreamImplString.writeString(this, val);
        }
    }

    public final void writeRaw(String val) throws IOException {
        this.writeRaw(val, val.length());
    }

    public final void writeRaw(String val, int remaining) throws IOException {
        int j;
        int available;
        int i = 0;
        while ((available = this.buf.length - this.count) < remaining) {
            remaining -= available;
            j = i + available;
            val.getBytes(i, j, this.buf, this.count);
            this.count = this.buf.length;
            this.flushBuffer();
            i = j;
        }
        j = i + remaining;
        val.getBytes(i, j, this.buf, this.count);
        this.count += remaining;
    }

    public final void writeVal(Boolean val) throws IOException {
        if (val == null) {
            this.writeNull();
        } else if (val.booleanValue()) {
            this.writeTrue();
        } else {
            this.writeFalse();
        }
    }

    public final void writeVal(boolean val) throws IOException {
        if (val) {
            this.writeTrue();
        } else {
            this.writeFalse();
        }
    }

    public final void writeTrue() throws IOException {
        this.write((byte)116, (byte)114, (byte)117, (byte)101);
    }

    public final void writeFalse() throws IOException {
        this.write((byte)102, (byte)97, (byte)108, (byte)115, (byte)101);
    }

    public final void writeVal(Short val) throws IOException {
        if (val == null) {
            this.writeNull();
        } else {
            this.writeVal(val.intValue());
        }
    }

    public final void writeVal(short val) throws IOException {
        this.writeVal((int)val);
    }

    public final void writeVal(Integer val) throws IOException {
        if (val == null) {
            this.writeNull();
        } else {
            this.writeVal((int)val);
        }
    }

    public final void writeVal(int val) throws IOException {
        StreamImplNumber.writeInt(this, val);
    }

    public final void writeVal(Long val) throws IOException {
        if (val == null) {
            this.writeNull();
        } else {
            this.writeVal((long)val);
        }
    }

    public final void writeVal(long val) throws IOException {
        StreamImplNumber.writeLong(this, val);
    }

    public final void writeVal(Float val) throws IOException {
        if (val == null) {
            this.writeNull();
        } else {
            this.writeVal(val.floatValue());
        }
    }

    public final void writeVal(float val) throws IOException {
        StreamImplNumber.writeFloat(this, val);
    }

    public final void writeVal(Double val) throws IOException {
        if (val == null) {
            this.writeNull();
        } else {
            this.writeVal((double)val);
        }
    }

    public final void writeVal(double val) throws IOException {
        StreamImplNumber.writeDouble(this, val);
    }

    public final void writeVal(Any val) throws IOException {
        val.writeTo(this);
    }

    public final void writeNull() throws IOException {
        this.write((byte)110, (byte)117, (byte)108, (byte)108);
    }

    public final void writeEmptyObject() throws IOException {
        this.write((byte)123, (byte)125);
    }

    public final void writeEmptyArray() throws IOException {
        this.write((byte)91, (byte)93);
    }

    public final void writeArrayStart() throws IOException {
        this.indention += this.indentionStep;
        this.write(91);
        this.writeIndention();
    }

    public final void writeMore() throws IOException {
        this.write(44);
        this.writeIndention();
    }

    private void writeIndention() throws IOException {
        this.writeIndention(0);
    }

    private void writeIndention(int delta) throws IOException {
        if (this.indention == 0) {
            return;
        }
        this.write(10);
        int toWrite = this.indention - delta;
        int i = 0;
        while (true) {
            if (i < toWrite && this.count < this.buf.length) {
                this.buf[this.count++] = 32;
                ++i;
                continue;
            }
            if (i == toWrite) break;
            this.flushBuffer();
        }
    }

    public final void writeArrayEnd() throws IOException {
        this.writeIndention(this.indentionStep);
        this.indention -= this.indentionStep;
        this.write(93);
    }

    public final void writeObjectStart() throws IOException {
        this.indention += this.indentionStep;
        this.write(123);
        this.writeIndention();
    }

    public final void writeObjectField(String field) throws IOException {
        this.writeVal(field);
        this.write(58);
    }

    public final void writeObjectEnd() throws IOException {
        this.writeIndention(this.indentionStep);
        this.indention -= this.indentionStep;
        this.write(125);
    }

    public final void writeVal(Object obj) throws IOException {
        if (obj == null) {
            this.writeNull();
            return;
        }
        Class<?> clazz = obj.getClass();
        String cacheKey = TypeLiteral.create(clazz).getEncoderCacheKey();
        Codegen.getEncoder(cacheKey, clazz).encode(obj, this);
    }

    public final <T> void writeVal(TypeLiteral<T> typeLiteral, T obj) throws IOException {
        if (null == obj) {
            this.writeNull();
        } else {
            Codegen.getEncoder(typeLiteral.getEncoderCacheKey(), typeLiteral.getType()).encode(obj, this);
        }
    }

    public static void serialize(Object obj, OutputStream out) {
        JsonStream stream = tlsStream.get();
        try {
            try {
                stream.reset(out);
                stream.writeVal(obj);
            }
            finally {
                stream.close();
            }
        }
        catch (IOException e) {
            throw new JsonException(e);
        }
    }

    public static String serialize(Object obj) {
        AsciiOutputStream asciiOutputStream = tlsAsciiOutputStream.get();
        asciiOutputStream.reset();
        JsonStream.serialize(obj, asciiOutputStream);
        return asciiOutputStream.toString();
    }

    public static void setMode(EncodingMode mode) {
        Codegen.setMode(mode);
    }

    public static void registerNativeEncoder(Class clazz, Encoder encoder) {
        CodegenImplNative.NATIVE_ENCODERS.put(clazz, encoder);
    }
}

