/*
 * Decompiled with CFR 0.152.
 */
package com.jsoniter.output;

import com.jsoniter.output.JsonStream;
import java.io.IOException;

class StreamImplNumber {
    private static final int[] DIGITS = new int[1000];
    private static final byte[] MIN_INT;
    private static final byte[] MIN_LONG;
    private static final int[] POW10;

    StreamImplNumber() {
    }

    public static final void writeInt(JsonStream stream, int value) throws IOException {
        int q1;
        if (stream.buf.length - stream.count < 11) {
            stream.flushBuffer();
        }
        byte[] buf = stream.buf;
        int pos = stream.count;
        if (value < 0) {
            if (value == Integer.MIN_VALUE) {
                System.arraycopy(MIN_INT, 0, buf, pos, MIN_INT.length);
                stream.count = pos + MIN_INT.length;
                return;
            }
            value = -value;
            buf[pos++] = 45;
        }
        if ((q1 = value / 1000) == 0) {
            pos += StreamImplNumber.writeFirstBuf(buf, DIGITS[value], pos);
            stream.count = pos;
            return;
        }
        int r1 = value - q1 * 1000;
        int q2 = q1 / 1000;
        if (q2 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[q1];
            int off = StreamImplNumber.writeFirstBuf(buf, v2, pos);
            StreamImplNumber.writeBuf(buf, v1, pos + off);
            stream.count = pos + 3 + off;
            return;
        }
        int r2 = q1 - q2 * 1000;
        long q3 = q2 / 1000;
        int v1 = DIGITS[r1];
        int v2 = DIGITS[r2];
        if (q3 == 0L) {
            pos += StreamImplNumber.writeFirstBuf(buf, DIGITS[q2], pos);
        } else {
            int r3 = (int)((long)q2 - q3 * 1000L);
            buf[pos++] = (byte)(q3 + 48L);
            StreamImplNumber.writeBuf(buf, DIGITS[r3], pos);
            pos += 3;
        }
        StreamImplNumber.writeBuf(buf, v2, pos);
        StreamImplNumber.writeBuf(buf, v1, pos + 3);
        stream.count = pos + 6;
    }

    private static int writeFirstBuf(byte[] buf, int v, int pos) {
        int start = v >> 24;
        if (start == 0) {
            buf[pos++] = (byte)(v >> 16);
            buf[pos++] = (byte)(v >> 8);
        } else if (start == 1) {
            buf[pos++] = (byte)(v >> 8);
        }
        buf[pos] = (byte)v;
        return 3 - start;
    }

    private static void writeBuf(byte[] buf, int v, int pos) {
        buf[pos] = (byte)(v >> 16);
        buf[pos + 1] = (byte)(v >> 8);
        buf[pos + 2] = (byte)v;
    }

    public static final void writeLong(JsonStream stream, long value) throws IOException {
        long q1;
        if (stream.buf.length - stream.count < 21) {
            stream.flushBuffer();
        }
        byte[] buf = stream.buf;
        int pos = stream.count;
        if (value < 0L) {
            if (value == Long.MIN_VALUE) {
                System.arraycopy(MIN_LONG, 0, buf, pos, MIN_LONG.length);
                stream.count = pos + MIN_LONG.length;
                return;
            }
            value = -value;
            buf[pos++] = 45;
        }
        if ((q1 = value / 1000L) == 0L) {
            pos += StreamImplNumber.writeFirstBuf(buf, DIGITS[(int)value], pos);
            stream.count = pos;
            return;
        }
        int r1 = (int)(value - q1 * 1000L);
        long q2 = q1 / 1000L;
        if (q2 == 0L) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[(int)q1];
            int off = StreamImplNumber.writeFirstBuf(buf, v2, pos);
            StreamImplNumber.writeBuf(buf, v1, pos + off);
            stream.count = pos + 3 + off;
            return;
        }
        int r2 = (int)(q1 - q2 * 1000L);
        long q3 = q2 / 1000L;
        if (q3 == 0L) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[(int)q2];
            pos += StreamImplNumber.writeFirstBuf(buf, v3, pos);
            StreamImplNumber.writeBuf(buf, v2, pos);
            StreamImplNumber.writeBuf(buf, v1, pos + 3);
            stream.count = pos + 6;
            return;
        }
        int r3 = (int)(q2 - q3 * 1000L);
        int q4 = (int)(q3 / 1000L);
        if (q4 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[r3];
            int v4 = DIGITS[(int)q3];
            pos += StreamImplNumber.writeFirstBuf(buf, v4, pos);
            StreamImplNumber.writeBuf(buf, v3, pos);
            StreamImplNumber.writeBuf(buf, v2, pos + 3);
            StreamImplNumber.writeBuf(buf, v1, pos + 6);
            stream.count = pos + 9;
            return;
        }
        int r4 = (int)(q3 - (long)(q4 * 1000));
        int q5 = q4 / 1000;
        if (q5 == 0) {
            int v1 = DIGITS[r1];
            int v2 = DIGITS[r2];
            int v3 = DIGITS[r3];
            int v4 = DIGITS[r4];
            int v5 = DIGITS[q4];
            pos += StreamImplNumber.writeFirstBuf(buf, v5, pos);
            StreamImplNumber.writeBuf(buf, v4, pos);
            StreamImplNumber.writeBuf(buf, v3, pos + 3);
            StreamImplNumber.writeBuf(buf, v2, pos + 6);
            StreamImplNumber.writeBuf(buf, v1, pos + 9);
            stream.count = pos + 12;
            return;
        }
        int r5 = q4 - q5 * 1000;
        int q6 = q5 / 1000;
        int v1 = DIGITS[r1];
        int v2 = DIGITS[r2];
        int v3 = DIGITS[r3];
        int v4 = DIGITS[r4];
        int v5 = DIGITS[r5];
        if (q6 == 0) {
            pos += StreamImplNumber.writeFirstBuf(buf, DIGITS[q5], pos);
        } else {
            int r6 = q5 - q6 * 1000;
            buf[pos++] = (byte)(q6 + 48);
            StreamImplNumber.writeBuf(buf, DIGITS[r6], pos);
            pos += 3;
        }
        StreamImplNumber.writeBuf(buf, v5, pos);
        StreamImplNumber.writeBuf(buf, v4, pos + 3);
        StreamImplNumber.writeBuf(buf, v3, pos + 6);
        StreamImplNumber.writeBuf(buf, v2, pos + 9);
        StreamImplNumber.writeBuf(buf, v1, pos + 12);
        stream.count = pos + 15;
    }

    public static final void writeFloat(JsonStream stream, float val) throws IOException {
        if (val < 0.0f) {
            stream.write(45);
            val = -val;
        }
        if (val > 8.388608E7f) {
            stream.writeRaw(Float.toString(val));
            return;
        }
        int precision = 6;
        int exp = 1000000;
        long lval = (long)((double)(val * (float)exp) + 0.5);
        stream.writeVal(lval / (long)exp);
        long fval = lval % (long)exp;
        if (fval == 0L) {
            return;
        }
        stream.write(46);
        if (stream.buf.length - stream.count < 10) {
            stream.flushBuffer();
        }
        for (int p = precision - 1; p > 0 && fval < (long)POW10[p]; --p) {
            stream.buf[stream.count++] = 48;
        }
        stream.writeVal(fval);
        while (stream.buf[stream.count - 1] == 48) {
            --stream.count;
        }
    }

    public static final void writeDouble(JsonStream stream, double val) throws IOException {
        if (val < 0.0) {
            val = -val;
            stream.write(45);
        }
        if (val > 8.3886079E7) {
            stream.writeRaw(Double.toString(val));
            return;
        }
        int precision = 6;
        int exp = 1000000;
        long lval = (long)(val * (double)exp + 0.5);
        stream.writeVal(lval / (long)exp);
        long fval = lval % (long)exp;
        if (fval == 0L) {
            return;
        }
        stream.write(46);
        if (stream.buf.length - stream.count < 10) {
            stream.flushBuffer();
        }
        for (int p = precision - 1; p > 0 && fval < (long)POW10[p]; --p) {
            stream.buf[stream.count++] = 48;
        }
        stream.writeVal(fval);
        while (stream.buf[stream.count - 1] == 48) {
            --stream.count;
        }
    }

    static {
        for (int i = 0; i < 1000; ++i) {
            StreamImplNumber.DIGITS[i] = (i < 10 ? 0x2000000 : (i < 100 ? 0x1000000 : 0)) + (i / 100 + 48 << 16) + (i / 10 % 10 + 48 << 8) + i % 10 + 48;
        }
        MIN_INT = "-2147483648".getBytes();
        MIN_LONG = "-9223372036854775808".getBytes();
        POW10 = new int[]{1, 10, 100, 1000, 10000, 100000, 1000000};
    }
}

