/*
 * Marketing API
 * Marketing API
 *
 * OpenAPI spec version: 1.3
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.AndroidUnionChannelPackagesAddRequest;
import com.tencent.ads.model.AndroidUnionChannelPackagesAddResponse;
import com.tencent.ads.model.AndroidUnionChannelPackagesGetResponse;
import com.tencent.ads.model.AndroidUnionChannelPackagesUpdateRequest;
import com.tencent.ads.model.AndroidUnionChannelPackagesUpdateResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AndroidUnionChannelPackagesApi {
  private ApiClient apiClient;

  public AndroidUnionChannelPackagesApi() {
    this(Configuration.getDefaultApiClient());
  }

  public AndroidUnionChannelPackagesApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Build call for androidUnionChannelPackagesAdd
   *
   * @param data (required)
   * @param progressListener Progress listener
   * @param progressRequestListener Progress request listener
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   */
  public com.squareup.okhttp.Call androidUnionChannelPackagesAddCall(
      AndroidUnionChannelPackagesAddRequest data,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {
    Object localVarPostBody = data;

    // create path and map variables
    String localVarPath = "/android_union_channel_packages/add";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();

    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

    final String[] localVarContentTypes = {"application/json", "application/xml"};
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    if (progressListener != null) {
      apiClient
          .getHttpClient()
          .networkInterceptors()
          .add(
              new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(
                    com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                  com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                  return originalResponse
                      .newBuilder()
                      .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                      .build();
                }
              });
    }

    String[] localVarAuthNames = new String[] {"accessToken", "nonce", "timestamp"};
    return apiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAuthNames,
        progressRequestListener);
  }

  @SuppressWarnings("rawtypes")
  private com.squareup.okhttp.Call androidUnionChannelPackagesAddValidateBeforeCall(
      AndroidUnionChannelPackagesAddRequest data,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {

    // verify the required parameter 'data' is set
    if (data == null) {
      throw new ApiException(
          "Missing the required parameter 'data' when calling androidUnionChannelPackagesAdd(Async)");
    }

    com.squareup.okhttp.Call call =
        androidUnionChannelPackagesAddCall(data, progressListener, progressRequestListener);
    return call;
  }

  /**
   * 添加广告渠道包
   *
   * @param data (required)
   * @return AndroidUnionChannelPackagesAddResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public AndroidUnionChannelPackagesAddResponse androidUnionChannelPackagesAdd(
      AndroidUnionChannelPackagesAddRequest data) throws ApiException {
    ApiResponse<AndroidUnionChannelPackagesAddResponse> resp =
        androidUnionChannelPackagesAddWithHttpInfo(data);
    return resp.getData();
  }

  /**
   * 添加广告渠道包
   *
   * @param data (required)
   * @return ApiResponse&lt;AndroidUnionChannelPackagesAddResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public ApiResponse<AndroidUnionChannelPackagesAddResponse>
      androidUnionChannelPackagesAddWithHttpInfo(AndroidUnionChannelPackagesAddRequest data)
          throws ApiException {
    com.squareup.okhttp.Call call =
        androidUnionChannelPackagesAddValidateBeforeCall(data, null, null);
    Type localVarReturnType = new TypeToken<AndroidUnionChannelPackagesAddResponse>() {}.getType();
    return apiClient.execute(call, localVarReturnType);
  }

  /**
   * 添加广告渠道包 (asynchronously)
   *
   * @param data (required)
   * @param callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   */
  public com.squareup.okhttp.Call androidUnionChannelPackagesAddAsync(
      AndroidUnionChannelPackagesAddRequest data,
      final ApiCallback<AndroidUnionChannelPackagesAddResponse> callback)
      throws ApiException {

    ProgressResponseBody.ProgressListener progressListener = null;
    ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

    if (callback != null) {
      progressListener =
          new ProgressResponseBody.ProgressListener() {
            @Override
            public void update(long bytesRead, long contentLength, boolean done) {
              callback.onDownloadProgress(bytesRead, contentLength, done);
            }
          };

      progressRequestListener =
          new ProgressRequestBody.ProgressRequestListener() {
            @Override
            public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
              callback.onUploadProgress(bytesWritten, contentLength, done);
            }
          };
    }

    com.squareup.okhttp.Call call =
        androidUnionChannelPackagesAddValidateBeforeCall(
            data, progressListener, progressRequestListener);
    Type localVarReturnType = new TypeToken<AndroidUnionChannelPackagesAddResponse>() {}.getType();
    apiClient.executeAsync(call, localVarReturnType, callback);
    return call;
  }
  /**
   * Build call for androidUnionChannelPackagesGet
   *
   * @param accountId (required)
   * @param androidUnionAppId (required)
   * @param page (optional)
   * @param pageSize (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @param progressListener Progress listener
   * @param progressRequestListener Progress request listener
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   */
  public com.squareup.okhttp.Call androidUnionChannelPackagesGetCall(
      Long accountId,
      Long androidUnionAppId,
      Long page,
      Long pageSize,
      List<String> fields,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath = "/android_union_channel_packages/get";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    if (accountId != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("account_id", accountId));
    if (androidUnionAppId != null)
      localVarQueryParams.addAll(
          apiClient.parameterToPair("android_union_app_id", androidUnionAppId));
    if (page != null) localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
    if (pageSize != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("page_size", pageSize));
    if (fields != null)
      localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "fields", fields));

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();

    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

    final String[] localVarContentTypes = {"text/plain"};
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    if (progressListener != null) {
      apiClient
          .getHttpClient()
          .networkInterceptors()
          .add(
              new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(
                    com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                  com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                  return originalResponse
                      .newBuilder()
                      .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                      .build();
                }
              });
    }

    String[] localVarAuthNames = new String[] {"accessToken", "nonce", "timestamp"};
    return apiClient.buildCall(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAuthNames,
        progressRequestListener);
  }

  @SuppressWarnings("rawtypes")
  private com.squareup.okhttp.Call androidUnionChannelPackagesGetValidateBeforeCall(
      Long accountId,
      Long androidUnionAppId,
      Long page,
      Long pageSize,
      List<String> fields,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          "Missing the required parameter 'accountId' when calling androidUnionChannelPackagesGet(Async)");
    }

    // verify the required parameter 'androidUnionAppId' is set
    if (androidUnionAppId == null) {
      throw new ApiException(
          "Missing the required parameter 'androidUnionAppId' when calling androidUnionChannelPackagesGet(Async)");
    }

    com.squareup.okhttp.Call call =
        androidUnionChannelPackagesGetCall(
            accountId,
            androidUnionAppId,
            page,
            pageSize,
            fields,
            progressListener,
            progressRequestListener);
    return call;
  }

  /**
   * 获取广告渠道包
   *
   * @param accountId (required)
   * @param androidUnionAppId (required)
   * @param page (optional)
   * @param pageSize (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @return AndroidUnionChannelPackagesGetResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public AndroidUnionChannelPackagesGetResponse androidUnionChannelPackagesGet(
      Long accountId, Long androidUnionAppId, Long page, Long pageSize, List<String> fields)
      throws ApiException {
    ApiResponse<AndroidUnionChannelPackagesGetResponse> resp =
        androidUnionChannelPackagesGetWithHttpInfo(
            accountId, androidUnionAppId, page, pageSize, fields);
    return resp.getData();
  }

  /**
   * 获取广告渠道包
   *
   * @param accountId (required)
   * @param androidUnionAppId (required)
   * @param page (optional)
   * @param pageSize (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @return ApiResponse&lt;AndroidUnionChannelPackagesGetResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public ApiResponse<AndroidUnionChannelPackagesGetResponse>
      androidUnionChannelPackagesGetWithHttpInfo(
          Long accountId, Long androidUnionAppId, Long page, Long pageSize, List<String> fields)
          throws ApiException {
    com.squareup.okhttp.Call call =
        androidUnionChannelPackagesGetValidateBeforeCall(
            accountId, androidUnionAppId, page, pageSize, fields, null, null);
    Type localVarReturnType = new TypeToken<AndroidUnionChannelPackagesGetResponse>() {}.getType();
    return apiClient.execute(call, localVarReturnType);
  }

  /**
   * 获取广告渠道包 (asynchronously)
   *
   * @param accountId (required)
   * @param androidUnionAppId (required)
   * @param page (optional)
   * @param pageSize (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @param callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   */
  public com.squareup.okhttp.Call androidUnionChannelPackagesGetAsync(
      Long accountId,
      Long androidUnionAppId,
      Long page,
      Long pageSize,
      List<String> fields,
      final ApiCallback<AndroidUnionChannelPackagesGetResponse> callback)
      throws ApiException {

    ProgressResponseBody.ProgressListener progressListener = null;
    ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

    if (callback != null) {
      progressListener =
          new ProgressResponseBody.ProgressListener() {
            @Override
            public void update(long bytesRead, long contentLength, boolean done) {
              callback.onDownloadProgress(bytesRead, contentLength, done);
            }
          };

      progressRequestListener =
          new ProgressRequestBody.ProgressRequestListener() {
            @Override
            public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
              callback.onUploadProgress(bytesWritten, contentLength, done);
            }
          };
    }

    com.squareup.okhttp.Call call =
        androidUnionChannelPackagesGetValidateBeforeCall(
            accountId,
            androidUnionAppId,
            page,
            pageSize,
            fields,
            progressListener,
            progressRequestListener);
    Type localVarReturnType = new TypeToken<AndroidUnionChannelPackagesGetResponse>() {}.getType();
    apiClient.executeAsync(call, localVarReturnType, callback);
    return call;
  }
  /**
   * Build call for androidUnionChannelPackagesUpdate
   *
   * @param data (required)
   * @param progressListener Progress listener
   * @param progressRequestListener Progress request listener
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   */
  public com.squareup.okhttp.Call androidUnionChannelPackagesUpdateCall(
      AndroidUnionChannelPackagesUpdateRequest data,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {
    Object localVarPostBody = data;

    // create path and map variables
    String localVarPath = "/android_union_channel_packages/update";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();

    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

    final String[] localVarContentTypes = {"application/json", "application/xml"};
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    if (progressListener != null) {
      apiClient
          .getHttpClient()
          .networkInterceptors()
          .add(
              new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(
                    com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                  com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                  return originalResponse
                      .newBuilder()
                      .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                      .build();
                }
              });
    }

    String[] localVarAuthNames = new String[] {"accessToken", "nonce", "timestamp"};
    return apiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAuthNames,
        progressRequestListener);
  }

  @SuppressWarnings("rawtypes")
  private com.squareup.okhttp.Call androidUnionChannelPackagesUpdateValidateBeforeCall(
      AndroidUnionChannelPackagesUpdateRequest data,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {

    // verify the required parameter 'data' is set
    if (data == null) {
      throw new ApiException(
          "Missing the required parameter 'data' when calling androidUnionChannelPackagesUpdate(Async)");
    }

    com.squareup.okhttp.Call call =
        androidUnionChannelPackagesUpdateCall(data, progressListener, progressRequestListener);
    return call;
  }

  /**
   * 更新广告渠道包
   *
   * @param data (required)
   * @return AndroidUnionChannelPackagesUpdateResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public AndroidUnionChannelPackagesUpdateResponse androidUnionChannelPackagesUpdate(
      AndroidUnionChannelPackagesUpdateRequest data) throws ApiException {
    ApiResponse<AndroidUnionChannelPackagesUpdateResponse> resp =
        androidUnionChannelPackagesUpdateWithHttpInfo(data);
    return resp.getData();
  }

  /**
   * 更新广告渠道包
   *
   * @param data (required)
   * @return ApiResponse&lt;AndroidUnionChannelPackagesUpdateResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public ApiResponse<AndroidUnionChannelPackagesUpdateResponse>
      androidUnionChannelPackagesUpdateWithHttpInfo(AndroidUnionChannelPackagesUpdateRequest data)
          throws ApiException {
    com.squareup.okhttp.Call call =
        androidUnionChannelPackagesUpdateValidateBeforeCall(data, null, null);
    Type localVarReturnType =
        new TypeToken<AndroidUnionChannelPackagesUpdateResponse>() {}.getType();
    return apiClient.execute(call, localVarReturnType);
  }

  /**
   * 更新广告渠道包 (asynchronously)
   *
   * @param data (required)
   * @param callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   */
  public com.squareup.okhttp.Call androidUnionChannelPackagesUpdateAsync(
      AndroidUnionChannelPackagesUpdateRequest data,
      final ApiCallback<AndroidUnionChannelPackagesUpdateResponse> callback)
      throws ApiException {

    ProgressResponseBody.ProgressListener progressListener = null;
    ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

    if (callback != null) {
      progressListener =
          new ProgressResponseBody.ProgressListener() {
            @Override
            public void update(long bytesRead, long contentLength, boolean done) {
              callback.onDownloadProgress(bytesRead, contentLength, done);
            }
          };

      progressRequestListener =
          new ProgressRequestBody.ProgressRequestListener() {
            @Override
            public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
              callback.onUploadProgress(bytesWritten, contentLength, done);
            }
          };
    }

    com.squareup.okhttp.Call call =
        androidUnionChannelPackagesUpdateValidateBeforeCall(
            data, progressListener, progressRequestListener);
    Type localVarReturnType =
        new TypeToken<AndroidUnionChannelPackagesUpdateResponse>() {}.getType();
    apiClient.executeAsync(call, localVarReturnType, callback);
    return call;
  }
}
