/*
 * Marketing API
 * Marketing API
 *
 * OpenAPI spec version: 1.3
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.FilteringStruct;
import com.tencent.ads.model.OrderByStruct;
import com.tencent.ads.model.ReportDateRange;
import com.tencent.ads.model.TargetingTagReportsGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TargetingTagReportsApi {
  private ApiClient apiClient;

  public TargetingTagReportsApi() {
    this(Configuration.getDefaultApiClient());
  }

  public TargetingTagReportsApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Build call for targetingTagReportsGet
   *
   * @param accountId (required)
   * @param type (required)
   * @param level (required)
   * @param dateRange (required)
   * @param posType (optional)
   * @param filtering (optional)
   * @param groupBy (optional)
   * @param orderBy (optional)
   * @param page (optional)
   * @param pageSize (optional)
   * @param timeLine (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @param progressListener Progress listener
   * @param progressRequestListener Progress request listener
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   */
  public com.squareup.okhttp.Call targetingTagReportsGetCall(
      Long accountId,
      String type,
      String level,
      ReportDateRange dateRange,
      String posType,
      List<FilteringStruct> filtering,
      List<String> groupBy,
      List<OrderByStruct> orderBy,
      Long page,
      Long pageSize,
      String timeLine,
      List<String> fields,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath = "/targeting_tag_reports/get";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    if (accountId != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("account_id", accountId));
    if (type != null) localVarQueryParams.addAll(apiClient.parameterToPair("type", type));
    if (level != null) localVarQueryParams.addAll(apiClient.parameterToPair("level", level));
    if (dateRange != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("date_range", dateRange));
    if (posType != null) localVarQueryParams.addAll(apiClient.parameterToPair("pos_type", posType));
    if (filtering != null)
      localVarCollectionQueryParams.addAll(
          apiClient.parameterToPairs("multi", "filtering", filtering));
    if (groupBy != null)
      localVarCollectionQueryParams.addAll(
          apiClient.parameterToPairs("multi", "group_by", groupBy));
    if (orderBy != null)
      localVarCollectionQueryParams.addAll(
          apiClient.parameterToPairs("multi", "order_by", orderBy));
    if (page != null) localVarQueryParams.addAll(apiClient.parameterToPair("page", page));
    if (pageSize != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("page_size", pageSize));
    if (timeLine != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("time_line", timeLine));
    if (fields != null)
      localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "fields", fields));

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();

    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

    final String[] localVarContentTypes = {"text/plain"};
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    if (progressListener != null) {
      apiClient
          .getHttpClient()
          .networkInterceptors()
          .add(
              new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(
                    com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                  com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                  return originalResponse
                      .newBuilder()
                      .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                      .build();
                }
              });
    }

    String[] localVarAuthNames = new String[] {"accessToken", "nonce", "timestamp"};
    return apiClient.buildCall(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAuthNames,
        progressRequestListener);
  }

  @SuppressWarnings("rawtypes")
  private com.squareup.okhttp.Call targetingTagReportsGetValidateBeforeCall(
      Long accountId,
      String type,
      String level,
      ReportDateRange dateRange,
      String posType,
      List<FilteringStruct> filtering,
      List<String> groupBy,
      List<OrderByStruct> orderBy,
      Long page,
      Long pageSize,
      String timeLine,
      List<String> fields,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          "Missing the required parameter 'accountId' when calling targetingTagReportsGet(Async)");
    }

    // verify the required parameter 'type' is set
    if (type == null) {
      throw new ApiException(
          "Missing the required parameter 'type' when calling targetingTagReportsGet(Async)");
    }

    // verify the required parameter 'level' is set
    if (level == null) {
      throw new ApiException(
          "Missing the required parameter 'level' when calling targetingTagReportsGet(Async)");
    }

    // verify the required parameter 'dateRange' is set
    if (dateRange == null) {
      throw new ApiException(
          "Missing the required parameter 'dateRange' when calling targetingTagReportsGet(Async)");
    }

    com.squareup.okhttp.Call call =
        targetingTagReportsGetCall(
            accountId,
            type,
            level,
            dateRange,
            posType,
            filtering,
            groupBy,
            orderBy,
            page,
            pageSize,
            timeLine,
            fields,
            progressListener,
            progressRequestListener);
    return call;
  }

  /**
   * 获取定向标签报表
   *
   * @param accountId (required)
   * @param type (required)
   * @param level (required)
   * @param dateRange (required)
   * @param posType (optional)
   * @param filtering (optional)
   * @param groupBy (optional)
   * @param orderBy (optional)
   * @param page (optional)
   * @param pageSize (optional)
   * @param timeLine (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @return TargetingTagReportsGetResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public TargetingTagReportsGetResponse targetingTagReportsGet(
      Long accountId,
      String type,
      String level,
      ReportDateRange dateRange,
      String posType,
      List<FilteringStruct> filtering,
      List<String> groupBy,
      List<OrderByStruct> orderBy,
      Long page,
      Long pageSize,
      String timeLine,
      List<String> fields)
      throws ApiException {
    ApiResponse<TargetingTagReportsGetResponse> resp =
        targetingTagReportsGetWithHttpInfo(
            accountId, type, level, dateRange, posType, filtering, groupBy, orderBy, page, pageSize,
            timeLine, fields);
    return resp.getData();
  }

  /**
   * 获取定向标签报表
   *
   * @param accountId (required)
   * @param type (required)
   * @param level (required)
   * @param dateRange (required)
   * @param posType (optional)
   * @param filtering (optional)
   * @param groupBy (optional)
   * @param orderBy (optional)
   * @param page (optional)
   * @param pageSize (optional)
   * @param timeLine (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @return ApiResponse&lt;TargetingTagReportsGetResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public ApiResponse<TargetingTagReportsGetResponse> targetingTagReportsGetWithHttpInfo(
      Long accountId,
      String type,
      String level,
      ReportDateRange dateRange,
      String posType,
      List<FilteringStruct> filtering,
      List<String> groupBy,
      List<OrderByStruct> orderBy,
      Long page,
      Long pageSize,
      String timeLine,
      List<String> fields)
      throws ApiException {
    com.squareup.okhttp.Call call =
        targetingTagReportsGetValidateBeforeCall(
            accountId, type, level, dateRange, posType, filtering, groupBy, orderBy, page, pageSize,
            timeLine, fields, null, null);
    Type localVarReturnType = new TypeToken<TargetingTagReportsGetResponse>() {}.getType();
    return apiClient.execute(call, localVarReturnType);
  }

  /**
   * 获取定向标签报表 (asynchronously)
   *
   * @param accountId (required)
   * @param type (required)
   * @param level (required)
   * @param dateRange (required)
   * @param posType (optional)
   * @param filtering (optional)
   * @param groupBy (optional)
   * @param orderBy (optional)
   * @param page (optional)
   * @param pageSize (optional)
   * @param timeLine (optional)
   * @param fields 返回参数的字段列表 (optional)
   * @param callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   */
  public com.squareup.okhttp.Call targetingTagReportsGetAsync(
      Long accountId,
      String type,
      String level,
      ReportDateRange dateRange,
      String posType,
      List<FilteringStruct> filtering,
      List<String> groupBy,
      List<OrderByStruct> orderBy,
      Long page,
      Long pageSize,
      String timeLine,
      List<String> fields,
      final ApiCallback<TargetingTagReportsGetResponse> callback)
      throws ApiException {

    ProgressResponseBody.ProgressListener progressListener = null;
    ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

    if (callback != null) {
      progressListener =
          new ProgressResponseBody.ProgressListener() {
            @Override
            public void update(long bytesRead, long contentLength, boolean done) {
              callback.onDownloadProgress(bytesRead, contentLength, done);
            }
          };

      progressRequestListener =
          new ProgressRequestBody.ProgressRequestListener() {
            @Override
            public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
              callback.onUploadProgress(bytesWritten, contentLength, done);
            }
          };
    }

    com.squareup.okhttp.Call call =
        targetingTagReportsGetValidateBeforeCall(
            accountId,
            type,
            level,
            dateRange,
            posType,
            filtering,
            groupBy,
            orderBy,
            page,
            pageSize,
            timeLine,
            fields,
            progressListener,
            progressRequestListener);
    Type localVarReturnType = new TypeToken<TargetingTagReportsGetResponse>() {}.getType();
    apiClient.executeAsync(call, localVarReturnType, callback);
    return call;
  }
}
