/*
 * Marketing API
 * Marketing API
 *
 * OpenAPI spec version: 1.3
 *
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */

package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.WechatQualificationsAddResponse;
import com.tencent.ads.model.WechatQualificationsDeleteRequest;
import com.tencent.ads.model.WechatQualificationsDeleteResponse;
import com.tencent.ads.model.WechatQualificationsGetResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WechatQualificationsApi {
  private ApiClient apiClient;

  public WechatQualificationsApi() {
    this(Configuration.getDefaultApiClient());
  }

  public WechatQualificationsApi(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  public ApiClient getApiClient() {
    return apiClient;
  }

  public void setApiClient(ApiClient apiClient) {
    this.apiClient = apiClient;
  }

  /**
   * Build call for wechatQualificationsAdd
   *
   * @param accountId (required)
   * @param wechatQualificationType (required)
   * @param wechatQualificationFile (required)
   * @param wechatQualificationFileSignature (required)
   * @param progressListener Progress listener
   * @param progressRequestListener Progress request listener
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   */
  public com.squareup.okhttp.Call wechatQualificationsAddCall(
      Long accountId,
      String wechatQualificationType,
      File wechatQualificationFile,
      String wechatQualificationFileSignature,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath = "/wechat_qualifications/add";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();

    Map<String, Object> localVarFormParams = new HashMap<String, Object>();
    if (accountId != null) localVarFormParams.put("account_id", accountId);
    if (wechatQualificationType != null)
      localVarFormParams.put("wechat_qualification_type", wechatQualificationType);
    if (wechatQualificationFile != null)
      localVarFormParams.put("wechat_qualification_file", wechatQualificationFile);
    if (wechatQualificationFileSignature != null)
      localVarFormParams.put(
          "wechat_qualification_file_signature", wechatQualificationFileSignature);

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

    final String[] localVarContentTypes = {"multipart/form-data"};
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    if (progressListener != null) {
      apiClient
          .getHttpClient()
          .networkInterceptors()
          .add(
              new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(
                    com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                  com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                  return originalResponse
                      .newBuilder()
                      .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                      .build();
                }
              });
    }

    String[] localVarAuthNames = new String[] {"accessToken", "nonce", "timestamp"};
    return apiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAuthNames,
        progressRequestListener);
  }

  @SuppressWarnings("rawtypes")
  private com.squareup.okhttp.Call wechatQualificationsAddValidateBeforeCall(
      Long accountId,
      String wechatQualificationType,
      File wechatQualificationFile,
      String wechatQualificationFileSignature,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          "Missing the required parameter 'accountId' when calling wechatQualificationsAdd(Async)");
    }

    // verify the required parameter 'wechatQualificationType' is set
    if (wechatQualificationType == null) {
      throw new ApiException(
          "Missing the required parameter 'wechatQualificationType' when calling wechatQualificationsAdd(Async)");
    }

    // verify the required parameter 'wechatQualificationFile' is set
    if (wechatQualificationFile == null) {
      throw new ApiException(
          "Missing the required parameter 'wechatQualificationFile' when calling wechatQualificationsAdd(Async)");
    }

    // verify the required parameter 'wechatQualificationFileSignature' is set
    if (wechatQualificationFileSignature == null) {
      throw new ApiException(
          "Missing the required parameter 'wechatQualificationFileSignature' when calling wechatQualificationsAdd(Async)");
    }

    com.squareup.okhttp.Call call =
        wechatQualificationsAddCall(
            accountId,
            wechatQualificationType,
            wechatQualificationFile,
            wechatQualificationFileSignature,
            progressListener,
            progressRequestListener);
    return call;
  }

  /**
   * 添加附近推商家资质
   *
   * @param accountId (required)
   * @param wechatQualificationType (required)
   * @param wechatQualificationFile (required)
   * @param wechatQualificationFileSignature (required)
   * @return WechatQualificationsAddResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public WechatQualificationsAddResponse wechatQualificationsAdd(
      Long accountId,
      String wechatQualificationType,
      File wechatQualificationFile,
      String wechatQualificationFileSignature)
      throws ApiException {
    ApiResponse<WechatQualificationsAddResponse> resp =
        wechatQualificationsAddWithHttpInfo(
            accountId,
            wechatQualificationType,
            wechatQualificationFile,
            wechatQualificationFileSignature);
    return resp.getData();
  }

  /**
   * 添加附近推商家资质
   *
   * @param accountId (required)
   * @param wechatQualificationType (required)
   * @param wechatQualificationFile (required)
   * @param wechatQualificationFileSignature (required)
   * @return ApiResponse&lt;WechatQualificationsAddResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public ApiResponse<WechatQualificationsAddResponse> wechatQualificationsAddWithHttpInfo(
      Long accountId,
      String wechatQualificationType,
      File wechatQualificationFile,
      String wechatQualificationFileSignature)
      throws ApiException {
    com.squareup.okhttp.Call call =
        wechatQualificationsAddValidateBeforeCall(
            accountId,
            wechatQualificationType,
            wechatQualificationFile,
            wechatQualificationFileSignature,
            null,
            null);
    Type localVarReturnType = new TypeToken<WechatQualificationsAddResponse>() {}.getType();
    return apiClient.execute(call, localVarReturnType);
  }

  /**
   * 添加附近推商家资质 (asynchronously)
   *
   * @param accountId (required)
   * @param wechatQualificationType (required)
   * @param wechatQualificationFile (required)
   * @param wechatQualificationFileSignature (required)
   * @param callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   */
  public com.squareup.okhttp.Call wechatQualificationsAddAsync(
      Long accountId,
      String wechatQualificationType,
      File wechatQualificationFile,
      String wechatQualificationFileSignature,
      final ApiCallback<WechatQualificationsAddResponse> callback)
      throws ApiException {

    ProgressResponseBody.ProgressListener progressListener = null;
    ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

    if (callback != null) {
      progressListener =
          new ProgressResponseBody.ProgressListener() {
            @Override
            public void update(long bytesRead, long contentLength, boolean done) {
              callback.onDownloadProgress(bytesRead, contentLength, done);
            }
          };

      progressRequestListener =
          new ProgressRequestBody.ProgressRequestListener() {
            @Override
            public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
              callback.onUploadProgress(bytesWritten, contentLength, done);
            }
          };
    }

    com.squareup.okhttp.Call call =
        wechatQualificationsAddValidateBeforeCall(
            accountId,
            wechatQualificationType,
            wechatQualificationFile,
            wechatQualificationFileSignature,
            progressListener,
            progressRequestListener);
    Type localVarReturnType = new TypeToken<WechatQualificationsAddResponse>() {}.getType();
    apiClient.executeAsync(call, localVarReturnType, callback);
    return call;
  }
  /**
   * Build call for wechatQualificationsDelete
   *
   * @param data (required)
   * @param progressListener Progress listener
   * @param progressRequestListener Progress request listener
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   */
  public com.squareup.okhttp.Call wechatQualificationsDeleteCall(
      WechatQualificationsDeleteRequest data,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {
    Object localVarPostBody = data;

    // create path and map variables
    String localVarPath = "/wechat_qualifications/delete";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();

    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

    final String[] localVarContentTypes = {"application/json", "application/xml"};
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    if (progressListener != null) {
      apiClient
          .getHttpClient()
          .networkInterceptors()
          .add(
              new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(
                    com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                  com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                  return originalResponse
                      .newBuilder()
                      .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                      .build();
                }
              });
    }

    String[] localVarAuthNames = new String[] {"accessToken", "nonce", "timestamp"};
    return apiClient.buildCall(
        localVarPath,
        "POST",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAuthNames,
        progressRequestListener);
  }

  @SuppressWarnings("rawtypes")
  private com.squareup.okhttp.Call wechatQualificationsDeleteValidateBeforeCall(
      WechatQualificationsDeleteRequest data,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {

    // verify the required parameter 'data' is set
    if (data == null) {
      throw new ApiException(
          "Missing the required parameter 'data' when calling wechatQualificationsDelete(Async)");
    }

    com.squareup.okhttp.Call call =
        wechatQualificationsDeleteCall(data, progressListener, progressRequestListener);
    return call;
  }

  /**
   * 删除附近推商家资质
   *
   * @param data (required)
   * @return WechatQualificationsDeleteResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public WechatQualificationsDeleteResponse wechatQualificationsDelete(
      WechatQualificationsDeleteRequest data) throws ApiException {
    ApiResponse<WechatQualificationsDeleteResponse> resp =
        wechatQualificationsDeleteWithHttpInfo(data);
    return resp.getData();
  }

  /**
   * 删除附近推商家资质
   *
   * @param data (required)
   * @return ApiResponse&lt;WechatQualificationsDeleteResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public ApiResponse<WechatQualificationsDeleteResponse> wechatQualificationsDeleteWithHttpInfo(
      WechatQualificationsDeleteRequest data) throws ApiException {
    com.squareup.okhttp.Call call = wechatQualificationsDeleteValidateBeforeCall(data, null, null);
    Type localVarReturnType = new TypeToken<WechatQualificationsDeleteResponse>() {}.getType();
    return apiClient.execute(call, localVarReturnType);
  }

  /**
   * 删除附近推商家资质 (asynchronously)
   *
   * @param data (required)
   * @param callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   */
  public com.squareup.okhttp.Call wechatQualificationsDeleteAsync(
      WechatQualificationsDeleteRequest data,
      final ApiCallback<WechatQualificationsDeleteResponse> callback)
      throws ApiException {

    ProgressResponseBody.ProgressListener progressListener = null;
    ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

    if (callback != null) {
      progressListener =
          new ProgressResponseBody.ProgressListener() {
            @Override
            public void update(long bytesRead, long contentLength, boolean done) {
              callback.onDownloadProgress(bytesRead, contentLength, done);
            }
          };

      progressRequestListener =
          new ProgressRequestBody.ProgressRequestListener() {
            @Override
            public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
              callback.onUploadProgress(bytesWritten, contentLength, done);
            }
          };
    }

    com.squareup.okhttp.Call call =
        wechatQualificationsDeleteValidateBeforeCall(
            data, progressListener, progressRequestListener);
    Type localVarReturnType = new TypeToken<WechatQualificationsDeleteResponse>() {}.getType();
    apiClient.executeAsync(call, localVarReturnType, callback);
    return call;
  }
  /**
   * Build call for wechatQualificationsGet
   *
   * @param accountId (required)
   * @param fields 返回参数的字段列表 (optional)
   * @param progressListener Progress listener
   * @param progressRequestListener Progress request listener
   * @return Call to execute
   * @throws ApiException If fail to serialize the request body object
   */
  public com.squareup.okhttp.Call wechatQualificationsGetCall(
      Long accountId,
      List<String> fields,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {
    Object localVarPostBody = null;

    // create path and map variables
    String localVarPath = "/wechat_qualifications/get";

    List<Pair> localVarQueryParams = new ArrayList<Pair>();
    List<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
    if (accountId != null)
      localVarQueryParams.addAll(apiClient.parameterToPair("account_id", accountId));
    if (fields != null)
      localVarCollectionQueryParams.addAll(apiClient.parameterToPairs("multi", "fields", fields));

    Map<String, String> localVarHeaderParams = new HashMap<String, String>();

    Map<String, Object> localVarFormParams = new HashMap<String, Object>();

    final String[] localVarAccepts = {"application/json"};
    final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
    if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

    final String[] localVarContentTypes = {"text/plain"};
    final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
    localVarHeaderParams.put("Content-Type", localVarContentType);

    if (progressListener != null) {
      apiClient
          .getHttpClient()
          .networkInterceptors()
          .add(
              new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(
                    com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                  com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                  return originalResponse
                      .newBuilder()
                      .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                      .build();
                }
              });
    }

    String[] localVarAuthNames = new String[] {"accessToken", "nonce", "timestamp"};
    return apiClient.buildCall(
        localVarPath,
        "GET",
        localVarQueryParams,
        localVarCollectionQueryParams,
        localVarPostBody,
        localVarHeaderParams,
        localVarFormParams,
        localVarAuthNames,
        progressRequestListener);
  }

  @SuppressWarnings("rawtypes")
  private com.squareup.okhttp.Call wechatQualificationsGetValidateBeforeCall(
      Long accountId,
      List<String> fields,
      final ProgressResponseBody.ProgressListener progressListener,
      final ProgressRequestBody.ProgressRequestListener progressRequestListener)
      throws ApiException {

    // verify the required parameter 'accountId' is set
    if (accountId == null) {
      throw new ApiException(
          "Missing the required parameter 'accountId' when calling wechatQualificationsGet(Async)");
    }

    com.squareup.okhttp.Call call =
        wechatQualificationsGetCall(accountId, fields, progressListener, progressRequestListener);
    return call;
  }

  /**
   * 查询附近推商家资质信息
   *
   * @param accountId (required)
   * @param fields 返回参数的字段列表 (optional)
   * @return WechatQualificationsGetResponse
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public WechatQualificationsGetResponse wechatQualificationsGet(
      Long accountId, List<String> fields) throws ApiException {
    ApiResponse<WechatQualificationsGetResponse> resp =
        wechatQualificationsGetWithHttpInfo(accountId, fields);
    return resp.getData();
  }

  /**
   * 查询附近推商家资质信息
   *
   * @param accountId (required)
   * @param fields 返回参数的字段列表 (optional)
   * @return ApiResponse&lt;WechatQualificationsGetResponse&gt;
   * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the
   *     response body
   */
  public ApiResponse<WechatQualificationsGetResponse> wechatQualificationsGetWithHttpInfo(
      Long accountId, List<String> fields) throws ApiException {
    com.squareup.okhttp.Call call =
        wechatQualificationsGetValidateBeforeCall(accountId, fields, null, null);
    Type localVarReturnType = new TypeToken<WechatQualificationsGetResponse>() {}.getType();
    return apiClient.execute(call, localVarReturnType);
  }

  /**
   * 查询附近推商家资质信息 (asynchronously)
   *
   * @param accountId (required)
   * @param fields 返回参数的字段列表 (optional)
   * @param callback The callback to be executed when the API call finishes
   * @return The request call
   * @throws ApiException If fail to process the API call, e.g. serializing the request body object
   */
  public com.squareup.okhttp.Call wechatQualificationsGetAsync(
      Long accountId,
      List<String> fields,
      final ApiCallback<WechatQualificationsGetResponse> callback)
      throws ApiException {

    ProgressResponseBody.ProgressListener progressListener = null;
    ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

    if (callback != null) {
      progressListener =
          new ProgressResponseBody.ProgressListener() {
            @Override
            public void update(long bytesRead, long contentLength, boolean done) {
              callback.onDownloadProgress(bytesRead, contentLength, done);
            }
          };

      progressRequestListener =
          new ProgressRequestBody.ProgressRequestListener() {
            @Override
            public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
              callback.onUploadProgress(bytesWritten, contentLength, done);
            }
          };
    }

    com.squareup.okhttp.Call call =
        wechatQualificationsGetValidateBeforeCall(
            accountId, fields, progressListener, progressRequestListener);
    Type localVarReturnType = new TypeToken<WechatQualificationsGetResponse>() {}.getType();
    apiClient.executeAsync(call, localVarReturnType, callback);
    return call;
  }
}
