package com.tencent.ads.examples.BasicOperations.Account;

import com.tencent.ads.ApiContextConfig;
import com.tencent.ads.TencentAds;
import com.tencent.ads.exception.TencentAdsResponseException;
import com.tencent.ads.exception.TencentAdsSDKException;
import com.tencent.ads.model.*;
import com.tencent.ads.model.QualificationsDeleteRequest;

public class DeleteQualifications {
  /** YOUR ACCESS TOKEN */
  public String ACCESS_TOKEN = "YOUR ACCESS TOKEN";

  /** TencentAds */
  public TencentAds tencentAds;

  public Long accountId = null;
  public QualificationsDeleteRequest data = new QualificationsDeleteRequest();
  public Long qualificationId = null;
  public QualificationType qualificationType = QualificationType.ADDITIONAL_INDUSTRY_QUALIFICATION;

  public void init() {
    this.tencentAds = TencentAds.getInstance();
    this.tencentAds.init(
        new ApiContextConfig().accessToken(ACCESS_TOKEN).isDebug(true)); // debug==true 会打印请求详细信息
    this.tencentAds.useSandbox(); // 默认使用沙箱环境，如果要请求线上，这里需要设为线上环境
    this.buildParams();
  }

  public void buildParams() {
    data.setAccountId(accountId);

    data.setQualificationId(qualificationId);

    data.setQualificationType(qualificationType);
  }

  public QualificationsDeleteResponseData deleteQualifications() throws Exception {
    QualificationsDeleteResponseData response =
        tencentAds.qualifications().qualificationsDelete(data);
    return response;
  }

  public static void main(String[] args) {
    try {
      DeleteQualifications deleteQualifications = new DeleteQualifications();
      deleteQualifications.init();
      QualificationsDeleteResponseData response = deleteQualifications.deleteQualifications();
    } catch (TencentAdsResponseException e) {
      e.printStackTrace();
    } catch (TencentAdsSDKException e) {
      e.printStackTrace();
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}
