/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ads.api;

import com.google.gson.reflect.TypeToken;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import com.tencent.ads.ApiCallback;
import com.tencent.ads.ApiClient;
import com.tencent.ads.ApiException;
import com.tencent.ads.ApiResponse;
import com.tencent.ads.Configuration;
import com.tencent.ads.Pair;
import com.tencent.ads.ProgressRequestBody;
import com.tencent.ads.ProgressResponseBody;
import com.tencent.ads.model.CreativetoolsTextGetResponse;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CreativetoolsTextApi {
    private ApiClient apiClient;

    public CreativetoolsTextApi() {
        this(Configuration.getDefaultApiClient());
    }

    public CreativetoolsTextApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public Call creativetoolsTextGetCall(Long accountId, Long maxTextLength, Long categoryFirstLevel, Long categorySecondLevel, String keyword, Long filtering, Long number, List<String> fields, final ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/creativetools_text/get";
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        if (accountId != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("account_id", accountId));
        }
        if (maxTextLength != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("max_text_length", maxTextLength));
        }
        if (categoryFirstLevel != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("category_first_level", categoryFirstLevel));
        }
        if (categorySecondLevel != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("category_second_level", categorySecondLevel));
        }
        if (keyword != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("keyword", keyword));
        }
        if (filtering != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("filtering", filtering));
        }
        if (number != null) {
            localVarQueryParams.addAll(this.apiClient.parameterToPair("number", number));
        }
        if (fields != null) {
            localVarCollectionQueryParams.addAll(this.apiClient.parameterToPairs("multi", "fields", fields));
        }
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"text/plain"};
        String localVarContentType = this.apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        if (progressListener != null) {
            this.apiClient.getHttpClient().networkInterceptors().add(new Interceptor(){

                public Response intercept(Interceptor.Chain chain) throws IOException {
                    Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originalResponse.body(), progressListener)).build();
                }
            });
        }
        String[] localVarAuthNames = new String[]{"accessToken", "nonce", "timestamp"};
        return this.apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    private Call creativetoolsTextGetValidateBeforeCall(Long accountId, Long maxTextLength, Long categoryFirstLevel, Long categorySecondLevel, String keyword, Long filtering, Long number, List<String> fields, ProgressResponseBody.ProgressListener progressListener, ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        if (accountId == null) {
            throw new ApiException("Missing the required parameter 'accountId' when calling creativetoolsTextGet(Async)");
        }
        if (maxTextLength == null) {
            throw new ApiException("Missing the required parameter 'maxTextLength' when calling creativetoolsTextGet(Async)");
        }
        Call call = this.creativetoolsTextGetCall(accountId, maxTextLength, categoryFirstLevel, categorySecondLevel, keyword, filtering, number, fields, progressListener, progressRequestListener);
        return call;
    }

    public CreativetoolsTextGetResponse creativetoolsTextGet(Long accountId, Long maxTextLength, Long categoryFirstLevel, Long categorySecondLevel, String keyword, Long filtering, Long number, List<String> fields) throws ApiException {
        ApiResponse<CreativetoolsTextGetResponse> resp = this.creativetoolsTextGetWithHttpInfo(accountId, maxTextLength, categoryFirstLevel, categorySecondLevel, keyword, filtering, number, fields);
        return resp.getData();
    }

    public ApiResponse<CreativetoolsTextGetResponse> creativetoolsTextGetWithHttpInfo(Long accountId, Long maxTextLength, Long categoryFirstLevel, Long categorySecondLevel, String keyword, Long filtering, Long number, List<String> fields) throws ApiException {
        Call call = this.creativetoolsTextGetValidateBeforeCall(accountId, maxTextLength, categoryFirstLevel, categorySecondLevel, keyword, filtering, number, fields, null, null);
        Type localVarReturnType = new TypeToken<CreativetoolsTextGetResponse>(){}.getType();
        return this.apiClient.execute(call, localVarReturnType);
    }

    public Call creativetoolsTextGetAsync(Long accountId, Long maxTextLength, Long categoryFirstLevel, Long categorySecondLevel, String keyword, Long filtering, Long number, List<String> fields, final ApiCallback<CreativetoolsTextGetResponse> callback) throws ApiException {
        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;
        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener(){

                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };
            progressRequestListener = new ProgressRequestBody.ProgressRequestListener(){

                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }
        Call call = this.creativetoolsTextGetValidateBeforeCall(accountId, maxTextLength, categoryFirstLevel, categorySecondLevel, keyword, filtering, number, fields, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<CreativetoolsTextGetResponse>(){}.getType();
        this.apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}

