/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.message.JoinGroupResponseData;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.ApiKeys;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.Errors;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.protocol.types.Struct;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.common.requests.AbstractResponse;
import java.nio.ByteBuffer;
import java.util.Map;

public class JoinGroupResponse
extends AbstractResponse {
    private final JoinGroupResponseData data;

    public JoinGroupResponse(JoinGroupResponseData data) {
        this.data = data;
    }

    public JoinGroupResponse(Struct struct) {
        short latestVersion = (short)(JoinGroupResponseData.SCHEMAS.length - 1);
        this.data = new JoinGroupResponseData(struct, latestVersion);
    }

    public JoinGroupResponse(Struct struct, short version) {
        this.data = new JoinGroupResponseData(struct, version);
    }

    public JoinGroupResponseData data() {
        return this.data;
    }

    public boolean isLeader() {
        return this.data.memberId().equals(this.data.leader());
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    public Errors error() {
        return Errors.forCode(this.data.errorCode());
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(Errors.forCode(this.data.errorCode()));
    }

    public static JoinGroupResponse parse(ByteBuffer buffer, short versionId) {
        return new JoinGroupResponse(ApiKeys.JOIN_GROUP.parseResponse(versionId, buffer), versionId);
    }

    @Override
    protected Struct toStruct(short version) {
        return this.data.toStruct(version);
    }

    public String toString() {
        return this.data.toString();
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 3;
    }
}

