/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.fault;

import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonCreator;
import com.ververica.cdc.connectors.shaded.com.fasterxml.jackson.annotation.JsonProperty;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.fault.NetworkPartitionFaultController;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.fault.NetworkPartitionFaultWorker;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.task.TaskController;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.task.TaskSpec;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.trogdor.task.TaskWorker;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class NetworkPartitionFaultSpec
extends TaskSpec {
    private final List<List<String>> partitions;

    @JsonCreator
    public NetworkPartitionFaultSpec(@JsonProperty(value="startMs") long startMs, @JsonProperty(value="durationMs") long durationMs, @JsonProperty(value="partitions") List<List<String>> partitions) {
        super(startMs, durationMs);
        this.partitions = partitions == null ? new ArrayList() : partitions;
    }

    @JsonProperty
    public List<List<String>> partitions() {
        return this.partitions;
    }

    @Override
    public TaskController newController(String id) {
        return new NetworkPartitionFaultController(this.partitionSets());
    }

    @Override
    public TaskWorker newTaskWorker(String id) {
        return new NetworkPartitionFaultWorker(id, this.partitionSets());
    }

    private List<Set<String>> partitionSets() {
        ArrayList<Set<String>> partitionSets = new ArrayList<Set<String>>();
        HashSet<String> prevNodes = new HashSet<String>();
        for (List<String> partition : this.partitions()) {
            for (String nodeName : partition) {
                if (prevNodes.contains(nodeName)) {
                    throw new RuntimeException("Node " + nodeName + " appears in more than one partition.");
                }
                prevNodes.add(nodeName);
                partitionSets.add(new HashSet<String>(partition));
            }
        }
        return partitionSets;
    }
}

