/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.postgresql.connection;

import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Field;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Schema;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.SchemaBuilder;
import com.ververica.cdc.connectors.shaded.org.apache.kafka.connect.data.Struct;
import io.debezium.annotation.ThreadSafe;
import io.debezium.connector.postgresql.PostgresValueConverter;
import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.postgresql.jdbc.TimestampUtils;
import org.postgresql.util.PGInterval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
class PostgresDefaultValueConverter {
    private static Logger LOGGER = LoggerFactory.getLogger(PostgresDefaultValueConverter.class);
    private static final Pattern LITERAL_DEFAULT_PATTERN = Pattern.compile("'(.*?)'");
    private static final Pattern FUNCTION_DEFAULT_PATTERN = Pattern.compile("^[(]?[A-Za-z0-9_]+\\((?:.+(?:, ?.+)*)?\\)");
    private final PostgresValueConverter valueConverters;
    private final Map<String, DefaultValueMapper> defaultValueMappers;

    PostgresDefaultValueConverter(PostgresValueConverter valueConverters, TimestampUtils timestampUtils) {
        this.valueConverters = valueConverters;
        this.defaultValueMappers = Collections.unmodifiableMap(PostgresDefaultValueConverter.createDefaultValueMappers(timestampUtils));
    }

    Optional<Object> parseDefaultValue(Column column, String defaultValue) {
        String dataType = column.typeName();
        DefaultValueMapper mapper = this.defaultValueMappers.get(dataType);
        if (mapper == null) {
            LOGGER.warn("Mapper for type '{}' not found.", (Object)dataType);
            return Optional.empty();
        }
        try {
            Object rawDefaultValue = mapper.parse(defaultValue);
            Object convertedDefaultValue = this.convertDefaultValue(rawDefaultValue, column);
            if (convertedDefaultValue instanceof Struct) {
                LOGGER.warn("Struct can't be used as default value for column '{}', will use null instead.", (Object)column.name());
                return Optional.empty();
            }
            return Optional.of(convertedDefaultValue);
        }
        catch (Exception e) {
            LOGGER.warn("Cannot parse column default value '{}' to type '{}'. Expression evaluation is not supported.", (Object)defaultValue, (Object)dataType);
            LOGGER.debug("Parsing failed due to error", (Throwable)e);
            return Optional.empty();
        }
    }

    private Object convertDefaultValue(Object defaultValue, Column column) {
        if (this.valueConverters != null && defaultValue != null) {
            SchemaBuilder schemaBuilder = this.valueConverters.schemaBuilder(column);
            if (schemaBuilder == null) {
                return defaultValue;
            }
            Schema schema = schemaBuilder.build();
            Field field = new Field(column.name(), -1, schema);
            ValueConverter valueConverter = this.valueConverters.converter(column, field);
            Object result = valueConverter.convert(defaultValue);
            if (result instanceof BigDecimal && column.scale().isPresent() && column.scale().get() > ((BigDecimal)result).scale()) {
                result = ((BigDecimal)result).setScale((int)column.scale().get(), RoundingMode.HALF_EVEN);
            }
            return result;
        }
        return defaultValue;
    }

    private static Map<String, DefaultValueMapper> createDefaultValueMappers(TimestampUtils timestampUtils) {
        HashMap<String, DefaultValueMapper> result = new HashMap<String, DefaultValueMapper>();
        result.put("bit", v -> {
            String defaultValue = PostgresDefaultValueConverter.extractDefault(v, "00");
            if (defaultValue.length() == 1) {
                return "1".equals(defaultValue);
            }
            return defaultValue;
        });
        result.put("varbit", v -> PostgresDefaultValueConverter.extractDefault(v, "0"));
        result.put("bool", v -> Boolean.parseBoolean(PostgresDefaultValueConverter.extractDefault(v, "false")));
        result.put("bpchar", v -> PostgresDefaultValueConverter.extractDefault(v, ""));
        result.put("varchar", v -> PostgresDefaultValueConverter.extractDefault(v, ""));
        result.put("text", v -> PostgresDefaultValueConverter.extractDefault(v, ""));
        result.put("numeric", v -> new BigDecimal(PostgresDefaultValueConverter.extractDefault(v, "0.0")));
        result.put("float4", v -> Float.valueOf(Float.parseFloat(PostgresDefaultValueConverter.extractDefault(v, "0.0"))));
        result.put("float8", v -> Double.parseDouble(PostgresDefaultValueConverter.extractDefault(v, "0.0")));
        result.put("int2", v -> Short.parseShort(PostgresDefaultValueConverter.extractDefault(v, "0")));
        result.put("int4", v -> Integer.parseInt(PostgresDefaultValueConverter.extractDefault(v, "0")));
        result.put("serial", v -> Integer.parseInt(PostgresDefaultValueConverter.extractDefault(v, "0")));
        result.put("int8", v -> Long.parseLong(PostgresDefaultValueConverter.extractDefault(v, "0")));
        result.put("bigserial", v -> Long.parseLong(PostgresDefaultValueConverter.extractDefault(v, "0")));
        result.put("json", v -> PostgresDefaultValueConverter.extractDefault(v, "{}"));
        result.put("jsonb", v -> PostgresDefaultValueConverter.extractDefault(v, "{}"));
        result.put("xml", v -> PostgresDefaultValueConverter.extractDefault(v, ""));
        result.put("uuid", v -> UUID.fromString(PostgresDefaultValueConverter.extractDefault(v, "00000000-0000-0000-0000-000000000000")));
        result.put("date", v -> timestampUtils.toLocalDateTime(PostgresDefaultValueConverter.extractDefault(v, "1970-01-01")));
        result.put("time", v -> timestampUtils.toLocalTime(PostgresDefaultValueConverter.extractDefault(v, "00:00")));
        result.put("timestamp", v -> timestampUtils.toOffsetDateTime(PostgresDefaultValueConverter.extractDefault(v, "1970-01-01")));
        result.put("timestamptz", v -> timestampUtils.toOffsetDateTime(PostgresDefaultValueConverter.extractDefault(v, "1970-01-01")));
        result.put("interval", v -> new PGInterval(PostgresDefaultValueConverter.extractDefault(v, "epoch")));
        return result;
    }

    private static String extractDefault(String defaultValue) {
        if (!defaultValue.contains("'")) {
            return defaultValue;
        }
        Matcher matcher = LITERAL_DEFAULT_PATTERN.matcher(defaultValue);
        matcher.find();
        return matcher.group(1);
    }

    private static String extractDefault(String defaultValue, String generatedValuePlaceholder) {
        Matcher functionMatcher = FUNCTION_DEFAULT_PATTERN.matcher(defaultValue);
        if (functionMatcher.find()) {
            return generatedValuePlaceholder;
        }
        return PostgresDefaultValueConverter.extractDefault(defaultValue);
    }

    @FunctionalInterface
    private static interface DefaultValueMapper {
        public Object parse(String var1) throws Exception;
    }
}

