/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.config.springsupport;

import com.weibo.api.motan.config.BasicRefererInterfaceConfig;
import com.weibo.api.motan.config.ProtocolConfig;
import com.weibo.api.motan.config.RegistryConfig;
import com.weibo.api.motan.config.springsupport.MotanNamespaceHandler;
import com.weibo.api.motan.config.springsupport.util.SpringBeanUtil;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;

public class BasicRefererConfigBean
extends BasicRefererInterfaceConfig
implements BeanNameAware,
InitializingBean,
BeanFactoryAware {
    private String protocolNames;
    private String registryNames;
    private BeanFactory beanFactory;

    public void setBeanName(String name) {
        this.setId(name);
        MotanNamespaceHandler.basicRefererConfigDefineNames.add(name);
    }

    public void setProtocol(String protocolNames) {
        this.protocolNames = protocolNames;
    }

    public void setRegistry(String registryNames) {
        this.registryNames = registryNames;
    }

    public void afterPropertiesSet() throws Exception {
        this.setRegistries(this.extractRegistries(this.registryNames, this.beanFactory));
        this.setProtocols(this.extractProtocols(this.protocolNames, this.beanFactory));
    }

    public List<ProtocolConfig> extractProtocols(String protocols, BeanFactory beanFactory) {
        if (protocols != null && protocols.length() > 0) {
            List<ProtocolConfig> protocolConfigList = SpringBeanUtil.getMultiBeans(beanFactory, protocols, "\\s*[,]+\\s*", ProtocolConfig.class);
            return protocolConfigList;
        }
        return null;
    }

    public List<RegistryConfig> extractRegistries(String registries, BeanFactory beanFactory) {
        if (registries != null && registries.length() > 0) {
            List<RegistryConfig> registryConfigList = SpringBeanUtil.getMultiBeans(beanFactory, registries, "\\s*[,]+\\s*", RegistryConfig.class);
            return registryConfigList;
        }
        return null;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setCheck(boolean value) {
        this.setCheck(String.valueOf(value));
    }

    public void setAccessLog(boolean value) {
        this.setAccessLog(String.valueOf(value));
    }
}

