/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import de.codecentric.boot.admin.config.AdminServerProperties;
import de.codecentric.boot.admin.config.AdminServerWebConfiguration;
import de.codecentric.boot.admin.event.RoutesOutdatedEvent;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import de.codecentric.boot.admin.zuul.ApplicationRouteLocator;
import de.codecentric.boot.admin.zuul.PreDecorationFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.trace.TraceRepository;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.cloud.netflix.zuul.ZuulConfiguration;
import org.springframework.cloud.netflix.zuul.filters.ProxyRequestHelper;
import org.springframework.cloud.netflix.zuul.filters.route.SimpleHostRoutingFilter;
import org.springframework.cloud.netflix.zuul.web.ZuulHandlerMapping;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.PayloadApplicationEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureAfter(value={AdminServerWebConfiguration.class})
public class RevereseZuulProxyConfiguration
extends ZuulConfiguration {
    @Autowired(required=false)
    private TraceRepository traces;
    @Autowired
    private ServerProperties server;
    @Autowired
    private ApplicationRegistry registry;
    @Autowired
    private AdminServerProperties adminServer;

    @Bean
    public ApplicationRouteLocator routeLocator() {
        return new ApplicationRouteLocator(this.server.getServletPrefix(), this.registry, this.adminServer.getContextPath() + "/api/applications");
    }

    @Bean
    public PreDecorationFilter preDecorationFilter() {
        return new PreDecorationFilter(this.routeLocator(), true);
    }

    @Bean
    public SimpleHostRoutingFilter simpleHostRoutingFilter() {
        ProxyRequestHelper helper = new ProxyRequestHelper();
        if (this.traces != null) {
            helper.setTraces(this.traces);
        }
        return new SimpleHostRoutingFilter(helper);
    }

    @Bean
    public ApplicationListener<ApplicationEvent> zuulRefreshRoutesListener() {
        return new ZuulRefreshListener();
    }

    private static class ZuulRefreshListener
    implements ApplicationListener<ApplicationEvent> {
        @Autowired
        private ZuulHandlerMapping zuulHandlerMapping;
        @Autowired
        private ApplicationRouteLocator routeLocator;

        private ZuulRefreshListener() {
        }

        public void onApplicationEvent(ApplicationEvent event) {
            if (event instanceof PayloadApplicationEvent && ((PayloadApplicationEvent)event).getPayload() instanceof RoutesOutdatedEvent) {
                this.routeLocator.resetRoutes();
                this.zuulHandlerMapping.registerHandlers();
            }
        }
    }
}

