/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notify;

import de.codecentric.boot.admin.event.ClientApplicationStatusChangedEvent;
import de.codecentric.boot.admin.model.StatusInfo;
import de.codecentric.boot.admin.notify.AbstractNotifier;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.web.client.RestTemplate;

public class PagerdutyNotifier
extends AbstractNotifier {
    public static final URI DEFAULT_URI = URI.create("https://events.pagerduty.com/generic/2010-04-15/create_event.json");
    private static final String DEFAULT_DESCRIPTION = "#{application.name}/#{application.id} is #{to.status}";
    private final SpelExpressionParser parser = new SpelExpressionParser();
    private RestTemplate restTemplate = new RestTemplate();
    private URI url = DEFAULT_URI;
    private String serviceKey;
    private String client;
    private URI clientUrl;
    private Expression description = this.parser.parseExpression("#{application.name}/#{application.id} is #{to.status}", ParserContext.TEMPLATE_EXPRESSION);

    @Override
    protected void notify(ClientApplicationStatusChangedEvent event) throws Exception {
        this.restTemplate.postForEntity(this.url, this.createPagerdutyEvent(event), Void.class);
    }

    private Map<String, Object> createPagerdutyEvent(ClientApplicationStatusChangedEvent event) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("service_key", this.serviceKey);
        result.put("incident_key", event.getApplication().getName() + "/" + event.getApplication().getId());
        result.put("description", this.description.getValue((Object)event, String.class));
        HashMap<String, StatusInfo> details = new HashMap<String, StatusInfo>();
        details.put("from", event.getFrom());
        details.put("to", event.getTo());
        result.put("details", details);
        if ("UP".equals(event.getTo().getStatus())) {
            result.put("event_type", "resolve");
        } else {
            result.put("event_type", "trigger");
            if (this.client != null) {
                result.put("client", this.client);
            }
            if (this.clientUrl != null) {
                result.put("client_url", this.clientUrl);
            }
            HashMap<String, String> context = new HashMap<String, String>();
            context.put("type", "link");
            context.put("href", event.getApplication().getHealthUrl());
            context.put("text", "Application health-endpoint");
            result.put("contexts", Arrays.asList(context));
        }
        return result;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public void setClientUrl(URI clientUrl) {
        this.clientUrl = clientUrl;
    }

    public void setServiceKey(String serviceKey) {
        this.serviceKey = serviceKey;
    }

    public void setDescription(String description) {
        this.description = this.parser.parseExpression(description, ParserContext.TEMPLATE_EXPRESSION);
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }
}

