/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.zuul;

import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import de.codecentric.boot.admin.zuul.ApplicationRouteLocator;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UrlPathHelper;

public class PreDecorationFilter
extends ZuulFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreDecorationFilter.class);
    private ApplicationRouteLocator routeLocator;
    private boolean addProxyHeaders;
    private UrlPathHelper urlPathHelper = new UrlPathHelper();

    public PreDecorationFilter(ApplicationRouteLocator routeLocator, boolean addProxyHeaders) {
        this.routeLocator = routeLocator;
        this.addProxyHeaders = addProxyHeaders;
    }

    public int filterOrder() {
        return 5;
    }

    public String filterType() {
        return "pre";
    }

    public boolean shouldFilter() {
        return true;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        String requestURI = this.urlPathHelper.getPathWithinApplication(ctx.getRequest());
        ApplicationRouteLocator.ProxyRouteSpec route = this.routeLocator.getMatchingRoute(requestURI);
        if (route != null) {
            ctx.put((Object)"requestURI", (Object)route.getPath());
            ctx.put((Object)"proxy", (Object)route.getId());
            ctx.setRouteHost(this.getUrl(route.getLocation()));
            ctx.addOriginResponseHeader("X-Zuul-Service", route.getLocation());
            if (this.addProxyHeaders) {
                ctx.addZuulRequestHeader("X-Forwarded-Host", ctx.getRequest().getServerName() + ":" + String.valueOf(ctx.getRequest().getServerPort()));
                ctx.addZuulRequestHeader("X-Forwarded-Proto", ctx.getRequest().getScheme());
                if (StringUtils.hasText((String)route.getPrefix())) {
                    ctx.addZuulRequestHeader("X-Forwarded-Prefix", route.getPrefix());
                }
            }
        } else {
            LOGGER.warn("No route found for uri: " + requestURI);
            ctx.set("forward.to", (Object)requestURI);
        }
        return null;
    }

    private URL getUrl(String target) {
        try {
            return new URL(target);
        }
        catch (MalformedURLException ex) {
            throw new IllegalStateException("Target URL is malformed", ex);
        }
    }
}

