/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.burlap.client;

import com.caucho.burlap.client.BurlapProtocolException;
import com.caucho.burlap.client.BurlapProxyFactory;
import com.caucho.burlap.client.BurlapRuntimeException;
import com.caucho.burlap.io.BurlapOutput;
import com.caucho.hessian.io.AbstractHessianInput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class BurlapProxy
implements InvocationHandler {
    private BurlapProxyFactory _factory;
    private URL _url;

    BurlapProxy(BurlapProxyFactory burlapProxyFactory, URL uRL) {
        this._factory = burlapProxyFactory;
        this._url = uRL;
    }

    public URL getURL() {
        return this._url;
    }

    public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
        String string = method.getName();
        Class<?>[] classArray = method.getParameterTypes();
        if (string.equals("equals") && classArray.length == 1 && classArray[0].equals(Object.class)) {
            Object object2 = objectArray[0];
            if (object2 == null || !Proxy.isProxyClass(object2.getClass())) {
                return new Boolean(false);
            }
            BurlapProxy burlapProxy = (BurlapProxy)Proxy.getInvocationHandler(object2);
            return new Boolean(this._url.equals(burlapProxy.getURL()));
        }
        if (string.equals("hashCode") && classArray.length == 0) {
            return new Integer(this._url.hashCode());
        }
        if (string.equals("getBurlapType")) {
            return object.getClass().getInterfaces()[0].getName();
        }
        if (string.equals("getBurlapURL")) {
            return this._url.toString();
        }
        if (string.equals("toString") && classArray.length == 0) {
            return "[BurlapProxy " + this._url + "]";
        }
        InputStream inputStream = null;
        try {
            Object object3;
            URLConnection uRLConnection = this._factory.openConnection(this._url);
            uRLConnection.setRequestProperty("Content-Type", "text/xml");
            OutputStream outputStream = uRLConnection.getOutputStream();
            BurlapOutput burlapOutput = this._factory.getBurlapOutput(outputStream);
            if (this._factory.isOverloadEnabled()) {
                string = objectArray != null ? string + "__" + objectArray.length : string + "__0";
            }
            burlapOutput.call(string, objectArray);
            outputStream.flush();
            if (uRLConnection instanceof HttpURLConnection) {
                object3 = (HttpURLConnection)uRLConnection;
                int n = 500;
                try {
                    n = ((HttpURLConnection)object3).getResponseCode();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n != 200) {
                    StringBuffer stringBuffer = new StringBuffer();
                    try {
                        int n2;
                        inputStream = ((URLConnection)object3).getInputStream();
                        if (inputStream != null) {
                            while ((n2 = inputStream.read()) >= 0) {
                                stringBuffer.append((char)n2);
                            }
                            inputStream.close();
                        }
                        if ((inputStream = ((HttpURLConnection)object3).getErrorStream()) != null) {
                            while ((n2 = inputStream.read()) >= 0) {
                                stringBuffer.append((char)n2);
                            }
                        }
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw new BurlapRuntimeException(String.valueOf(fileNotFoundException));
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw new BurlapProtocolException(stringBuffer.toString());
                }
            }
            inputStream = uRLConnection.getInputStream();
            object3 = this._factory.getBurlapInput(inputStream);
            Object object4 = ((AbstractHessianInput)object3).readReply(method.getReturnType());
            return object4;
        }
        catch (BurlapProtocolException burlapProtocolException) {
            throw new BurlapRuntimeException(burlapProtocolException);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }
}

