/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.burlap.io;

import com.caucho.burlap.io.AbstractBurlapInput;
import com.caucho.burlap.io.BurlapProtocolException;
import com.caucho.burlap.io.BurlapRemote;
import com.caucho.burlap.io.BurlapServiceException;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.w3c.dom.Node;

public class BurlapInput
extends AbstractBurlapInput {
    private static int[] base64Decode;
    public static final int TAG_EOF = -1;
    public static final int TAG_NULL = 0;
    public static final int TAG_BOOLEAN = 1;
    public static final int TAG_INT = 2;
    public static final int TAG_LONG = 3;
    public static final int TAG_DOUBLE = 4;
    public static final int TAG_DATE = 5;
    public static final int TAG_STRING = 6;
    public static final int TAG_XML = 7;
    public static final int TAG_BASE64 = 8;
    public static final int TAG_MAP = 9;
    public static final int TAG_LIST = 10;
    public static final int TAG_TYPE = 11;
    public static final int TAG_LENGTH = 12;
    public static final int TAG_REF = 13;
    public static final int TAG_REMOTE = 14;
    public static final int TAG_CALL = 15;
    public static final int TAG_REPLY = 16;
    public static final int TAG_FAULT = 17;
    public static final int TAG_METHOD = 18;
    public static final int TAG_HEADER = 19;
    public static final int TAG_NULL_END = 100;
    public static final int TAG_BOOLEAN_END = 101;
    public static final int TAG_INT_END = 102;
    public static final int TAG_LONG_END = 103;
    public static final int TAG_DOUBLE_END = 104;
    public static final int TAG_DATE_END = 105;
    public static final int TAG_STRING_END = 106;
    public static final int TAG_XML_END = 107;
    public static final int TAG_BASE64_END = 108;
    public static final int TAG_MAP_END = 109;
    public static final int TAG_LIST_END = 110;
    public static final int TAG_TYPE_END = 111;
    public static final int TAG_LENGTH_END = 112;
    public static final int TAG_REF_END = 113;
    public static final int TAG_REMOTE_END = 114;
    public static final int TAG_CALL_END = 115;
    public static final int TAG_REPLY_END = 116;
    public static final int TAG_FAULT_END = 117;
    public static final int TAG_METHOD_END = 118;
    public static final int TAG_HEADER_END = 119;
    private static HashMap _tagMap;
    protected SerializerFactory _serializerFactory;
    protected ArrayList _refs;
    private InputStream _is;
    protected int _peek = -1;
    private String _method;
    private int _peekTag;
    protected StringBuffer _sbuf = new StringBuffer();
    protected StringBuffer _entityBuffer = new StringBuffer();
    protected Calendar _utcCalendar;
    protected Calendar _localCalendar;

    public BurlapInput() {
    }

    public BurlapInput(InputStream inputStream) {
        this.init(inputStream);
    }

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this._serializerFactory = serializerFactory;
    }

    public SerializerFactory getSerializerFactory() {
        return this._serializerFactory;
    }

    public void init(InputStream inputStream) {
        this._is = inputStream;
        this._method = null;
        this._peek = -1;
        this._peekTag = -1;
        this._refs = null;
        if (this._serializerFactory == null) {
            this._serializerFactory = new SerializerFactory();
        }
    }

    public String getMethod() {
        return this._method;
    }

    public void startCall() throws IOException {
        this.expectTag(15);
        this.expectTag(18);
        this._method = this.parseString();
        this.expectTag(118);
    }

    public void completeCall() throws IOException {
        this.expectTag(115);
    }

    public Object readReply(Class clazz) throws Exception {
        this.expectTag(16);
        int n = this.parseTag();
        if (n == 17) {
            HashMap hashMap = this.readFault();
            this.completeReply();
            Object v = hashMap.get("detail");
            if (v instanceof Exception) {
                throw (Exception)v;
            }
            String string = (String)hashMap.get("code");
            String string2 = (String)hashMap.get("message");
            throw new BurlapServiceException(string2, string, v);
        }
        this._peekTag = n;
        Object object = this.readObject(clazz);
        this.expectTag(116);
        return object;
    }

    public void startReply() throws Throwable {
        this.expectTag(16);
        int n = this.parseTag();
        if (n == 17) {
            HashMap hashMap = this.readFault();
            Object v = hashMap.get("detail");
            if (v instanceof Throwable) {
                throw (Throwable)v;
            }
            String string = (String)hashMap.get("code");
            String string2 = (String)hashMap.get("message");
            throw new BurlapServiceException(string2, string, v);
        }
        this._peekTag = n;
    }

    public void completeReply() throws IOException {
        this.expectTag(116);
    }

    public String readHeader() throws IOException {
        int n = this.parseTag();
        if (n == 19) {
            this._sbuf.setLength(0);
            String string = this.parseString(this._sbuf).toString();
            this.expectTag(119);
            return string;
        }
        this._peekTag = n;
        return null;
    }

    public void readNull() throws IOException {
        int n = this.parseTag();
        switch (n) {
            case 0: {
                this.expectTag(100);
                return;
            }
        }
        throw this.expectedTag("null", n);
    }

    public boolean readBoolean() throws IOException {
        int n = this.parseTag();
        switch (n) {
            case 0: {
                boolean bl = false;
                this.expectTag(100);
                return bl;
            }
            case 1: {
                boolean bl = this.parseInt() != 0;
                this.expectTag(101);
                return bl;
            }
            case 2: {
                boolean bl = this.parseInt() != 0;
                this.expectTag(102);
                return bl;
            }
            case 3: {
                boolean bl = this.parseLong() != 0L;
                this.expectTag(103);
                return bl;
            }
            case 4: {
                boolean bl = this.parseDouble() != 0.0;
                this.expectTag(104);
                return bl;
            }
        }
        throw this.expectedTag("boolean", n);
    }

    public int readInt() throws IOException {
        int n = this.parseTag();
        switch (n) {
            case 0: {
                int n2 = 0;
                this.expectTag(100);
                return n2;
            }
            case 1: {
                int n3 = this.parseInt();
                this.expectTag(101);
                return n3;
            }
            case 2: {
                int n4 = this.parseInt();
                this.expectTag(102);
                return n4;
            }
            case 3: {
                int n5 = (int)this.parseLong();
                this.expectTag(103);
                return n5;
            }
            case 4: {
                int n6 = (int)this.parseDouble();
                this.expectTag(104);
                return n6;
            }
        }
        throw this.expectedTag("int", n);
    }

    public long readLong() throws IOException {
        int n = this.parseTag();
        switch (n) {
            case 0: {
                long l = 0L;
                this.expectTag(100);
                return l;
            }
            case 1: {
                long l = this.parseInt();
                this.expectTag(101);
                return l;
            }
            case 2: {
                long l = this.parseInt();
                this.expectTag(102);
                return l;
            }
            case 3: {
                long l = this.parseLong();
                this.expectTag(103);
                return l;
            }
            case 4: {
                long l = (long)this.parseDouble();
                this.expectTag(104);
                return l;
            }
        }
        throw this.expectedTag("long", n);
    }

    public double readDouble() throws IOException {
        int n = this.parseTag();
        switch (n) {
            case 0: {
                double d = 0.0;
                this.expectTag(100);
                return d;
            }
            case 1: {
                double d = this.parseInt();
                this.expectTag(101);
                return d;
            }
            case 2: {
                double d = this.parseInt();
                this.expectTag(102);
                return d;
            }
            case 3: {
                double d = this.parseLong();
                this.expectTag(103);
                return d;
            }
            case 4: {
                double d = this.parseDouble();
                this.expectTag(104);
                return d;
            }
        }
        throw this.expectedTag("double", n);
    }

    public long readUTCDate() throws IOException {
        int n = this.parseTag();
        if (n != 5) {
            throw this.error("expected date");
        }
        if (this._utcCalendar == null) {
            this._utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        }
        long l = this.parseDate(this._utcCalendar);
        this.expectTag(105);
        return l;
    }

    public long readLocalDate() throws IOException {
        int n = this.parseTag();
        if (n != 5) {
            throw this.error("expected date");
        }
        if (this._localCalendar == null) {
            this._localCalendar = Calendar.getInstance();
        }
        long l = this.parseDate(this._localCalendar);
        this.expectTag(105);
        return l;
    }

    public String readString() throws IOException {
        int n = this.parseTag();
        switch (n) {
            case 0: {
                this.expectTag(100);
                return null;
            }
            case 6: {
                this._sbuf.setLength(0);
                String string = this.parseString(this._sbuf).toString();
                this.expectTag(106);
                return string;
            }
            case 7: {
                this._sbuf.setLength(0);
                String string = this.parseString(this._sbuf).toString();
                this.expectTag(107);
                return string;
            }
        }
        throw this.expectedTag("string", n);
    }

    public Node readNode() throws IOException {
        int n = this.read();
        switch (n) {
            case 78: {
                return null;
            }
            case 83: 
            case 88: 
            case 115: 
            case 120: {
                throw this.error("can't cope");
            }
        }
        throw this.expectedTag("string", n);
    }

    public byte[] readBytes() throws IOException {
        int n = this.parseTag();
        switch (n) {
            case 0: {
                this.expectTag(100);
                return null;
            }
            case 8: {
                byte[] byArray = this.parseBytes();
                this.expectTag(108);
                return byArray;
            }
        }
        throw this.expectedTag("bytes", n);
    }

    public int readLength() throws IOException {
        int n = this.parseTag();
        if (n != 12) {
            this._peekTag = n;
            return -1;
        }
        int n2 = this.parseInt();
        this.expectTag(112);
        return n2;
    }

    private HashMap readFault() throws IOException {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        int n = this.parseTag();
        while (n >= 0 && n != 117) {
            this._peekTag = n;
            Object object = this.readObject();
            Object object2 = this.readObject();
            if (object != null && object2 != null) {
                hashMap.put(object, object2);
            }
            n = this.parseTag();
        }
        if (n != 117) {
            throw this.expectedTag("fault", n);
        }
        return hashMap;
    }

    public Object readObject(Class clazz) throws IOException {
        if (clazz == null) {
            return this.readObject();
        }
        int n = this.parseTag();
        switch (n) {
            case 0: {
                this.expectTag(100);
                return null;
            }
            case 9: {
                String string = this.readType();
                Deserializer deserializer = this._serializerFactory.getObjectDeserializer(string);
                if (clazz != deserializer.getType() && clazz.isAssignableFrom(deserializer.getType())) {
                    return deserializer.readMap(this);
                }
                deserializer = this._serializerFactory.getDeserializer(clazz);
                return deserializer.readMap(this);
            }
            case 10: {
                String string = this.readType();
                int n2 = this.readLength();
                Deserializer deserializer = this._serializerFactory.getObjectDeserializer(string);
                if (clazz != deserializer.getType() && clazz.isAssignableFrom(deserializer.getType())) {
                    return deserializer.readList(this, n2);
                }
                deserializer = this._serializerFactory.getDeserializer(clazz);
                return deserializer.readList(this, n2);
            }
            case 13: {
                int n3 = this.parseInt();
                this.expectTag(113);
                return this._refs.get(n3);
            }
            case 14: {
                String string = this.readType();
                String string2 = this.readString();
                this.expectTag(114);
                Object object = this.resolveRemote(string, string2);
                return object;
            }
        }
        this._peekTag = n;
        Object object = this._serializerFactory.getDeserializer(clazz).readObject(this);
        return object;
    }

    public Object readObject() throws IOException {
        int n = this.parseTag();
        switch (n) {
            case 0: {
                this.expectTag(100);
                return null;
            }
            case 1: {
                int n2 = this.parseInt();
                this.expectTag(101);
                return new Boolean(n2 != 0);
            }
            case 2: {
                int n3 = this.parseInt();
                this.expectTag(102);
                return new Integer(n3);
            }
            case 3: {
                long l = this.parseLong();
                this.expectTag(103);
                return new Long(l);
            }
            case 4: {
                double d = this.parseDouble();
                this.expectTag(104);
                return new Double(d);
            }
            case 5: {
                long l = this.parseDate();
                this.expectTag(105);
                return new Date(l);
            }
            case 7: {
                return this.parseXML();
            }
            case 6: {
                this._sbuf.setLength(0);
                String string = this.parseString(this._sbuf).toString();
                this.expectTag(106);
                return string;
            }
            case 8: {
                byte[] byArray = this.parseBytes();
                this.expectTag(108);
                return byArray;
            }
            case 10: {
                String string = this.readType();
                int n4 = this.readLength();
                return this._serializerFactory.readList(this, n4, string);
            }
            case 9: {
                String string = this.readType();
                Deserializer deserializer = this._serializerFactory.getObjectDeserializer(string);
                return deserializer.readMap(this);
            }
            case 13: {
                int n5 = this.parseInt();
                this.expectTag(113);
                return this._refs.get(n5);
            }
            case 14: {
                String string = this.readType();
                String string2 = this.readString();
                this.expectTag(114);
                return this.resolveRemote(string, string2);
            }
        }
        throw this.error("unknown code:" + BurlapInput.tagName(n));
    }

    public Object readRemote() throws IOException {
        String string = this.readType();
        String string2 = this.readString();
        return this.resolveRemote(string, string2);
    }

    public Object readRef() throws IOException {
        return this._refs.get(this.parseInt());
    }

    public int readListStart() throws IOException {
        return this.parseTag();
    }

    public int readMapStart() throws IOException {
        return this.parseTag();
    }

    public boolean isEnd() throws IOException {
        int n;
        this._peekTag = n = this.parseTag();
        return n < 0 || n >= 100;
    }

    public void readEnd() throws IOException {
        int n = this.parseTag();
        if (n < 100) {
            throw this.error("unknown code:" + (char)n);
        }
    }

    public void readMapEnd() throws IOException {
        this.expectTag(109);
    }

    public void readListEnd() throws IOException {
        this.expectTag(110);
    }

    public int addRef(Object object) {
        if (this._refs == null) {
            this._refs = new ArrayList();
        }
        this._refs.add(object);
        return this._refs.size() - 1;
    }

    public void setRef(int n, Object object) {
        this._refs.set(n, object);
    }

    public Object resolveRemote(String string, String string2) throws IOException {
        HessianRemoteResolver hessianRemoteResolver = this.getRemoteResolver();
        if (hessianRemoteResolver != null) {
            return hessianRemoteResolver.lookup(string, string2);
        }
        return new BurlapRemote(string, string2);
    }

    public String readType() throws IOException {
        int n;
        int n2 = this.parseTag();
        if (n2 != 11) {
            this._peekTag = n2;
            return "";
        }
        this._sbuf.setLength(0);
        while ((n = this.readChar()) >= 0) {
            this._sbuf.append((char)n);
        }
        String string = this._sbuf.toString();
        this.expectTag(111);
        return string;
    }

    private int parseInt() throws IOException {
        int n = 1;
        int n2 = this.read();
        if (n2 == 45) {
            n = -1;
            n2 = this.read();
        }
        int n3 = 0;
        while (n2 >= 48 && n2 <= 57) {
            n3 = 10 * n3 + n2 - 48;
            n2 = this.read();
        }
        this._peek = n2;
        return n * n3;
    }

    private long parseLong() throws IOException {
        int n = 1;
        int n2 = this.read();
        if (n2 == 45) {
            n = -1;
            n2 = this.read();
        }
        long l = 0L;
        while (n2 >= 48 && n2 <= 57) {
            l = 10L * l + (long)n2 - 48L;
            n2 = this.read();
        }
        this._peek = n2;
        return (long)n * l;
    }

    private double parseDouble() throws IOException {
        int n = this.skipWhitespace();
        this._sbuf.setLength(0);
        while (!this.isWhitespace(n) && n != 60) {
            this._sbuf.append((char)n);
            n = this.read();
        }
        this._peek = n;
        return new Double(this._sbuf.toString());
    }

    protected long parseDate() throws IOException {
        if (this._utcCalendar == null) {
            this._utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        }
        return this.parseDate(this._utcCalendar);
    }

    protected long parseDate(Calendar calendar) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = this.skipWhitespace();
        int n8 = 0;
        for (n6 = 0; n6 < 4; ++n6) {
            if (n7 < 48 || n7 > 57) {
                throw this.expectedChar("year", n7);
            }
            n8 = 10 * n8 + n7 - 48;
            n7 = this.read();
        }
        n6 = 0;
        for (n5 = 0; n5 < 2; ++n5) {
            if (n7 < 48 || n7 > 57) {
                throw this.expectedChar("month", n7);
            }
            n6 = 10 * n6 + n7 - 48;
            n7 = this.read();
        }
        n5 = 0;
        for (n4 = 0; n4 < 2; ++n4) {
            if (n7 < 48 || n7 > 57) {
                throw this.expectedChar("day", n7);
            }
            n5 = 10 * n5 + n7 - 48;
            n7 = this.read();
        }
        if (n7 != 84) {
            throw this.expectedChar("`T'", n7);
        }
        n7 = this.read();
        n4 = 0;
        for (n3 = 0; n3 < 2; ++n3) {
            if (n7 < 48 || n7 > 57) {
                throw this.expectedChar("hour", n7);
            }
            n4 = 10 * n4 + n7 - 48;
            n7 = this.read();
        }
        n3 = 0;
        for (n2 = 0; n2 < 2; ++n2) {
            if (n7 < 48 || n7 > 57) {
                throw this.expectedChar("minute", n7);
            }
            n3 = 10 * n3 + n7 - 48;
            n7 = this.read();
        }
        n2 = 0;
        for (n = 0; n < 2; ++n) {
            if (n7 < 48 || n7 > 57) {
                throw this.expectedChar("second", n7);
            }
            n2 = 10 * n2 + n7 - 48;
            n7 = this.read();
        }
        n = 0;
        if (n7 == 46) {
            n7 = this.read();
            while (n7 >= 48 && n7 <= 57) {
                n = 10 * n + n7 - 48;
                n7 = this.read();
            }
        }
        while (n7 > 0 && n7 != 60) {
            n7 = this.read();
        }
        this._peek = n7;
        calendar.set(1, n8);
        calendar.set(2, n6 - 1);
        calendar.set(5, n5);
        calendar.set(11, n4);
        calendar.set(12, n3);
        calendar.set(13, n2);
        calendar.set(14, n);
        return calendar.getTime().getTime();
    }

    protected String parseString() throws IOException {
        this._sbuf.setLength(0);
        return this.parseString(this._sbuf).toString();
    }

    protected StringBuffer parseString(StringBuffer stringBuffer) throws IOException {
        int n;
        while ((n = this.readChar()) >= 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer;
    }

    Node parseXML() throws IOException {
        throw this.error("help!");
    }

    int readChar() throws IOException {
        int n = this.read();
        if (n == 60 || n < 0) {
            this._peek = n;
            return -1;
        }
        if (n == 38) {
            n = this.read();
            if (n == 35) {
                n = this.read();
                if (n >= 48 && n <= 57) {
                    int n2 = 0;
                    while (n >= 48 && n <= 57) {
                        n2 = 10 * n2 + n - 48;
                        n = this.read();
                    }
                    if (n != 59) {
                        throw this.error("expected ';' at " + (char)n);
                    }
                    return (char)n2;
                }
                throw this.error("expected digit at " + (char)n);
            }
            this._entityBuffer.setLength(0);
            while (n >= 97 && n <= 122) {
                this._entityBuffer.append((char)n);
                n = this.read();
            }
            String string = this._entityBuffer.toString();
            if (n != 59) {
                throw this.expectedChar("';'", n);
            }
            if (string.equals("amp")) {
                return 38;
            }
            if (string.equals("apos")) {
                return 39;
            }
            if (string.equals("quot")) {
                return 34;
            }
            if (string.equals("lt")) {
                return 60;
            }
            if (string.equals("gt")) {
                return 62;
            }
            throw new BurlapProtocolException("unknown XML entity &" + string + "; at `" + (char)n + "'");
        }
        if (n < 128) {
            return (char)n;
        }
        if ((n & 0xE0) == 192) {
            int n3 = this.read();
            int n4 = ((n & 0x1F) << 6) + (n3 & 0x3F);
            return (char)n4;
        }
        if ((n & 0xF0) == 224) {
            int n5 = this.read();
            int n6 = this.read();
            int n7 = ((n & 0xF) << 12) + ((n5 & 0x3F) << 6) + (n6 & 0x3F);
            return (char)n7;
        }
        throw new BurlapProtocolException("bad utf-8 encoding");
    }

    protected byte[] parseBytes() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.parseBytes(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected ByteArrayOutputStream parseBytes(ByteArrayOutputStream byteArrayOutputStream) throws IOException {
        int n = this.skipWhitespace();
        while (n >= 0 && n != 60) {
            int n2;
            int n3 = n;
            int n4 = this.read();
            int n5 = this.read();
            int n6 = this.read();
            if (n6 != 61) {
                n2 = (base64Decode[n3] << 18) + (base64Decode[n4] << 12) + (base64Decode[n5] << 6) + base64Decode[n6];
                byteArrayOutputStream.write(n2 >> 16);
                byteArrayOutputStream.write(n2 >> 8);
                byteArrayOutputStream.write(n2);
            } else if (n5 != 61) {
                n2 = (base64Decode[n3] << 12) + (base64Decode[n4] << 6) + base64Decode[n5];
                byteArrayOutputStream.write(n2 >> 8);
                byteArrayOutputStream.write(n2);
            } else {
                n2 = (base64Decode[n3] << 6) + base64Decode[n4];
                byteArrayOutputStream.write(n2);
            }
            n = this.skipWhitespace();
        }
        if (n == 60) {
            this._peek = n;
        }
        return byteArrayOutputStream;
    }

    public void expectTag(int n) throws IOException {
        int n2 = this.parseTag();
        if (n2 != n) {
            throw this.error("expected " + BurlapInput.tagName(n) + " at " + BurlapInput.tagName(n2));
        }
    }

    protected int parseTag() throws IOException {
        if (this._peekTag >= 0) {
            int n = this._peekTag;
            this._peekTag = -1;
            return n;
        }
        int n = this.skipWhitespace();
        int n2 = 0;
        if (n != 60) {
            throw this.expectedChar("'<'", n);
        }
        n = this.read();
        if (n == 47) {
            n2 = 100;
            n = this._is.read();
        }
        if (!this.isTagChar(n)) {
            throw this.expectedChar("tag", n);
        }
        this._sbuf.setLength(0);
        while (this.isTagChar(n)) {
            this._sbuf.append((char)n);
            n = this.read();
        }
        if (n != 62) {
            throw this.expectedChar("'>'", n);
        }
        Integer n3 = (Integer)_tagMap.get(this._sbuf.toString());
        if (n3 == null) {
            throw this.error("Unknown tag <" + this._sbuf + ">");
        }
        return n3 + n2;
    }

    private boolean isTagChar(int n) {
        return n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 58 || n == 45;
    }

    protected int skipWhitespace() throws IOException {
        int n = this.read();
        while (n == 32 || n == 9 || n == 10 || n == 13) {
            n = this.read();
        }
        return n;
    }

    protected boolean isWhitespace(int n) throws IOException {
        return n == 32 || n == 9 || n == 10 || n == 13;
    }

    int read(byte[] byArray, int n, int n2) throws IOException {
        throw new UnsupportedOperationException();
    }

    int read() throws IOException {
        if (this._peek >= 0) {
            int n = this._peek;
            this._peek = -1;
            return n;
        }
        return this._is.read();
    }

    public Reader getReader() {
        return null;
    }

    public InputStream getInputStream() {
        return null;
    }

    protected IOException expectBeginTag(String string, String string2) {
        return new BurlapProtocolException("expected <" + string + "> at <" + string2 + ">");
    }

    protected IOException expectedChar(String string, int n) {
        if (n < 0) {
            return this.error("expected " + string + " at end of file");
        }
        return this.error("expected " + string + " at " + (char)n);
    }

    protected IOException expectedTag(String string, int n) {
        return this.error("expected " + string + " at " + BurlapInput.tagName(n));
    }

    protected IOException error(String string) {
        return new BurlapProtocolException(string);
    }

    protected static String tagName(int n) {
        switch (n) {
            case 0: {
                return "<null>";
            }
            case 100: {
                return "</null>";
            }
            case 1: {
                return "<boolean>";
            }
            case 101: {
                return "</boolean>";
            }
            case 2: {
                return "<int>";
            }
            case 102: {
                return "</int>";
            }
            case 3: {
                return "<long>";
            }
            case 103: {
                return "</long>";
            }
            case 4: {
                return "<double>";
            }
            case 104: {
                return "</double>";
            }
            case 6: {
                return "<string>";
            }
            case 106: {
                return "</string>";
            }
            case 7: {
                return "<xml>";
            }
            case 107: {
                return "</xml>";
            }
            case 8: {
                return "<base64>";
            }
            case 108: {
                return "</base64>";
            }
            case 9: {
                return "<map>";
            }
            case 109: {
                return "</map>";
            }
            case 10: {
                return "<list>";
            }
            case 110: {
                return "</list>";
            }
            case 11: {
                return "<type>";
            }
            case 111: {
                return "</type>";
            }
            case 12: {
                return "<length>";
            }
            case 112: {
                return "</length>";
            }
            case 13: {
                return "<ref>";
            }
            case 113: {
                return "</ref>";
            }
            case 14: {
                return "<remote>";
            }
            case 114: {
                return "</remote>";
            }
            case 15: {
                return "<burlap:call>";
            }
            case 115: {
                return "</burlap:call>";
            }
            case 16: {
                return "<burlap:reply>";
            }
            case 116: {
                return "</burlap:reply>";
            }
            case 19: {
                return "<header>";
            }
            case 119: {
                return "</header>";
            }
            case 17: {
                return "<fault>";
            }
            case 117: {
                return "</fault>";
            }
            case -1: {
                return "end of file";
            }
        }
        return "unknown " + n;
    }

    static {
        int n;
        _tagMap = new HashMap();
        _tagMap.put("null", new Integer(0));
        _tagMap.put("boolean", new Integer(1));
        _tagMap.put("int", new Integer(2));
        _tagMap.put("long", new Integer(3));
        _tagMap.put("double", new Integer(4));
        _tagMap.put("date", new Integer(5));
        _tagMap.put("string", new Integer(6));
        _tagMap.put("xml", new Integer(7));
        _tagMap.put("base64", new Integer(8));
        _tagMap.put("map", new Integer(9));
        _tagMap.put("list", new Integer(10));
        _tagMap.put("type", new Integer(11));
        _tagMap.put("length", new Integer(12));
        _tagMap.put("ref", new Integer(13));
        _tagMap.put("remote", new Integer(14));
        _tagMap.put("burlap:call", new Integer(15));
        _tagMap.put("burlap:reply", new Integer(16));
        _tagMap.put("fault", new Integer(17));
        _tagMap.put("method", new Integer(18));
        _tagMap.put("header", new Integer(19));
        base64Decode = new int[256];
        for (n = 65; n <= 90; ++n) {
            BurlapInput.base64Decode[n] = n - 65;
        }
        for (n = 97; n <= 122; ++n) {
            BurlapInput.base64Decode[n] = n - 97 + 26;
        }
        for (n = 48; n <= 57; ++n) {
            BurlapInput.base64Decode[n] = n - 48 + 52;
        }
        BurlapInput.base64Decode[43] = 62;
        BurlapInput.base64Decode[47] = 63;
    }
}

