/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.burlap.io;

import com.caucho.burlap.io.AbstractBurlapOutput;
import com.caucho.hessian.io.Serializer;
import com.caucho.hessian.io.SerializerFactory;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class BurlapOutput
extends AbstractBurlapOutput {
    protected OutputStream os;
    private ArrayList refs;
    protected SerializerFactory serializerFactory;
    private Date date;
    private Calendar utcCalendar;
    private Calendar localCalendar;

    public BurlapOutput(OutputStream outputStream) {
        this.init(outputStream);
    }

    public BurlapOutput() {
    }

    public void init(OutputStream outputStream) {
        this.os = outputStream;
        this.refs = null;
        if (this.serializerFactory == null) {
            this.serializerFactory = new SerializerFactory();
        }
    }

    public void call(String string, Object[] objectArray) throws IOException {
        this.startCall(string);
        if (objectArray != null) {
            for (int i = 0; i < objectArray.length; ++i) {
                this.writeObject(objectArray[i]);
            }
        }
        this.completeCall();
    }

    public void startCall(String string) throws IOException {
        this.print("<burlap:call><method>");
        this.print(string);
        this.print("</method>");
    }

    public void startCall() throws IOException {
        this.print("<burlap:call>");
    }

    public void writeMethod(String string) throws IOException {
        this.print("<method>");
        this.print(string);
        this.print("</method>");
    }

    public void completeCall() throws IOException {
        this.print("</burlap:call>");
    }

    public void startReply() throws IOException {
        this.print("<burlap:reply>");
    }

    public void completeReply() throws IOException {
        this.print("</burlap:reply>");
    }

    public void writeHeader(String string) throws IOException {
        this.print("<header>");
        this.printString(string);
        this.print("</header>");
    }

    public void writeFault(String string, String string2, Object object) throws IOException {
        this.print("<fault>");
        this.writeString("code");
        this.writeString(string);
        this.writeString("message");
        this.writeString(string2);
        if (object != null) {
            this.writeString("detail");
            this.writeObject(object);
        }
        this.print("</fault>");
    }

    public void writeObject(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
            return;
        }
        Serializer serializer = this.serializerFactory.getSerializer(object.getClass());
        serializer.writeObject(object, this);
    }

    public void writeListBegin(int n, String string) throws IOException {
        this.print("<list><type>");
        if (string != null) {
            this.print(string);
        }
        this.print("</type><length>");
        this.print(n);
        this.print("</length>");
    }

    public void writeListEnd() throws IOException {
        this.print("</list>");
    }

    public void writeMapBegin(String string) throws IOException {
        this.print("<map><type>");
        if (string != null) {
            this.print(string);
        }
        this.print("</type>");
    }

    public void writeMapEnd() throws IOException {
        this.print("</map>");
    }

    public void writeRemote(String string, String string2) throws IOException {
        this.print("<remote><type>");
        this.print(string);
        this.print("</type><string>");
        this.print(string2);
        this.print("</string></remote>");
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.print("<boolean>1</boolean>");
        } else {
            this.print("<boolean>0</boolean>");
        }
    }

    public void writeInt(int n) throws IOException {
        this.print("<int>");
        this.print(n);
        this.print("</int>");
    }

    public void writeLong(long l) throws IOException {
        this.print("<long>");
        this.print(l);
        this.print("</long>");
    }

    public void writeDouble(double d) throws IOException {
        this.print("<double>");
        this.print(d);
        this.print("</double>");
    }

    public void writeUTCDate(long l) throws IOException {
        this.print("<date>");
        if (this.utcCalendar == null) {
            this.utcCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            this.date = new Date();
        }
        this.date.setTime(l);
        this.utcCalendar.setTime(this.date);
        this.printDate(this.utcCalendar);
        this.print("</date>");
    }

    public void writeNull() throws IOException {
        this.print("<null></null>");
    }

    public void writeString(String string) throws IOException {
        if (string == null) {
            this.print("<null></null>");
        } else {
            this.print("<string>");
            this.printString(string);
            this.print("</string>");
        }
    }

    public void writeString(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            this.print("<null></null>");
        } else {
            this.print("<string>");
            this.printString(cArray, n, n2);
            this.print("</string>");
        }
    }

    public void writeBytes(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.print("<null></null>");
        } else {
            this.writeBytes(byArray, 0, byArray.length);
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            this.print("<null></null>");
        } else {
            int n3;
            this.print("<base64>");
            int n4 = 0;
            while (n4 + 2 < n2) {
                if (n4 != 0 && (n4 & 0x3F) == 0) {
                    this.print('\n');
                }
                n3 = ((byArray[n + n4] & 0xFF) << 16) + ((byArray[n + n4 + 1] & 0xFF) << 8) + (byArray[n + n4 + 2] & 0xFF);
                this.print(this.encode(n3 >> 18));
                this.print(this.encode(n3 >> 12));
                this.print(this.encode(n3 >> 6));
                this.print(this.encode(n3));
                n4 += 3;
            }
            if (n4 + 1 < n2) {
                n3 = ((byArray[n + n4] & 0xFF) << 8) + (byArray[n + n4 + 1] & 0xFF);
                this.print(this.encode(n3 >> 12));
                this.print(this.encode(n3 >> 6));
                this.print(this.encode(n3));
                this.print('=');
            } else if (n4 < n2) {
                n3 = byArray[n + n4] & 0xFF;
                this.print(this.encode(n3 >> 6));
                this.print(this.encode(n3));
                this.print('=');
                this.print('=');
            }
            this.print("</base64>");
        }
    }

    private char encode(int n) {
        if ((n &= 0x3F) < 26) {
            return (char)(n + 65);
        }
        if (n < 52) {
            return (char)(n + 97 - 26);
        }
        if (n < 62) {
            return (char)(n + 48 - 52);
        }
        if (n == 62) {
            return '+';
        }
        return '/';
    }

    public void writeRef(int n) throws IOException {
        this.print("<ref>");
        this.print(n);
        this.print("</ref>");
    }

    public boolean addRef(Object object) throws IOException {
        if (this.refs == null) {
            this.refs = new ArrayList();
        }
        for (int i = this.refs.size() - 1; i >= 0; --i) {
            if (this.refs.get(i) != object) continue;
            this.writeRef(i);
            return true;
        }
        this.refs.add(object);
        return false;
    }

    public void printString(String string) throws IOException {
        this.printString(string, 0, string.length());
    }

    public void printString(String string, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i + n);
            if (c == '<') {
                this.os.write(38);
                this.os.write(35);
                this.os.write(54);
                this.os.write(48);
                this.os.write(59);
                continue;
            }
            if (c == '&') {
                this.os.write(38);
                this.os.write(35);
                this.os.write(51);
                this.os.write(56);
                this.os.write(59);
                continue;
            }
            if (c < '\u0080') {
                this.os.write(c);
                continue;
            }
            if (c < '\u0800') {
                this.os.write(192 + (c >> 6 & 0x1F));
                this.os.write(128 + (c & 0x3F));
                continue;
            }
            this.os.write(224 + (c >> 12 & 0xF));
            this.os.write(128 + (c >> 6 & 0x3F));
            this.os.write(128 + (c & 0x3F));
        }
    }

    public void printString(char[] cArray, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            char c = cArray[i + n];
            if (c < '\u0080') {
                this.os.write(c);
                continue;
            }
            if (c < '\u0800') {
                this.os.write(192 + (c >> 6 & 0x1F));
                this.os.write(128 + (c & 0x3F));
                continue;
            }
            this.os.write(224 + (c >> 12 & 0xF));
            this.os.write(128 + (c >> 6 & 0x3F));
            this.os.write(128 + (c & 0x3F));
        }
    }

    public void printDate(Calendar calendar) throws IOException {
        int n = calendar.get(1);
        this.os.write((char)(48 + n / 1000 % 10));
        this.os.write((char)(48 + n / 100 % 10));
        this.os.write((char)(48 + n / 10 % 10));
        this.os.write((char)(48 + n % 10));
        int n2 = calendar.get(2) + 1;
        this.os.write((char)(48 + n2 / 10 % 10));
        this.os.write((char)(48 + n2 % 10));
        int n3 = calendar.get(5);
        this.os.write((char)(48 + n3 / 10 % 10));
        this.os.write((char)(48 + n3 % 10));
        this.os.write(84);
        int n4 = calendar.get(11);
        this.os.write((char)(48 + n4 / 10 % 10));
        this.os.write((char)(48 + n4 % 10));
        int n5 = calendar.get(12);
        this.os.write((char)(48 + n5 / 10 % 10));
        this.os.write((char)(48 + n5 % 10));
        int n6 = calendar.get(13);
        this.os.write((char)(48 + n6 / 10 % 10));
        this.os.write((char)(48 + n6 % 10));
        int n7 = calendar.get(14);
        this.os.write(46);
        this.os.write((char)(48 + n7 / 100 % 10));
        this.os.write((char)(48 + n7 / 10 % 10));
        this.os.write((char)(48 + n7 % 10));
        this.os.write(90);
    }

    protected void print(char c) throws IOException {
        this.os.write(c);
    }

    protected void print(int n) throws IOException {
        this.print(String.valueOf(n));
    }

    protected void print(long l) throws IOException {
        this.print(String.valueOf(l));
    }

    protected void print(double d) throws IOException {
        this.print(String.valueOf(d));
    }

    protected void print(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            this.os.write(c);
        }
    }
}

