/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.burlap.server;

import com.caucho.burlap.io.BurlapInput;
import com.caucho.burlap.io.BurlapOutput;
import com.caucho.burlap.server.BurlapSkeleton;
import com.caucho.services.server.GenericService;
import com.caucho.services.server.Service;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class BurlapServlet
extends GenericService
implements Servlet {
    private Class _serviceClass;
    private Object _service;
    private BurlapSkeleton _skeleton;
    private boolean _isService;

    public String getServletInfo() {
        return "Burlap Servlet";
    }

    public void setService(boolean bl) {
        this._isService = bl;
        this._service = this;
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (this._isService) {
            return;
        }
        String string = this.getInitParameter("service-class");
        if (string != null) {
            try {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    this._serviceClass = Class.forName(string, false, classLoader);
                }
                this._serviceClass = Class.forName(string);
            }
            catch (Exception exception) {
                throw new ServletException((Throwable)exception);
            }
        } else {
            if (this.getClass().equals(BurlapServlet.class)) {
                throw new ServletException("server must extend BurlapServlet");
            }
            this._serviceClass = this.getClass();
        }
        try {
            this._service = this._serviceClass.newInstance();
        }
        catch (Exception exception) {
            throw new ServletException((Throwable)exception);
        }
        if (this._service instanceof BurlapServlet) {
            ((BurlapServlet)this._service).setService(true);
        }
        if (this._service instanceof Service) {
            ((Service)this._service).init(this.getServletConfig());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        if (!httpServletRequest.getMethod().equals("POST")) {
            httpServletResponse.setStatus(500, "Burlap Requires POST");
            PrintWriter printWriter = httpServletResponse.getWriter();
            httpServletResponse.setContentType("text/html");
            printWriter.println("<h1>Burlap Requires POST</h1>");
            return;
        }
        Object object = this._service;
        synchronized (object) {
            if (this._skeleton == null) {
                this._skeleton = new BurlapSkeleton(this._service);
            }
            String string = httpServletRequest.getPathInfo();
            String string2 = servletRequest.getParameter("ejbid");
            if (this._service instanceof Service) {
                ((Service)this._service).setRequestObject(servletRequest, string, string2);
            }
            ServletInputStream servletInputStream = servletRequest.getInputStream();
            ServletOutputStream servletOutputStream = servletResponse.getOutputStream();
            BurlapInput burlapInput = new BurlapInput((InputStream)servletInputStream);
            BurlapOutput burlapOutput = new BurlapOutput((OutputStream)servletOutputStream);
            try {
                this._skeleton.invoke(burlapInput, burlapOutput);
            }
            catch (Throwable throwable) {
                throw new ServletException(throwable);
            }
        }
    }
}

