/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.client;

import com.caucho.hessian.client.HessianProxy;
import com.caucho.hessian.client.HessianProxyResolver;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import com.caucho.hessian.io.HessianRemoteObject;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.services.client.ServiceProxyFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class HessianProxyFactory
implements ServiceProxyFactory,
ObjectFactory {
    private HessianRemoteResolver _resolver = new HessianProxyResolver(this);
    private String _user;
    private String _password;
    private String _basicAuth;
    private boolean _isOverloadEnabled = false;

    public void setUser(String string) {
        this._user = string;
        this._basicAuth = null;
    }

    public void setPassword(String string) {
        this._password = string;
        this._basicAuth = null;
    }

    public boolean isOverloadEnabled() {
        return this._isOverloadEnabled;
    }

    public void setOverloadEnabled(boolean bl) {
        this._isOverloadEnabled = bl;
    }

    public HessianRemoteResolver getRemoteResolver() {
        return this._resolver;
    }

    protected URLConnection openConnection(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setDoOutput(true);
        if (this._basicAuth != null) {
            uRLConnection.setRequestProperty("Authorization", this._basicAuth);
        } else if (this._user != null && this._password != null) {
            this._basicAuth = "Basic " + this.base64(this._user + ":" + this._password);
            uRLConnection.setRequestProperty("Authorization", this._basicAuth);
        }
        return uRLConnection;
    }

    public Object create(Class clazz, String string) throws MalformedURLException {
        HessianProxy hessianProxy = new HessianProxy(this, new URL(string));
        return Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, HessianRemoteObject.class}, (InvocationHandler)hessianProxy);
    }

    public AbstractHessianInput getHessianInput(InputStream inputStream) {
        HessianInput hessianInput = new HessianInput(inputStream);
        hessianInput.setRemoteResolver(this.getRemoteResolver());
        return hessianInput;
    }

    public HessianOutput getHessianOutput(OutputStream outputStream) {
        HessianOutput hessianOutput = new HessianOutput(outputStream);
        return hessianOutput;
    }

    public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
        Serializable serializable;
        Reference reference = (Reference)object;
        String string = null;
        String string2 = null;
        Object var8_8 = null;
        Object var9_9 = null;
        for (int i = 0; i < reference.size(); ++i) {
            serializable = reference.get(i);
            String string3 = serializable.getType();
            String string4 = (String)serializable.getContent();
            if (string3.equals("type")) {
                string = string4;
                continue;
            }
            if (string3.equals("url")) {
                string2 = string4;
                continue;
            }
            if (string3.equals("user")) {
                this.setUser(string4);
                continue;
            }
            if (!string3.equals("password")) continue;
            this.setPassword(string4);
        }
        if (string2 == null) {
            throw new NamingException("`url' must be configured for HessianProxyFactory.");
        }
        if (string == null) {
            throw new NamingException("`type' must be configured for HessianProxyFactory.");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        serializable = Class.forName(string, false, classLoader);
        return this.create((Class)serializable, string2);
    }

    private String base64(String string) {
        long l;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        n = 0;
        while (n + 2 < string.length()) {
            l = string.charAt(n);
            l = (l << 8) + (long)string.charAt(n + 1);
            l = (l << 8) + (long)string.charAt(n + 2);
            stringBuffer.append(HessianProxyFactory.encode(l >> 18));
            stringBuffer.append(HessianProxyFactory.encode(l >> 12));
            stringBuffer.append(HessianProxyFactory.encode(l >> 6));
            stringBuffer.append(HessianProxyFactory.encode(l));
            n += 3;
        }
        if (n + 1 < string.length()) {
            l = string.charAt(n);
            l = (l << 8) + (long)string.charAt(n + 1);
            stringBuffer.append(HessianProxyFactory.encode((l <<= 8) >> 18));
            stringBuffer.append(HessianProxyFactory.encode(l >> 12));
            stringBuffer.append(HessianProxyFactory.encode(l >> 6));
            stringBuffer.append('=');
        } else if (n < string.length()) {
            l = string.charAt(n);
            stringBuffer.append(HessianProxyFactory.encode((l <<= 16) >> 18));
            stringBuffer.append(HessianProxyFactory.encode(l >> 12));
            stringBuffer.append('=');
            stringBuffer.append('=');
        }
        return stringBuffer.toString();
    }

    public static char encode(long l) {
        if ((l &= 0x3FL) < 26L) {
            return (char)(l + 65L);
        }
        if (l < 52L) {
            return (char)(l + 97L - 26L);
        }
        if (l < 62L) {
            return (char)(l + 48L - 52L);
        }
        if (l == 62L) {
            return '+';
        }
        return '/';
    }
}

