/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import [Ljava.lang.Object;;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractListDeserializer;
import com.caucho.hessian.io.Deserializer;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;

public class ArrayDeserializer
extends AbstractListDeserializer {
    private Class _componentType;

    public ArrayDeserializer(Deserializer deserializer) {
        if (deserializer != null) {
            this._componentType = deserializer.getType();
        }
    }

    public Class getType() {
        return Object;.class;
    }

    public Object readList(AbstractHessianInput abstractHessianInput, int n) throws IOException {
        if (n >= 0) {
            Object[] objectArray = this.createArray(n);
            abstractHessianInput.addRef(objectArray);
            if (this._componentType != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = abstractHessianInput.readObject(this._componentType);
                }
            } else {
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = abstractHessianInput.readObject();
                }
            }
            abstractHessianInput.readListEnd();
            return objectArray;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        abstractHessianInput.addRef(arrayList);
        if (this._componentType != null) {
            while (!abstractHessianInput.isEnd()) {
                arrayList.add(abstractHessianInput.readObject(this._componentType));
            }
        } else {
            while (!abstractHessianInput.isEnd()) {
                arrayList.add(abstractHessianInput.readObject());
            }
        }
        abstractHessianInput.readListEnd();
        Object[] objectArray = this.createArray(arrayList.size());
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = arrayList.get(i);
        }
        return objectArray;
    }

    protected Object[] createArray(int n) {
        if (this._componentType != null) {
            return (Object[])Array.newInstance(this._componentType, n);
        }
        return new Object[n];
    }

    public String toString() {
        return "ArrayDeserializer[" + this._componentType + "]";
    }
}

