/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import [Ljava.lang.Object;;
import [Ljava.lang.String;;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.Deserializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;

public class BasicDeserializer
extends Deserializer {
    public static final int NULL = 0;
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int SHORT = 3;
    public static final int INTEGER = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int CHARACTER = 8;
    public static final int STRING = 9;
    public static final int DATE = 10;
    public static final int BOOLEAN_ARRAY = 11;
    public static final int BYTE_ARRAY = 12;
    public static final int SHORT_ARRAY = 13;
    public static final int INTEGER_ARRAY = 14;
    public static final int LONG_ARRAY = 15;
    public static final int FLOAT_ARRAY = 16;
    public static final int DOUBLE_ARRAY = 17;
    public static final int CHARACTER_ARRAY = 18;
    public static final int STRING_ARRAY = 19;
    public static final int OBJECT_ARRAY = 20;
    private int _code;

    public BasicDeserializer(int n) {
        this._code = n;
    }

    public Class getType() {
        switch (this._code) {
            case 0: {
                return Void.TYPE;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return Byte.class;
            }
            case 3: {
                return Short.class;
            }
            case 4: {
                return Integer.class;
            }
            case 5: {
                return Long.class;
            }
            case 6: {
                return Float.class;
            }
            case 7: {
                return Double.class;
            }
            case 8: {
                return Character.class;
            }
            case 9: {
                return String.class;
            }
            case 10: {
                return Date.class;
            }
            case 11: {
                return [Z.class;
            }
            case 12: {
                return [B.class;
            }
            case 13: {
                return [S.class;
            }
            case 14: {
                return [I.class;
            }
            case 15: {
                return [J.class;
            }
            case 16: {
                return [F.class;
            }
            case 17: {
                return [D.class;
            }
            case 18: {
                return [C.class;
            }
            case 19: {
                return String;.class;
            }
            case 20: {
                return Object;.class;
            }
        }
        throw new UnsupportedOperationException();
    }

    public Object readObject(AbstractHessianInput abstractHessianInput) throws IOException {
        switch (this._code) {
            case 1: {
                return new Boolean(abstractHessianInput.readBoolean());
            }
            case 2: {
                return new Byte((byte)abstractHessianInput.readInt());
            }
            case 3: {
                return new Short((short)abstractHessianInput.readInt());
            }
            case 4: {
                return new Integer(abstractHessianInput.readInt());
            }
            case 5: {
                return new Long(abstractHessianInput.readLong());
            }
            case 6: {
                return new Float((float)abstractHessianInput.readDouble());
            }
            case 7: {
                return new Double(abstractHessianInput.readDouble());
            }
            case 9: {
                return abstractHessianInput.readString();
            }
            case 10: {
                return new Date(abstractHessianInput.readUTCDate());
            }
            case 12: {
                return abstractHessianInput.readBytes();
            }
            case 18: {
                String string = abstractHessianInput.readString();
                if (string == null) {
                    return null;
                }
                int n = string.length();
                char[] cArray = new char[n];
                string.getChars(0, n, cArray, 0);
                return cArray;
            }
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: {
                if (abstractHessianInput.readListStart() == 78) {
                    return null;
                }
                String string = abstractHessianInput.readType();
                int n = abstractHessianInput.readLength();
                return this.readList(abstractHessianInput, n);
            }
        }
        throw new UnsupportedOperationException();
    }

    public Object readList(AbstractHessianInput abstractHessianInput, int n) throws IOException {
        switch (this._code) {
            case 11: {
                if (n >= 0) {
                    boolean[] blArray = new boolean[n];
                    abstractHessianInput.addRef(blArray);
                    for (int i = 0; i < blArray.length; ++i) {
                        blArray[i] = abstractHessianInput.readBoolean();
                    }
                    abstractHessianInput.readEnd();
                    return blArray;
                }
                ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
                while (!abstractHessianInput.isEnd()) {
                    arrayList.add(new Boolean(abstractHessianInput.readBoolean()));
                }
                abstractHessianInput.readEnd();
                boolean[] blArray = new boolean[arrayList.size()];
                abstractHessianInput.addRef(blArray);
                for (int i = 0; i < blArray.length; ++i) {
                    blArray[i] = (Boolean)arrayList.get(i);
                }
                return blArray;
            }
            case 13: {
                if (n >= 0) {
                    short[] sArray = new short[n];
                    abstractHessianInput.addRef(sArray);
                    for (int i = 0; i < sArray.length; ++i) {
                        sArray[i] = (short)abstractHessianInput.readInt();
                    }
                    abstractHessianInput.readEnd();
                    return sArray;
                }
                ArrayList<Short> arrayList = new ArrayList<Short>();
                while (!abstractHessianInput.isEnd()) {
                    arrayList.add(new Short((short)abstractHessianInput.readInt()));
                }
                abstractHessianInput.readEnd();
                short[] sArray = new short[arrayList.size()];
                for (int i = 0; i < sArray.length; ++i) {
                    sArray[i] = (Short)arrayList.get(i);
                }
                abstractHessianInput.addRef(sArray);
                return sArray;
            }
            case 14: {
                if (n >= 0) {
                    int[] nArray = new int[n];
                    abstractHessianInput.addRef(nArray);
                    for (int i = 0; i < nArray.length; ++i) {
                        nArray[i] = abstractHessianInput.readInt();
                    }
                    abstractHessianInput.readEnd();
                    return nArray;
                }
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                while (!abstractHessianInput.isEnd()) {
                    arrayList.add(new Integer(abstractHessianInput.readInt()));
                }
                abstractHessianInput.readEnd();
                int[] nArray = new int[arrayList.size()];
                for (int i = 0; i < nArray.length; ++i) {
                    nArray[i] = (Integer)arrayList.get(i);
                }
                abstractHessianInput.addRef(nArray);
                return nArray;
            }
            case 15: {
                if (n >= 0) {
                    long[] lArray = new long[n];
                    abstractHessianInput.addRef(lArray);
                    for (int i = 0; i < lArray.length; ++i) {
                        lArray[i] = abstractHessianInput.readLong();
                    }
                    abstractHessianInput.readEnd();
                    return lArray;
                }
                ArrayList<Long> arrayList = new ArrayList<Long>();
                while (!abstractHessianInput.isEnd()) {
                    arrayList.add(new Long(abstractHessianInput.readLong()));
                }
                abstractHessianInput.readEnd();
                long[] lArray = new long[arrayList.size()];
                for (int i = 0; i < lArray.length; ++i) {
                    lArray[i] = (Long)arrayList.get(i);
                }
                abstractHessianInput.addRef(lArray);
                return lArray;
            }
            case 16: {
                if (n >= 0) {
                    float[] fArray = new float[n];
                    abstractHessianInput.addRef(fArray);
                    for (int i = 0; i < fArray.length; ++i) {
                        fArray[i] = (float)abstractHessianInput.readDouble();
                    }
                    abstractHessianInput.readEnd();
                    return fArray;
                }
                ArrayList<Float> arrayList = new ArrayList<Float>();
                while (!abstractHessianInput.isEnd()) {
                    arrayList.add(new Float(abstractHessianInput.readDouble()));
                }
                abstractHessianInput.readEnd();
                float[] fArray = new float[arrayList.size()];
                for (int i = 0; i < fArray.length; ++i) {
                    fArray[i] = ((Float)arrayList.get(i)).floatValue();
                }
                abstractHessianInput.addRef(fArray);
                return fArray;
            }
            case 17: {
                if (n >= 0) {
                    double[] dArray = new double[n];
                    abstractHessianInput.addRef(dArray);
                    for (int i = 0; i < dArray.length; ++i) {
                        dArray[i] = abstractHessianInput.readDouble();
                    }
                    abstractHessianInput.readEnd();
                    return dArray;
                }
                ArrayList<Double> arrayList = new ArrayList<Double>();
                while (!abstractHessianInput.isEnd()) {
                    arrayList.add(new Double(abstractHessianInput.readDouble()));
                }
                abstractHessianInput.readEnd();
                double[] dArray = new double[arrayList.size()];
                abstractHessianInput.addRef(dArray);
                for (int i = 0; i < dArray.length; ++i) {
                    dArray[i] = ((Double)arrayList.get(i)).intValue();
                }
                return dArray;
            }
            case 19: {
                if (n >= 0) {
                    String[] stringArray = new String[n];
                    abstractHessianInput.addRef(stringArray);
                    for (int i = 0; i < stringArray.length; ++i) {
                        stringArray[i] = abstractHessianInput.readString();
                    }
                    abstractHessianInput.readEnd();
                    return stringArray;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                while (!abstractHessianInput.isEnd()) {
                    arrayList.add(abstractHessianInput.readString());
                }
                abstractHessianInput.readEnd();
                String[] stringArray = new String[arrayList.size()];
                abstractHessianInput.addRef(stringArray);
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = (String)arrayList.get(i);
                }
                return stringArray;
            }
            case 20: {
                if (n >= 0) {
                    Object[] objectArray = new Object[n];
                    abstractHessianInput.addRef(objectArray);
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray[i] = abstractHessianInput.readObject();
                    }
                    abstractHessianInput.readEnd();
                    return objectArray;
                }
                ArrayList<Object> arrayList = new ArrayList<Object>();
                abstractHessianInput.addRef(arrayList);
                while (!abstractHessianInput.isEnd()) {
                    arrayList.add(abstractHessianInput.readObject());
                }
                abstractHessianInput.readEnd();
                Object[] objectArray = new Object[arrayList.size()];
                for (int i = 0; i < objectArray.length; ++i) {
                    objectArray[i] = arrayList.get(i);
                }
                return objectArray;
            }
        }
        throw new UnsupportedOperationException(String.valueOf(this));
    }
}

