/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.Serializer;
import java.io.IOException;
import java.util.Date;

public class BasicSerializer
extends Serializer {
    public static final int NULL = 0;
    public static final int BOOLEAN = 1;
    public static final int BYTE = 2;
    public static final int SHORT = 3;
    public static final int INTEGER = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int CHARACTER = 8;
    public static final int STRING = 9;
    public static final int DATE = 10;
    public static final int BOOLEAN_ARRAY = 11;
    public static final int BYTE_ARRAY = 12;
    public static final int SHORT_ARRAY = 13;
    public static final int INTEGER_ARRAY = 14;
    public static final int LONG_ARRAY = 15;
    public static final int FLOAT_ARRAY = 16;
    public static final int DOUBLE_ARRAY = 17;
    public static final int CHARACTER_ARRAY = 18;
    public static final int STRING_ARRAY = 19;
    public static final int OBJECT_ARRAY = 20;
    private int code;

    public BasicSerializer(int n) {
        this.code = n;
    }

    public void writeObject(Object object, AbstractHessianOutput abstractHessianOutput) throws IOException {
        switch (this.code) {
            case 1: {
                abstractHessianOutput.writeBoolean((Boolean)object);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                abstractHessianOutput.writeInt(((Number)object).intValue());
                break;
            }
            case 5: {
                abstractHessianOutput.writeLong(((Number)object).longValue());
                break;
            }
            case 6: 
            case 7: {
                abstractHessianOutput.writeDouble(((Number)object).doubleValue());
                break;
            }
            case 8: {
                abstractHessianOutput.writeInt(((Character)object).charValue());
                break;
            }
            case 9: {
                abstractHessianOutput.writeString((String)object);
                break;
            }
            case 10: {
                abstractHessianOutput.writeUTCDate(((Date)object).getTime());
                break;
            }
            case 11: {
                if (abstractHessianOutput.addRef(object)) {
                    return;
                }
                boolean[] blArray = (boolean[])object;
                abstractHessianOutput.writeListBegin(blArray.length, "[boolean");
                for (int i = 0; i < blArray.length; ++i) {
                    abstractHessianOutput.writeBoolean(blArray[i]);
                }
                abstractHessianOutput.writeListEnd();
                break;
            }
            case 12: {
                byte[] byArray = (byte[])object;
                abstractHessianOutput.writeBytes(byArray, 0, byArray.length);
                break;
            }
            case 13: {
                if (abstractHessianOutput.addRef(object)) {
                    return;
                }
                short[] sArray = (short[])object;
                abstractHessianOutput.writeListBegin(sArray.length, "[short");
                for (int i = 0; i < sArray.length; ++i) {
                    abstractHessianOutput.writeInt(sArray[i]);
                }
                abstractHessianOutput.writeListEnd();
                break;
            }
            case 14: {
                if (abstractHessianOutput.addRef(object)) {
                    return;
                }
                int[] nArray = (int[])object;
                abstractHessianOutput.writeListBegin(nArray.length, "[int");
                for (int i = 0; i < nArray.length; ++i) {
                    abstractHessianOutput.writeInt(nArray[i]);
                }
                abstractHessianOutput.writeListEnd();
                break;
            }
            case 15: {
                if (abstractHessianOutput.addRef(object)) {
                    return;
                }
                long[] lArray = (long[])object;
                abstractHessianOutput.writeListBegin(lArray.length, "[long");
                for (int i = 0; i < lArray.length; ++i) {
                    abstractHessianOutput.writeLong(lArray[i]);
                }
                abstractHessianOutput.writeListEnd();
                break;
            }
            case 16: {
                if (abstractHessianOutput.addRef(object)) {
                    return;
                }
                float[] fArray = (float[])object;
                abstractHessianOutput.writeListBegin(fArray.length, "[float");
                for (int i = 0; i < fArray.length; ++i) {
                    abstractHessianOutput.writeDouble(fArray[i]);
                }
                abstractHessianOutput.writeListEnd();
                break;
            }
            case 17: {
                if (abstractHessianOutput.addRef(object)) {
                    return;
                }
                double[] dArray = (double[])object;
                abstractHessianOutput.writeListBegin(dArray.length, "[double");
                for (int i = 0; i < dArray.length; ++i) {
                    abstractHessianOutput.writeDouble(dArray[i]);
                }
                abstractHessianOutput.writeListEnd();
                break;
            }
            case 19: {
                if (abstractHessianOutput.addRef(object)) {
                    return;
                }
                String[] stringArray = (String[])object;
                abstractHessianOutput.writeListBegin(stringArray.length, "[string");
                for (int i = 0; i < stringArray.length; ++i) {
                    abstractHessianOutput.writeString(stringArray[i]);
                }
                abstractHessianOutput.writeListEnd();
                break;
            }
            case 18: {
                char[] cArray = (char[])object;
                abstractHessianOutput.writeString(cArray, 0, cArray.length);
                break;
            }
            case 20: {
                if (abstractHessianOutput.addRef(object)) {
                    return;
                }
                Object[] objectArray = (Object[])object;
                abstractHessianOutput.writeListBegin(objectArray.length, "[object");
                for (int i = 0; i < objectArray.length; ++i) {
                    abstractHessianOutput.writeObject(objectArray[i]);
                }
                abstractHessianOutput.writeListEnd();
                break;
            }
            default: {
                throw new RuntimeException(this.code + " " + String.valueOf(object.getClass()));
            }
        }
    }
}

