/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.HessianRemote;
import com.caucho.hessian.io.HessianRemoteResolver;
import com.caucho.hessian.io.HessianServiceException;
import com.caucho.hessian.io.SerializerFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.w3c.dom.Node;

public class HessianInput
extends AbstractHessianInput {
    private static int END_OF_DATA = -2;
    protected SerializerFactory _serializerFactory;
    protected ArrayList _refs;
    private InputStream _is;
    protected int _peek = -1;
    private String _method;
    private Reader _chunkReader;
    private InputStream _chunkInputStream;
    private boolean _isLastChunk;
    private int _chunkLength;

    public HessianInput() {
    }

    public HessianInput(InputStream inputStream) {
        this.init(inputStream);
    }

    public void setSerializerFactory(SerializerFactory serializerFactory) {
        this._serializerFactory = serializerFactory;
    }

    public SerializerFactory getSerializerFactory() {
        return this._serializerFactory;
    }

    public void init(InputStream inputStream) {
        this._is = inputStream;
        this._method = null;
        this._isLastChunk = true;
        this._chunkLength = 0;
        this._peek = -1;
        this._refs = null;
        if (this._serializerFactory == null) {
            this._serializerFactory = new SerializerFactory();
        }
    }

    public String getMethod() {
        return this._method;
    }

    public void startCall() throws IOException {
        int n;
        int n2 = this.read();
        if (n2 != 99) {
            throw this.error("expected hessian call ('c') at code=" + n2 + " ch=" + (char)n2);
        }
        int n3 = this.read();
        int n4 = this.read();
        n2 = this.read();
        if (n2 != 109) {
            throw this.error("expected hessian method ('m') at code=" + n2 + " ch=" + (char)n2);
        }
        int n5 = this.read();
        int n6 = this.read();
        this._isLastChunk = true;
        this._chunkLength = n5 * 256 + n6;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.parseChar()) >= 0) {
            stringBuffer.append((char)n);
        }
        this._method = stringBuffer.toString();
    }

    public void completeCall() throws IOException {
        int n = this.read();
        if (n != 122) {
            throw this.expect("end of call", n);
        }
    }

    public Object readReply(Class clazz) throws Throwable {
        int n = this.read();
        if (n != 114) {
            this.error("expected hessian reply");
        }
        int n2 = this.read();
        int n3 = this.read();
        n = this.read();
        if (n == 102) {
            HashMap hashMap = this.readFault();
            this.completeReply();
            Object v = hashMap.get("detail");
            if (v instanceof Throwable) {
                throw (Throwable)v;
            }
            String string = (String)hashMap.get("code");
            String string2 = (String)hashMap.get("message");
            throw new HessianServiceException(string2, string, v);
        }
        this._peek = n;
        Object object = this.readObject(clazz);
        this.completeValueReply();
        return object;
    }

    public void startReply() throws Throwable {
        int n = this.read();
        if (n != 114) {
            this.error("expected hessian reply");
        }
        int n2 = this.read();
        int n3 = this.read();
        n = this.read();
        if (n == 102) {
            HashMap hashMap = this.readFault();
            Object v = hashMap.get("detail");
            if (v instanceof Throwable) {
                throw (Throwable)v;
            }
            String string = (String)hashMap.get("code");
            String string2 = (String)hashMap.get("message");
            throw new HessianServiceException(string2, string, v);
        }
        this._peek = n;
    }

    public void completeReply() throws IOException {
        int n = this.read();
        if (n != 122) {
            this.error("expected end of reply");
        }
    }

    public void completeValueReply() throws IOException {
        int n = this.read();
        if (n != 122) {
            this.error("expected end of reply");
        }
    }

    public String readHeader() throws IOException {
        int n = this.read();
        if (n == 72) {
            int n2;
            this._isLastChunk = true;
            this._chunkLength = (this.read() << 8) + this.read();
            StringBuffer stringBuffer = new StringBuffer();
            while ((n2 = this.parseChar()) >= 0) {
                stringBuffer.append((char)n2);
            }
            return stringBuffer.toString();
        }
        this._peek = n;
        return null;
    }

    public void readNull() throws IOException {
        int n = this.read();
        switch (n) {
            case 78: {
                return;
            }
        }
        throw this.expect("null", n);
    }

    public boolean readBoolean() throws IOException {
        int n = this.read();
        switch (n) {
            case 84: {
                return true;
            }
            case 70: {
                return false;
            }
            case 73: {
                return this.parseInt() == 0;
            }
            case 76: {
                return this.parseLong() == 0L;
            }
            case 68: {
                return this.parseDouble() == 0.0;
            }
            case 78: {
                return false;
            }
        }
        throw this.expect("boolean", n);
    }

    public int readInt() throws IOException {
        int n = this.read();
        switch (n) {
            case 84: {
                return 1;
            }
            case 70: {
                return 0;
            }
            case 73: {
                return this.parseInt();
            }
            case 76: {
                return (int)this.parseLong();
            }
            case 68: {
                return (int)this.parseDouble();
            }
        }
        throw this.expect("int", n);
    }

    public long readLong() throws IOException {
        int n = this.read();
        switch (n) {
            case 84: {
                return 1L;
            }
            case 70: {
                return 0L;
            }
            case 73: {
                return this.parseInt();
            }
            case 76: {
                return this.parseLong();
            }
            case 68: {
                return (long)this.parseDouble();
            }
        }
        throw this.expect("long", n);
    }

    public double readDouble() throws IOException {
        int n = this.read();
        switch (n) {
            case 84: {
                return 1.0;
            }
            case 70: {
                return 0.0;
            }
            case 73: {
                return this.parseInt();
            }
            case 76: {
                return this.parseLong();
            }
            case 68: {
                return this.parseDouble();
            }
        }
        throw this.expect("long", n);
    }

    public long readUTCDate() throws IOException {
        int n = this.read();
        if (n != 100) {
            throw this.error("expected date");
        }
        long l = this.read();
        long l2 = this.read();
        long l3 = this.read();
        long l4 = this.read();
        long l5 = this.read();
        long l6 = this.read();
        long l7 = this.read();
        long l8 = this.read();
        return (l << 56) + (l2 << 48) + (l3 << 40) + (l4 << 32) + (l5 << 24) + (l6 << 16) + (l7 << 8) + l8;
    }

    public int readChar() throws IOException {
        if (this._chunkLength > 0) {
            --this._chunkLength;
            if (this._chunkLength == 0 && this._isLastChunk) {
                this._chunkLength = END_OF_DATA;
            }
            int n = this.parseUTF8Char();
            return n;
        }
        if (this._chunkLength == END_OF_DATA) {
            this._chunkLength = 0;
            return -1;
        }
        int n = this.read();
        switch (n) {
            case 78: {
                return -1;
            }
            case 83: 
            case 88: 
            case 115: 
            case 120: {
                this._isLastChunk = n == 83 || n == 88;
                this._chunkLength = (this.read() << 8) + this.read();
                --this._chunkLength;
                int n2 = this.parseUTF8Char();
                if (this._chunkLength == 0 && this._isLastChunk) {
                    this._chunkLength = END_OF_DATA;
                }
                return n2;
            }
        }
        throw new IOException("expected 'S' at " + (char)n);
    }

    public int readString(char[] cArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        if (this._chunkLength == END_OF_DATA) {
            this._chunkLength = 0;
            return -1;
        }
        if (this._chunkLength == 0) {
            n3 = this.read();
            switch (n3) {
                case 78: {
                    return -1;
                }
                case 83: 
                case 88: 
                case 115: 
                case 120: {
                    this._isLastChunk = n3 == 83 || n3 == 88;
                    this._chunkLength = (this.read() << 8) + this.read();
                    break;
                }
                default: {
                    throw new IOException("expected 'S' at " + (char)n3);
                }
            }
        }
        block7: while (n2 > 0) {
            if (this._chunkLength > 0) {
                cArray[n++] = (char)this.parseUTF8Char();
                --this._chunkLength;
                --n2;
                ++n4;
                continue;
            }
            if (this._isLastChunk) {
                if (n4 == 0) {
                    return -1;
                }
                this._chunkLength = END_OF_DATA;
                return n4;
            }
            n3 = this.read();
            switch (n3) {
                case 83: 
                case 88: 
                case 115: 
                case 120: {
                    this._isLastChunk = n3 == 83 || n3 == 88;
                    this._chunkLength = (this.read() << 8) + this.read();
                    continue block7;
                }
            }
            throw new IOException("expected 'S' at " + (char)n3);
        }
        if (n4 == 0) {
            return -1;
        }
        if (this._chunkLength > 0 || !this._isLastChunk) {
            return n4;
        }
        this._chunkLength = END_OF_DATA;
        return n4;
    }

    public String readString() throws IOException {
        int n = this.read();
        switch (n) {
            case 78: {
                return null;
            }
            case 73: {
                return String.valueOf(this.parseInt());
            }
            case 76: {
                return String.valueOf(this.parseLong());
            }
            case 68: {
                return String.valueOf(this.parseDouble());
            }
            case 83: 
            case 88: 
            case 115: 
            case 120: {
                int n2;
                this._isLastChunk = n == 83 || n == 88;
                this._chunkLength = (this.read() << 8) + this.read();
                StringBuffer stringBuffer = new StringBuffer();
                while ((n2 = this.parseChar()) >= 0) {
                    stringBuffer.append((char)n2);
                }
                return stringBuffer.toString();
            }
        }
        throw this.expect("string", n);
    }

    public Node readNode() throws IOException {
        int n = this.read();
        switch (n) {
            case 78: {
                return null;
            }
            case 83: 
            case 88: 
            case 115: 
            case 120: {
                this._isLastChunk = n == 83 || n == 88;
                this._chunkLength = (this.read() << 8) + this.read();
                throw this.error("can't cope");
            }
        }
        throw this.expect("string", n);
    }

    public byte[] readBytes() throws IOException {
        int n = this.read();
        switch (n) {
            case 78: {
                return null;
            }
            case 66: 
            case 98: {
                int n2;
                this._isLastChunk = n == 66;
                this._chunkLength = (this.read() << 8) + this.read();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n2 = this.parseByte()) >= 0) {
                    byteArrayOutputStream.write(n2);
                }
                return byteArrayOutputStream.toByteArray();
            }
        }
        throw this.expect("bytes", n);
    }

    public int readByte() throws IOException {
        if (this._chunkLength > 0) {
            --this._chunkLength;
            if (this._chunkLength == 0 && this._isLastChunk) {
                this._chunkLength = END_OF_DATA;
            }
            return this.read();
        }
        if (this._chunkLength == END_OF_DATA) {
            this._chunkLength = 0;
            return -1;
        }
        int n = this.read();
        switch (n) {
            case 78: {
                return -1;
            }
            case 66: 
            case 98: {
                this._isLastChunk = n == 66;
                this._chunkLength = (this.read() << 8) + this.read();
                int n2 = this.parseByte();
                if (this._chunkLength == 0 && this._isLastChunk) {
                    this._chunkLength = END_OF_DATA;
                }
                return n2;
            }
        }
        throw new IOException("expected 'B' at " + (char)n);
    }

    public int readBytes(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = 0;
        if (this._chunkLength == END_OF_DATA) {
            this._chunkLength = 0;
            return -1;
        }
        if (this._chunkLength == 0) {
            n3 = this.read();
            switch (n3) {
                case 78: {
                    return -1;
                }
                case 66: 
                case 98: {
                    this._isLastChunk = n3 == 66;
                    this._chunkLength = (this.read() << 8) + this.read();
                    break;
                }
                default: {
                    throw new IOException("expected 'B' at " + (char)n3);
                }
            }
        }
        block7: while (n2 > 0) {
            if (this._chunkLength > 0) {
                byArray[n++] = (byte)this.read();
                --this._chunkLength;
                --n2;
                ++n4;
                continue;
            }
            if (this._isLastChunk) {
                if (n4 == 0) {
                    return -1;
                }
                this._chunkLength = END_OF_DATA;
                return n4;
            }
            n3 = this.read();
            switch (n3) {
                case 66: 
                case 98: {
                    this._isLastChunk = n3 == 66;
                    this._chunkLength = (this.read() << 8) + this.read();
                    continue block7;
                }
            }
            throw new IOException("expected 'B' at " + (char)n3);
        }
        if (n4 == 0) {
            return -1;
        }
        if (this._chunkLength > 0 || !this._isLastChunk) {
            return n4;
        }
        this._chunkLength = END_OF_DATA;
        return n4;
    }

    private HashMap readFault() throws IOException {
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        int n = this.read();
        while (n > 0 && n != 122) {
            this._peek = n;
            Object object = this.readObject();
            Object object2 = this.readObject();
            if (object != null && object2 != null) {
                hashMap.put(object, object2);
            }
            n = this.read();
        }
        if (n != 122) {
            throw this.expect("fault", n);
        }
        return hashMap;
    }

    public Object readObject(Class clazz) throws IOException {
        if (clazz == null) {
            return this.readObject();
        }
        int n = this.read();
        switch (n) {
            case 78: {
                return null;
            }
            case 77: {
                String string = this.readType();
                Deserializer deserializer = this._serializerFactory.getObjectDeserializer(string);
                if (clazz != deserializer.getType() && clazz.isAssignableFrom(deserializer.getType())) {
                    return deserializer.readMap(this);
                }
                deserializer = this._serializerFactory.getDeserializer(clazz);
                return deserializer.readMap(this);
            }
            case 86: {
                String string = this.readType();
                int n2 = this.readLength();
                Deserializer deserializer = this._serializerFactory.getObjectDeserializer(string);
                if (clazz != deserializer.getType() && clazz.isAssignableFrom(deserializer.getType())) {
                    return deserializer.readList(this, n2);
                }
                deserializer = this._serializerFactory.getDeserializer(clazz);
                return deserializer.readList(this, n2);
            }
            case 82: {
                int n3 = this.parseInt();
                return this._refs.get(n3);
            }
            case 114: {
                String string = this.readType();
                String string2 = this.readString();
                return this.resolveRemote(string, string2);
            }
        }
        this._peek = n;
        Object object = this._serializerFactory.getDeserializer(clazz).readObject(this);
        return object;
    }

    public Object readObject() throws IOException {
        int n = this.read();
        switch (n) {
            case 78: {
                return null;
            }
            case 84: {
                return new Boolean(true);
            }
            case 70: {
                return new Boolean(false);
            }
            case 73: {
                return new Integer(this.parseInt());
            }
            case 76: {
                return new Long(this.parseLong());
            }
            case 68: {
                return new Double(this.parseDouble());
            }
            case 100: {
                return new Date(this.parseLong());
            }
            case 88: 
            case 120: {
                this._isLastChunk = n == 88;
                this._chunkLength = (this.read() << 8) + this.read();
                return this.parseXML();
            }
            case 83: 
            case 115: {
                int n2;
                this._isLastChunk = n == 83;
                this._chunkLength = (this.read() << 8) + this.read();
                StringBuffer stringBuffer = new StringBuffer();
                while ((n2 = this.parseChar()) >= 0) {
                    stringBuffer.append((char)n2);
                }
                return stringBuffer.toString();
            }
            case 66: 
            case 98: {
                int n3;
                this._isLastChunk = n == 66;
                this._chunkLength = (this.read() << 8) + this.read();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                while ((n3 = this.parseByte()) >= 0) {
                    byteArrayOutputStream.write(n3);
                }
                return byteArrayOutputStream.toByteArray();
            }
            case 86: {
                String string = this.readType();
                int n4 = this.readLength();
                return this._serializerFactory.readList(this, n4, string);
            }
            case 77: {
                String string = this.readType();
                return this._serializerFactory.readMap(this, string);
            }
            case 82: {
                int n5 = this.parseInt();
                return this._refs.get(n5);
            }
            case 114: {
                String string = this.readType();
                String string2 = this.readString();
                return this.resolveRemote(string, string2);
            }
        }
        throw this.error("unknown code:" + (char)n);
    }

    public Object readRemote() throws IOException {
        String string = this.readType();
        String string2 = this.readString();
        return this.resolveRemote(string, string2);
    }

    public Object readRef() throws IOException {
        return this._refs.get(this.parseInt());
    }

    public int readListStart() throws IOException {
        return this.read();
    }

    public int readMapStart() throws IOException {
        return this.read();
    }

    public boolean isEnd() throws IOException {
        int n;
        this._peek = n = this.read();
        return n < 0 || n == 122;
    }

    public void readEnd() throws IOException {
        int n = this.read();
        if (n != 122) {
            throw this.error("unknown code:" + (char)n);
        }
    }

    public void readMapEnd() throws IOException {
        int n = this.read();
        if (n != 122) {
            throw this.error("unknown code:" + (char)n);
        }
    }

    public void readListEnd() throws IOException {
        int n = this.read();
        if (n != 122) {
            throw this.error("unknown code:" + (char)n);
        }
    }

    public int addRef(Object object) {
        if (this._refs == null) {
            this._refs = new ArrayList();
        }
        this._refs.add(object);
        return this._refs.size() - 1;
    }

    public void setRef(int n, Object object) {
        this._refs.set(n, object);
    }

    public Object resolveRemote(String string, String string2) throws IOException {
        HessianRemoteResolver hessianRemoteResolver = this.getRemoteResolver();
        if (hessianRemoteResolver != null) {
            return hessianRemoteResolver.lookup(string, string2);
        }
        return new HessianRemote(string, string2);
    }

    public String readType() throws IOException {
        int n;
        int n2 = this.read();
        if (n2 != 116) {
            this._peek = n2;
            return "";
        }
        this._isLastChunk = true;
        this._chunkLength = (this.read() << 8) + this.read();
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = this.parseChar()) >= 0) {
            stringBuffer.append((char)n);
        }
        return stringBuffer.toString();
    }

    public int readLength() throws IOException {
        int n = this.read();
        if (n != 108) {
            this._peek = n;
            return -1;
        }
        return this.parseInt();
    }

    private int parseInt() throws IOException {
        int n = this.read();
        int n2 = this.read();
        int n3 = this.read();
        int n4 = this.read();
        return (n << 24) + (n2 << 16) + (n3 << 8) + n4;
    }

    private long parseLong() throws IOException {
        long l = this.read();
        long l2 = this.read();
        long l3 = this.read();
        long l4 = this.read();
        long l5 = this.read();
        long l6 = this.read();
        long l7 = this.read();
        long l8 = this.read();
        return (l << 56) + (l2 << 48) + (l3 << 40) + (l4 << 32) + (l5 << 24) + (l6 << 16) + (l7 << 8) + l8;
    }

    private double parseDouble() throws IOException {
        long l = this.read();
        long l2 = this.read();
        long l3 = this.read();
        long l4 = this.read();
        long l5 = this.read();
        long l6 = this.read();
        long l7 = this.read();
        long l8 = this.read();
        long l9 = (l << 56) + (l2 << 48) + (l3 << 40) + (l4 << 32) + (l5 << 24) + (l6 << 16) + (l7 << 8) + l8;
        return Double.longBitsToDouble(l9);
    }

    Node parseXML() throws IOException {
        throw this.error("help!");
    }

    private int parseChar() throws IOException {
        block4: while (this._chunkLength <= 0) {
            if (this._isLastChunk) {
                return -1;
            }
            int n = this.read();
            switch (n) {
                case 115: 
                case 120: {
                    this._isLastChunk = false;
                    this._chunkLength = (this.read() << 8) + this.read();
                    continue block4;
                }
                case 83: 
                case 88: {
                    this._isLastChunk = true;
                    this._chunkLength = (this.read() << 8) + this.read();
                    continue block4;
                }
            }
            throw this.expect("string", n);
        }
        --this._chunkLength;
        return this.parseUTF8Char();
    }

    private int parseUTF8Char() throws IOException {
        int n = this.read();
        if (n < 128) {
            return n;
        }
        if ((n & 0xE0) == 192) {
            int n2 = this.read();
            int n3 = ((n & 0x1F) << 6) + (n2 & 0x3F);
            return n3;
        }
        if ((n & 0xF0) == 224) {
            int n4 = this.read();
            int n5 = this.read();
            int n6 = ((n & 0xF) << 12) + ((n4 & 0x3F) << 6) + (n5 & 0x3F);
            return n6;
        }
        throw this.error("bad utf-8 encoding");
    }

    private int parseByte() throws IOException {
        block4: while (this._chunkLength <= 0) {
            if (this._isLastChunk) {
                return -1;
            }
            int n = this.read();
            switch (n) {
                case 98: {
                    this._isLastChunk = false;
                    this._chunkLength = (this.read() << 8) + this.read();
                    continue block4;
                }
                case 66: {
                    this._isLastChunk = true;
                    this._chunkLength = (this.read() << 8) + this.read();
                    continue block4;
                }
            }
            throw this.expect("byte[]", n);
        }
        --this._chunkLength;
        return this.read();
    }

    int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n2 > 0) {
            int n4;
            block5: while (this._chunkLength <= 0) {
                if (this._isLastChunk) {
                    return n3 == 0 ? -1 : n3;
                }
                n4 = this.read();
                switch (n4) {
                    case 98: {
                        this._isLastChunk = false;
                        this._chunkLength = (this.read() << 8) + this.read();
                        continue block5;
                    }
                    case 66: {
                        this._isLastChunk = true;
                        this._chunkLength = (this.read() << 8) + this.read();
                        continue block5;
                    }
                }
                throw this.expect("byte[]", n4);
            }
            n4 = this._chunkLength;
            if (n2 < n4) {
                n4 = n2;
            }
            this.read(byArray, n, n4);
            n += n4;
            n3 += n4;
            n2 -= n4;
            this._chunkLength -= n4;
        }
        return n3;
    }

    final int read() throws IOException {
        if (this._peek >= 0) {
            int n = this._peek;
            this._peek = -1;
            return n;
        }
        int n = this._is.read();
        return n;
    }

    public Reader getReader() {
        return null;
    }

    public InputStream getInputStream() {
        return null;
    }

    protected IOException expect(String string, int n) {
        if (n < 0) {
            return this.error("expected " + string + " at end of file");
        }
        return this.error("expected " + string + " at " + (char)n);
    }

    protected IOException error(String string) {
        return new HessianProtocolException(string);
    }
}

