/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractMapDeserializer;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;

public class JavaDeserializer
extends AbstractMapDeserializer {
    private Class _type;
    private HashMap _fieldMap;
    private Method _readResolve;
    private Constructor _constructor;
    private Object[] _constructorArgs;

    public JavaDeserializer(Class clazz) {
        this._type = clazz;
        this._fieldMap = this.getFieldMap(clazz);
        try {
            this._readResolve = clazz.getMethod("readResolve", new Class[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Constructor<?>[] constructorArray = clazz.getConstructors();
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < constructorArray.length; ++i) {
            if (constructorArray[i].getParameterTypes().length >= n) continue;
            this._constructor = constructorArray[i];
            n = this._constructor.getParameterTypes().length;
        }
        if (this._constructor != null) {
            this._constructor.setAccessible(true);
            Class<?>[] classArray = this._constructor.getParameterTypes();
            this._constructorArgs = new Object[classArray.length];
            for (int i = 0; i < classArray.length; ++i) {
                this._constructorArgs[i] = JavaDeserializer.getParamArg(classArray[i]);
            }
        }
    }

    public Class getType() {
        return this._type;
    }

    public Object readMap(AbstractHessianInput abstractHessianInput) throws IOException {
        try {
            Object object = this.instantiate();
            return this.readMap(abstractHessianInput, object);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(String.valueOf(exception));
        }
    }

    public Object readMap(AbstractHessianInput abstractHessianInput, Object object) throws IOException {
        try {
            abstractHessianInput.addRef(object);
            while (!abstractHessianInput.isEnd()) {
                Object object2;
                Object object3 = abstractHessianInput.readObject();
                Field field = (Field)this._fieldMap.get(object3);
                if (field != null) {
                    object2 = abstractHessianInput.readObject(field.getType());
                    field.set(object, object2);
                    continue;
                }
                object2 = abstractHessianInput.readObject();
            }
            abstractHessianInput.readMapEnd();
            return this.resolve(object);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IOException(String.valueOf(exception));
        }
    }

    private Object resolve(Object object) {
        try {
            if (this._readResolve != null) {
                return this._readResolve.invoke(object, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    protected Object instantiate() throws Exception {
        return this._constructor.newInstance(this._constructorArgs);
    }

    protected HashMap getFieldMap(Class clazz) {
        HashMap<String, Field> hashMap = new HashMap<String, Field>();
        while (clazz != null) {
            Field[] fieldArray = clazz.getDeclaredFields();
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || hashMap.get(field.getName()) != null) continue;
                try {
                    field.setAccessible(true);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                hashMap.put(field.getName(), field);
            }
            clazz = clazz.getSuperclass();
        }
        return hashMap;
    }

    protected static Object getParamArg(Class clazz) {
        if (!clazz.isPrimitive()) {
            return null;
        }
        if (Boolean.TYPE.equals(clazz)) {
            return Boolean.FALSE;
        }
        if (Byte.TYPE.equals(clazz)) {
            return new Byte(0);
        }
        if (Short.TYPE.equals(clazz)) {
            return new Short(0);
        }
        if (Character.TYPE.equals(clazz)) {
            return new Character('\u0000');
        }
        if (Integer.TYPE.equals(clazz)) {
            return new Integer(0);
        }
        if (Long.TYPE.equals(clazz)) {
            return new Long(0L);
        }
        if (Float.TYPE.equals(clazz)) {
            return new Double(0.0);
        }
        if (Double.TYPE.equals(clazz)) {
            return new Double(0.0);
        }
        throw new UnsupportedOperationException();
    }
}

