/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import [Ljava.lang.Object;;
import [Ljava.lang.String;;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.ArrayDeserializer;
import com.caucho.hessian.io.ArraySerializer;
import com.caucho.hessian.io.BasicDeserializer;
import com.caucho.hessian.io.BasicSerializer;
import com.caucho.hessian.io.ClassDeserializer;
import com.caucho.hessian.io.ClassSerializer;
import com.caucho.hessian.io.CollectionDeserializer;
import com.caucho.hessian.io.CollectionSerializer;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.HessianRemoteObject;
import com.caucho.hessian.io.JavaDeserializer;
import com.caucho.hessian.io.JavaSerializer;
import com.caucho.hessian.io.MapDeserializer;
import com.caucho.hessian.io.MapSerializer;
import com.caucho.hessian.io.RemoteSerializer;
import com.caucho.hessian.io.Serializer;
import com.caucho.hessian.io.SqlDateDeserializer;
import com.caucho.hessian.io.SqlDateSerializer;
import com.caucho.hessian.io.StackTraceElementDeserializer;
import com.caucho.hessian.io.StringValueDeserializer;
import com.caucho.hessian.io.StringValueSerializer;
import com.caucho.hessian.io.ThrowableSerializer;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SerializerFactory {
    private static HashMap serializerMap = new HashMap();
    private static HashMap deserializerMap = new HashMap();
    private static HashMap typeMap = new HashMap();
    private Serializer _defaultSerializer;

    public Serializer getSerializer(Class clazz) throws HessianProtocolException {
        Serializer serializer = (Serializer)serializerMap.get(clazz);
        if (serializer != null) {
            return serializer;
        }
        if (HessianRemoteObject.class.isAssignableFrom(clazz)) {
            return new RemoteSerializer();
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return new MapSerializer();
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return new CollectionSerializer();
        }
        if (clazz.isArray()) {
            return new ArraySerializer();
        }
        if (Throwable.class.isAssignableFrom(clazz)) {
            return new ThrowableSerializer();
        }
        return this.getDefaultSerializer(clazz);
    }

    public Serializer getDefaultSerializer(Class clazz) {
        if (this._defaultSerializer != null) {
            return this._defaultSerializer;
        }
        return new JavaSerializer(clazz);
    }

    public Deserializer getDeserializer(Class clazz) throws HessianProtocolException {
        Deserializer deserializer = (Deserializer)deserializerMap.get(clazz);
        if (deserializer != null) {
            return deserializer;
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return new CollectionDeserializer(clazz);
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return new MapDeserializer(clazz);
        }
        if (clazz.isArray()) {
            return new ArrayDeserializer(this.getDeserializer(clazz.getComponentType()));
        }
        return new JavaDeserializer(clazz);
    }

    public Object readList(AbstractHessianInput abstractHessianInput, int n, String string) throws HessianProtocolException, IOException {
        Deserializer deserializer = this.getDeserializer(string);
        if (deserializer != null) {
            return deserializer.readList(abstractHessianInput, n);
        }
        return new CollectionDeserializer(ArrayList.class).readList(abstractHessianInput, n);
    }

    public Object readMap(AbstractHessianInput abstractHessianInput, String string) throws HessianProtocolException, IOException {
        Deserializer deserializer = this.getDeserializer(string);
        if (deserializer != null) {
            return deserializer.readMap(abstractHessianInput);
        }
        return new MapDeserializer(HashMap.class).readMap(abstractHessianInput);
    }

    public Deserializer getObjectDeserializer(String string) throws HessianProtocolException {
        Deserializer deserializer = this.getDeserializer(string);
        if (deserializer != null) {
            return deserializer;
        }
        return new MapDeserializer(HashMap.class);
    }

    public Deserializer getDeserializer(String string) throws HessianProtocolException {
        if (string == null || string.equals("")) {
            return null;
        }
        Deserializer deserializer = (Deserializer)typeMap.get(string);
        if (deserializer != null) {
            return deserializer;
        }
        if (string.startsWith("[")) {
            Deserializer deserializer2 = this.getDeserializer(string.substring(1));
            return new ArrayDeserializer(deserializer2);
        }
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = Class.forName(string, false, classLoader);
            return this.getDeserializer(clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void addBasic(Class clazz, String string, int n) {
        serializerMap.put(clazz, new BasicSerializer(n));
        BasicDeserializer basicDeserializer = new BasicDeserializer(n);
        deserializerMap.put(clazz, basicDeserializer);
        typeMap.put(string, basicDeserializer);
    }

    static {
        SerializerFactory.addBasic(Boolean.class, "boolean", 1);
        SerializerFactory.addBasic(Byte.class, "byte", 2);
        SerializerFactory.addBasic(Short.class, "short", 3);
        SerializerFactory.addBasic(Integer.class, "int", 4);
        SerializerFactory.addBasic(Long.class, "long", 5);
        SerializerFactory.addBasic(Float.class, "float", 6);
        SerializerFactory.addBasic(Double.class, "double", 7);
        SerializerFactory.addBasic(Character.class, "char", 8);
        SerializerFactory.addBasic(String.class, "string", 9);
        SerializerFactory.addBasic(java.util.Date.class, "date", 10);
        SerializerFactory.addBasic(Boolean.TYPE, "boolean", 1);
        SerializerFactory.addBasic(Byte.TYPE, "byte", 2);
        SerializerFactory.addBasic(Short.TYPE, "short", 3);
        SerializerFactory.addBasic(Integer.TYPE, "int", 4);
        SerializerFactory.addBasic(Long.TYPE, "long", 5);
        SerializerFactory.addBasic(Float.TYPE, "float", 6);
        SerializerFactory.addBasic(Double.TYPE, "double", 7);
        SerializerFactory.addBasic(Character.TYPE, "char", 8);
        SerializerFactory.addBasic([Z.class, "[boolean", 11);
        SerializerFactory.addBasic([B.class, "[byte", 12);
        SerializerFactory.addBasic([S.class, "[short", 13);
        SerializerFactory.addBasic([I.class, "[int", 14);
        SerializerFactory.addBasic([J.class, "[long", 15);
        SerializerFactory.addBasic([F.class, "[float", 16);
        SerializerFactory.addBasic([D.class, "[double", 17);
        SerializerFactory.addBasic([C.class, "[char", 18);
        SerializerFactory.addBasic(String;.class, "[string", 19);
        SerializerFactory.addBasic(Object;.class, "[object", 20);
        serializerMap.put(Class.class, new ClassSerializer());
        deserializerMap.put(Class.class, new ClassDeserializer());
        serializerMap.put(BigDecimal.class, new StringValueSerializer());
        try {
            deserializerMap.put(BigDecimal.class, new StringValueDeserializer(BigDecimal.class));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        serializerMap.put(Date.class, new SqlDateSerializer());
        serializerMap.put(Time.class, new SqlDateSerializer());
        serializerMap.put(Timestamp.class, new SqlDateSerializer());
        try {
            deserializerMap.put(Date.class, new SqlDateDeserializer(Date.class));
            deserializerMap.put(Time.class, new SqlDateDeserializer(Time.class));
            deserializerMap.put(Timestamp.class, new SqlDateDeserializer(Timestamp.class));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        try {
            Class<?> clazz = Class.forName("java.lang.StackTraceElement");
            deserializerMap.put(clazz, new StackTraceElementDeserializer());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

