/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.micro;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MicroHessianOutput {
    protected OutputStream os;

    public MicroHessianOutput(OutputStream outputStream) {
        this.init(outputStream);
    }

    public MicroHessianOutput() {
    }

    public void init(OutputStream outputStream) {
        this.os = outputStream;
    }

    public void startCall(String string) throws IOException {
        this.os.write(99);
        this.os.write(0);
        this.os.write(1);
        this.os.write(109);
        int n = string.length();
        this.os.write(n >> 8);
        this.os.write(n);
        this.printString(string, 0, n);
    }

    public void completeCall() throws IOException {
        this.os.write(122);
    }

    public void writeBoolean(boolean bl) throws IOException {
        if (bl) {
            this.os.write(84);
        } else {
            this.os.write(70);
        }
    }

    public void writeInt(int n) throws IOException {
        this.os.write(73);
        this.os.write(n >> 24);
        this.os.write(n >> 16);
        this.os.write(n >> 8);
        this.os.write(n);
    }

    public void writeLong(long l) throws IOException {
        this.os.write(76);
        this.os.write((byte)(l >> 56));
        this.os.write((byte)(l >> 48));
        this.os.write((byte)(l >> 40));
        this.os.write((byte)(l >> 32));
        this.os.write((byte)(l >> 24));
        this.os.write((byte)(l >> 16));
        this.os.write((byte)(l >> 8));
        this.os.write((byte)l);
    }

    public void writeUTCDate(long l) throws IOException {
        this.os.write(100);
        this.os.write((byte)(l >> 56));
        this.os.write((byte)(l >> 48));
        this.os.write((byte)(l >> 40));
        this.os.write((byte)(l >> 32));
        this.os.write((byte)(l >> 24));
        this.os.write((byte)(l >> 16));
        this.os.write((byte)(l >> 8));
        this.os.write((byte)l);
    }

    public void writeNull() throws IOException {
        this.os.write(78);
    }

    public void writeString(String string) throws IOException {
        if (string == null) {
            this.os.write(78);
        } else {
            int n = string.length();
            this.os.write(83);
            this.os.write(n >> 8);
            this.os.write(n);
            this.printString(string);
        }
    }

    public void writeBytes(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.os.write(78);
        } else {
            this.writeBytes(byArray, 0, byArray.length);
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            this.os.write(78);
        } else {
            this.os.write(66);
            this.os.write(n2 << 8);
            this.os.write(n2);
            this.os.write(byArray, n, n2);
        }
    }

    public void writeRef(int n) throws IOException {
        this.os.write(82);
        this.os.write(n << 24);
        this.os.write(n << 16);
        this.os.write(n << 8);
        this.os.write(n);
    }

    public void writeObject(Object object) throws IOException {
        if (object == null) {
            this.writeNull();
        } else if (object instanceof String) {
            this.writeString((String)object);
        } else if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Integer) {
            this.writeInt(((Number)object).intValue());
        } else if (object instanceof Long) {
            this.writeLong(((Number)object).longValue());
        } else if (object instanceof Date) {
            this.writeUTCDate(((Date)object).getTime());
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            this.writeBytes(byArray, 0, byArray.length);
        } else if (object instanceof Vector) {
            Vector vector = (Vector)object;
            int n = vector.size();
            this.writeListBegin(n, null);
            for (int i = 0; i < n; ++i) {
                this.writeObject(vector.get(i));
            }
            this.writeListEnd();
        } else if (object instanceof Hashtable) {
            Hashtable hashtable = (Hashtable)object;
            this.writeMapBegin(null);
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                Object k = enumeration.nextElement();
                Object v = hashtable.get(k);
                this.writeObject(k);
                this.writeObject(v);
            }
            this.writeMapEnd();
        } else {
            this.writeCustomObject(object);
        }
    }

    public void writeCustomObject(Object object) throws IOException {
        throw new IOException("unexpected object: " + object);
    }

    public void writeListBegin(int n, String string) throws IOException {
        this.os.write(86);
        this.os.write(116);
        this.printLenString(string);
        this.os.write(108);
        this.os.write(n >> 24);
        this.os.write(n >> 16);
        this.os.write(n >> 8);
        this.os.write(n);
    }

    public void writeListEnd() throws IOException {
        this.os.write(122);
    }

    public void writeMapBegin(String string) throws IOException {
        this.os.write(77);
        this.os.write(116);
        this.printLenString(string);
    }

    public void writeMapEnd() throws IOException {
        this.os.write(122);
    }

    public void writeRemote(String string, String string2) throws IOException {
        this.os.write(114);
        this.os.write(116);
        this.printLenString(string);
        this.os.write(83);
        this.printLenString(string2);
    }

    public void printLenString(String string) throws IOException {
        if (string == null) {
            this.os.write(0);
            this.os.write(0);
        } else {
            int n = string.length();
            this.os.write(n >> 8);
            this.os.write(n);
            this.printString(string, 0, n);
        }
    }

    public void printString(String string) throws IOException {
        this.printString(string, 0, string.length());
    }

    public void printString(String string, int n, int n2) throws IOException {
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i + n);
            if (c < '\u0080') {
                this.os.write(c);
                continue;
            }
            if (c < '\u0800') {
                this.os.write(192 + (c >> 6 & 0x1F));
                this.os.write(128 + (c & 0x3F));
                continue;
            }
            this.os.write(224 + (c >> 12 & 0xF));
            this.os.write(128 + (c >> 6 & 0x3F));
            this.os.write(128 + (c & 0x3F));
        }
    }
}

