/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.mux;

import com.caucho.hessian.mux.MuxServer;
import java.io.IOException;
import java.io.InputStream;

public class MuxInputStream
extends InputStream {
    private MuxServer server;
    protected InputStream is;
    private int channel;
    private String url;
    private int chunkLength;

    protected void init(MuxServer muxServer, int n) throws IOException {
        this.server = muxServer;
        this.channel = n;
        this.url = null;
        this.chunkLength = 0;
    }

    protected InputStream getInputStream() throws IOException {
        if (this.is == null && this.server != null) {
            this.is = this.server.readChannel(this.channel);
        }
        return this.is;
    }

    void setInputStream(InputStream inputStream) {
        this.is = inputStream;
    }

    public int getChannel() {
        return this.channel;
    }

    public String getURL() {
        return this.url;
    }

    public int read() throws IOException {
        if (this.chunkLength <= 0) {
            this.readToData(false);
            if (this.chunkLength <= 0) {
                return -1;
            }
        }
        --this.chunkLength;
        return this.is.read();
    }

    public void close() throws IOException {
        this.skipToEnd();
    }

    private void skipToEnd() throws IOException {
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            return;
        }
        if (this.chunkLength > 0) {
            inputStream.skip(this.chunkLength);
        }
        int n = inputStream.read();
        while (n >= 0) {
            switch (n) {
                case 89: {
                    this.server.freeReadLock();
                    this.is = inputStream = this.server.readChannel(this.channel);
                    if (inputStream != null) break;
                    this.server = null;
                    return;
                }
                case 81: {
                    this.server.freeReadLock();
                    this.is = null;
                    this.server = null;
                    return;
                }
                case -1: {
                    this.server.freeReadLock();
                    this.is = null;
                    this.server = null;
                    return;
                }
                default: {
                    int n2 = (inputStream.read() << 8) + inputStream.read();
                    inputStream.skip(n2);
                }
            }
            n = inputStream.read();
        }
    }

    void readToData(boolean bl) throws IOException {
        InputStream inputStream = this.getInputStream();
        if (inputStream == null) {
            return;
        }
        int n = inputStream.read();
        while (n >= 0) {
            switch (n) {
                case 89: {
                    this.server.freeReadLock();
                    if (bl) {
                        return;
                    }
                    this.server.readChannel(this.channel);
                    break;
                }
                case 81: {
                    this.server.freeReadLock();
                    this.is = null;
                    this.server = null;
                    return;
                }
                case 85: {
                    this.url = this.readUTF();
                    break;
                }
                case 68: {
                    this.chunkLength = (inputStream.read() << 8) + inputStream.read();
                    return;
                }
                default: {
                    this.readTag(n);
                }
            }
            n = inputStream.read();
        }
    }

    protected void readTag(int n) throws IOException {
        int n2 = (this.is.read() << 8) + this.is.read();
        this.is.skip(n2);
    }

    protected String readUTF() throws IOException {
        int n = (this.is.read() << 8) + this.is.read();
        StringBuffer stringBuffer = new StringBuffer();
        while (n > 0) {
            int n2 = this.is.read();
            if (n2 < 0) {
                return stringBuffer.toString();
            }
            if (n2 < 128) {
                --n;
                stringBuffer.append((char)n2);
                continue;
            }
            if ((n2 & 0xE0) == 192) {
                n -= 2;
                stringBuffer.append(((n2 & 0x1F) << 6) + (this.is.read() & 0x3F));
                continue;
            }
            if ((n2 & 0xF0) == 224) {
                n -= 3;
                stringBuffer.append(((n2 & 0xF) << 12) + ((this.is.read() & 0x3F) << 6) + (this.is.read() & 0x3F));
                continue;
            }
            throw new IOException("utf-8 encoding error");
        }
        return stringBuffer.toString();
    }
}

