/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.mux;

import com.caucho.hessian.mux.MuxServer;
import java.io.IOException;
import java.io.OutputStream;

public class MuxOutputStream
extends OutputStream {
    private MuxServer server;
    private int channel;
    private OutputStream os;

    protected void init(MuxServer muxServer, int n) throws IOException {
        this.server = muxServer;
        this.channel = n;
        this.os = null;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (this.os == null && this.server != null) {
            this.os = this.server.writeChannel(this.channel);
        }
        return this.os;
    }

    public int getChannel() {
        return this.channel;
    }

    public void writeURL(String string) throws IOException {
        this.writeUTF(85, string);
    }

    public void write(int n) throws IOException {
        OutputStream outputStream = this.getOutputStream();
        outputStream.write(68);
        outputStream.write(0);
        outputStream.write(1);
        outputStream.write(n);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        OutputStream outputStream = this.getOutputStream();
        while (n2 > 32768) {
            outputStream.write(68);
            outputStream.write(128);
            outputStream.write(0);
            outputStream.write(byArray, n, 32768);
            n += 32768;
            n2 -= 32768;
        }
        outputStream.write(68);
        outputStream.write(n2 >> 8);
        outputStream.write(n2);
        outputStream.write(byArray, n, n2);
    }

    public void yield() throws IOException {
        OutputStream outputStream = this.os;
        this.os = null;
        if (outputStream != null) {
            this.server.yield(this.channel);
        }
    }

    public void flush() throws IOException {
        OutputStream outputStream = this.os;
        this.os = null;
        if (outputStream != null) {
            this.server.flush(this.channel);
        }
    }

    public void close() throws IOException {
        if (this.server != null) {
            OutputStream outputStream = this.getOutputStream();
            this.os = null;
            MuxServer muxServer = this.server;
            this.server = null;
            muxServer.close(this.channel);
        }
    }

    protected void writeUTF(int n, String string) throws IOException {
        char c;
        int n2;
        OutputStream outputStream = this.getOutputStream();
        outputStream.write(n);
        int n3 = string.length();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            c = string.charAt(n2);
            if (c < '\u0080') {
                ++n4;
                continue;
            }
            if (c < '\u0800') {
                n4 += 2;
                continue;
            }
            n4 += 3;
        }
        outputStream.write(n4 >> 8);
        outputStream.write(n4);
        for (n2 = 0; n2 < n4; ++n2) {
            c = string.charAt(n2);
            if (c < '\u0080') {
                outputStream.write(c);
                continue;
            }
            if (c < '\u0800') {
                outputStream.write(192 + (c >> 6) & 0x1F);
                outputStream.write(128 + (c & 0x3F));
                continue;
            }
            outputStream.write(224 + (c >> 12) & 0xF);
            outputStream.write(128 + (c >> 6 & 0x3F));
            outputStream.write(128 + (c & 0x3F));
        }
    }
}

