/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.server;

import com.caucho.hessian.io.HessianInput;
import com.caucho.hessian.io.HessianOutput;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class HessianSkeleton {
    private HashMap _methodMap = new HashMap();
    private Object _service;

    public HessianSkeleton(Object object) {
        this._service = object;
        Method[] methodArray = object.getClass().getMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            Method method = methodArray[i];
            if (this._methodMap.get(method.getName()) == null) {
                this._methodMap.put(method.getName(), methodArray[i]);
            }
            Class<?>[] classArray = method.getParameterTypes();
            String string = method.getName() + "__" + classArray.length;
            this._methodMap.put(string, methodArray[i]);
            this._methodMap.put(this.mangleName(method, false), methodArray[i]);
        }
    }

    protected String mangleName(Method method, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(method.getName());
        Class<?>[] classArray = method.getParameterTypes();
        for (int i = 0; i < classArray.length; ++i) {
            stringBuffer.append('_');
            this.mangleClass(stringBuffer, classArray[i], bl);
        }
        return stringBuffer.toString();
    }

    private void mangleClass(StringBuffer stringBuffer, Class clazz, boolean bl) {
        String string = clazz.getName();
        if (string.equals("boolean")) {
            stringBuffer.append("boolean");
        } else if (string.equals("int") || string.equals("short") || string.equals("byte")) {
            stringBuffer.append("int");
        } else if (string.equals("long")) {
            stringBuffer.append("long");
        } else if (string.equals("double") || string.equals("float")) {
            stringBuffer.append("double");
        } else if (string.equals("java.lang.String") || string.equals("com.caucho.util.CharBuffer") || string.equals("char") || string.equals("java.io.Reader")) {
            stringBuffer.append("string");
        } else if (string.equals("java.util.Date") || string.equals("com.caucho.util.QDate")) {
            stringBuffer.append("date");
        } else if (InputStream.class.isAssignableFrom(clazz) || string.equals("[B")) {
            stringBuffer.append("binary");
        } else if (clazz.isArray()) {
            stringBuffer.append("array_");
            this.mangleClass(stringBuffer, clazz.getComponentType(), bl);
        } else if (string.equals("org.w3c.dom.Node") || string.equals("org.w3c.dom.Element") || string.equals("org.w3c.dom.Document")) {
            stringBuffer.append("xml");
        } else if (bl) {
            stringBuffer.append(string);
        } else {
            int n = string.lastIndexOf(46);
            if (n > 0) {
                stringBuffer.append(string.substring(n + 1));
            } else {
                stringBuffer.append(string);
            }
        }
    }

    public void invoke(HessianInput hessianInput, HessianOutput hessianOutput) throws Throwable {
        hessianInput.startCall();
        Method method = (Method)this._methodMap.get(hessianInput.getMethod());
        if (method == null) {
            throw new IOException("No server method matching:" + hessianInput.getMethod());
        }
        Class<?>[] classArray = method.getParameterTypes();
        Object[] objectArray = new Object[classArray.length];
        for (int i = 0; i < classArray.length; ++i) {
            objectArray[i] = hessianInput.readObject(classArray[i]);
        }
        hessianInput.completeCall();
        Object object = null;
        try {
            object = method.invoke(this._service, objectArray);
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (throwable instanceof InvocationTargetException) {
                throwable2 = ((InvocationTargetException)throwable).getTargetException();
            }
            hessianOutput.startReply();
            hessianOutput.writeFault("ServiceException", throwable2.getMessage(), throwable2);
            hessianOutput.completeReply();
            return;
        }
        hessianOutput.startReply();
        hessianOutput.writeObject(object);
        hessianOutput.completeReply();
    }
}

