/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.resolver;

import io.airlift.resolver.ArtifactResolver;
import io.airlift.resolver.DefaultArtifact;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.sonatype.aether.artifact.Artifact;

public class Main {
    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.println("java -cp ...  " + Main.class.getName() + " GAV_OR_POM");
            System.exit(1);
        }
        String localRepo = System.getProperty("maven.repo.local", ArtifactResolver.USER_LOCAL_REPO);
        String remoteReposString = System.getProperty("maven.repo.remote", "http://repo1.maven.org/maven2/");
        ArrayList<String> remoteRepos = new ArrayList<String>();
        for (String repo : remoteReposString.split(",")) {
            remoteRepos.add(repo.trim());
        }
        ArtifactResolver artifactResolver = new ArtifactResolver(localRepo, remoteRepos);
        File pomFile = new File(args[0]);
        List<Artifact> artifacts = pomFile.canRead() ? artifactResolver.resolvePom(pomFile) : artifactResolver.resolveArtifacts(new DefaultArtifact(args[0]));
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() == null) continue;
            System.out.println("Resolved " + artifact + " to " + artifact.getFile());
        }
        for (Artifact artifact : artifacts) {
            if (artifact.getFile() != null) continue;
            System.out.println("Could not resolved " + artifact);
        }
    }
}

