package io.fabric8.kubernetes.api.model.apiextensions.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class WebhookConversionFluentImpl<A extends WebhookConversionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements WebhookConversionFluent<A> {

    private WebhookClientConfigBuilder clientConfig;
    private List<String> conversionReviewVersions = new ArrayList<String>();

    public WebhookConversionFluentImpl() {
    }

    public WebhookConversionFluentImpl(WebhookConversion instance) {
        this.withClientConfig(instance.getClientConfig()); 
        this.withConversionReviewVersions(instance.getConversionReviewVersions()); 
    }

    
/**
 * This method has been deprecated, please use method buildClientConfig instead.
 * @return The buildable object.
 */
@Deprecated public WebhookClientConfig getClientConfig() {
        return this.clientConfig!=null?this.clientConfig.build():null;
    }

    public WebhookClientConfig buildClientConfig() {
        return this.clientConfig!=null?this.clientConfig.build():null;
    }

    public A withClientConfig(WebhookClientConfig clientConfig) {
        _visitables.get("clientConfig").remove(this.clientConfig);
        if (clientConfig!=null){ this.clientConfig= new WebhookClientConfigBuilder(clientConfig); _visitables.get("clientConfig").add(this.clientConfig);} return (A) this;
    }

    public Boolean hasClientConfig() {
        return this.clientConfig != null;
    }

    public WebhookConversionFluent.ClientConfigNested<A> withNewClientConfig() {
        return new ClientConfigNestedImpl();
    }

    public WebhookConversionFluent.ClientConfigNested<A> withNewClientConfigLike(WebhookClientConfig item) {
        return new ClientConfigNestedImpl(item);
    }

    public WebhookConversionFluent.ClientConfigNested<A> editClientConfig() {
        return withNewClientConfigLike(getClientConfig());
    }

    public WebhookConversionFluent.ClientConfigNested<A> editOrNewClientConfig() {
        return withNewClientConfigLike(getClientConfig() != null ? getClientConfig(): new WebhookClientConfigBuilder().build());
    }

    public WebhookConversionFluent.ClientConfigNested<A> editOrNewClientConfigLike(WebhookClientConfig item) {
        return withNewClientConfigLike(getClientConfig() != null ? getClientConfig(): item);
    }

    public A addToConversionReviewVersions(int index,String item) {
        if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
        this.conversionReviewVersions.add(index, item);
        return (A)this;
    }

    public A setToConversionReviewVersions(int index,String item) {
        if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
        this.conversionReviewVersions.set(index, item); return (A)this;
    }

    public A addToConversionReviewVersions(String... items) {
        if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
        for (String item : items) {this.conversionReviewVersions.add(item);} return (A)this;
    }

    public A addAllToConversionReviewVersions(Collection<String> items) {
        if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
        for (String item : items) {this.conversionReviewVersions.add(item);} return (A)this;
    }

    public A removeFromConversionReviewVersions(String... items) {
        for (String item : items) {if (this.conversionReviewVersions!= null){ this.conversionReviewVersions.remove(item);}} return (A)this;
    }

    public A removeAllFromConversionReviewVersions(Collection<String> items) {
        for (String item : items) {if (this.conversionReviewVersions!= null){ this.conversionReviewVersions.remove(item);}} return (A)this;
    }

    public List<String> getConversionReviewVersions() {
        return this.conversionReviewVersions;
    }

    public String getConversionReviewVersion(int index) {
        return this.conversionReviewVersions.get(index);
    }

    public String getFirstConversionReviewVersion() {
        return this.conversionReviewVersions.get(0);
    }

    public String getLastConversionReviewVersion() {
        return this.conversionReviewVersions.get(conversionReviewVersions.size() - 1);
    }

    public String getMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item: conversionReviewVersions) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingConversionReviewVersion(Predicate<String> predicate) {
        for (String item: conversionReviewVersions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConversionReviewVersions(List<String> conversionReviewVersions) {
        if (this.conversionReviewVersions != null) { _visitables.get("conversionReviewVersions").removeAll(this.conversionReviewVersions);}
        if (conversionReviewVersions != null) {this.conversionReviewVersions = new ArrayList<String>(); for (String item : conversionReviewVersions){this.addToConversionReviewVersions(item);}} else { this.conversionReviewVersions = null;} return (A) this;
    }

    public A withConversionReviewVersions(String... conversionReviewVersions) {
        if (this.conversionReviewVersions != null) {this.conversionReviewVersions.clear();}
        if (conversionReviewVersions != null) {for (String item :conversionReviewVersions){ this.addToConversionReviewVersions(item);}} return (A) this;
    }

    public Boolean hasConversionReviewVersions() {
        return conversionReviewVersions != null && !conversionReviewVersions.isEmpty();
    }

    public A addNewConversionReviewVersion(StringBuilder arg1) {
        return (A)addToConversionReviewVersions(new String(arg1));
    }

    public A addNewConversionReviewVersion(int[] arg1,int arg2,int arg3) {
        return (A)addToConversionReviewVersions(new String(arg1, arg2, arg3));
    }

    public A addNewConversionReviewVersion(char[] arg1) {
        return (A)addToConversionReviewVersions(new String(arg1));
    }

    public A addNewConversionReviewVersion(StringBuffer arg1) {
        return (A)addToConversionReviewVersions(new String(arg1));
    }

    public A addNewConversionReviewVersion(byte[] arg1,int arg2) {
        return (A)addToConversionReviewVersions(new String(arg1, arg2));
    }

    public A addNewConversionReviewVersion(byte[] arg1) {
        return (A)addToConversionReviewVersions(new String(arg1));
    }

    public A addNewConversionReviewVersion(char[] arg1,int arg2,int arg3) {
        return (A)addToConversionReviewVersions(new String(arg1, arg2, arg3));
    }

    public A addNewConversionReviewVersion(byte[] arg1,int arg2,int arg3) {
        return (A)addToConversionReviewVersions(new String(arg1, arg2, arg3));
    }

    public A addNewConversionReviewVersion(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)addToConversionReviewVersions(new String(arg1, arg2, arg3, arg4));
    }

    public A addNewConversionReviewVersion(String arg1) {
        return (A)addToConversionReviewVersions(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        WebhookConversionFluentImpl that = (WebhookConversionFluentImpl) o;
        if (clientConfig != null ? !clientConfig.equals(that.clientConfig) :that.clientConfig != null) return false;
        if (conversionReviewVersions != null ? !conversionReviewVersions.equals(that.conversionReviewVersions) :that.conversionReviewVersions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(clientConfig,  conversionReviewVersions,  super.hashCode());
    }

    public class ClientConfigNestedImpl<N> extends WebhookClientConfigFluentImpl<WebhookConversionFluent.ClientConfigNested<N>> implements WebhookConversionFluent.ClientConfigNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final WebhookClientConfigBuilder builder;

            ClientConfigNestedImpl(WebhookClientConfig item) {
                this.builder = new WebhookClientConfigBuilder(this, item);
                        
            }

            ClientConfigNestedImpl() {
                this.builder = new WebhookClientConfigBuilder(this);
                        
            }

            public N and() {
                return (N) WebhookConversionFluentImpl.this.withClientConfig(builder.build());
            }

            public N endClientConfig() {
                return and();
            }
    }


}
