package io.fabric8.kubernetes.api.model.apiextensions.v1;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class CustomResourceConversionFluentImpl<A extends CustomResourceConversionFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CustomResourceConversionFluent<A> {

    private String strategy;
    private WebhookConversionBuilder webhook;

    public CustomResourceConversionFluentImpl() {
    }

    public CustomResourceConversionFluentImpl(CustomResourceConversion instance) {
        this.withStrategy(instance.getStrategy()); 
        this.withWebhook(instance.getWebhook()); 
    }

    public String getStrategy() {
        return this.strategy;
    }

    public A withStrategy(String strategy) {
        this.strategy=strategy; return (A) this;
    }

    public Boolean hasStrategy() {
        return this.strategy != null;
    }

    public A withNewStrategy(StringBuilder arg1) {
        return (A)withStrategy(new String(arg1));
    }

    public A withNewStrategy(int[] arg1,int arg2,int arg3) {
        return (A)withStrategy(new String(arg1, arg2, arg3));
    }

    public A withNewStrategy(char[] arg1) {
        return (A)withStrategy(new String(arg1));
    }

    public A withNewStrategy(StringBuffer arg1) {
        return (A)withStrategy(new String(arg1));
    }

    public A withNewStrategy(byte[] arg1,int arg2) {
        return (A)withStrategy(new String(arg1, arg2));
    }

    public A withNewStrategy(byte[] arg1) {
        return (A)withStrategy(new String(arg1));
    }

    public A withNewStrategy(char[] arg1,int arg2,int arg3) {
        return (A)withStrategy(new String(arg1, arg2, arg3));
    }

    public A withNewStrategy(byte[] arg1,int arg2,int arg3) {
        return (A)withStrategy(new String(arg1, arg2, arg3));
    }

    public A withNewStrategy(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withStrategy(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewStrategy(String arg1) {
        return (A)withStrategy(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildWebhook instead.
 * @return The buildable object.
 */
@Deprecated public WebhookConversion getWebhook() {
        return this.webhook!=null?this.webhook.build():null;
    }

    public WebhookConversion buildWebhook() {
        return this.webhook!=null?this.webhook.build():null;
    }

    public A withWebhook(WebhookConversion webhook) {
        _visitables.get("webhook").remove(this.webhook);
        if (webhook!=null){ this.webhook= new WebhookConversionBuilder(webhook); _visitables.get("webhook").add(this.webhook);} return (A) this;
    }

    public Boolean hasWebhook() {
        return this.webhook != null;
    }

    public CustomResourceConversionFluent.WebhookNested<A> withNewWebhook() {
        return new WebhookNestedImpl();
    }

    public CustomResourceConversionFluent.WebhookNested<A> withNewWebhookLike(WebhookConversion item) {
        return new WebhookNestedImpl(item);
    }

    public CustomResourceConversionFluent.WebhookNested<A> editWebhook() {
        return withNewWebhookLike(getWebhook());
    }

    public CustomResourceConversionFluent.WebhookNested<A> editOrNewWebhook() {
        return withNewWebhookLike(getWebhook() != null ? getWebhook(): new WebhookConversionBuilder().build());
    }

    public CustomResourceConversionFluent.WebhookNested<A> editOrNewWebhookLike(WebhookConversion item) {
        return withNewWebhookLike(getWebhook() != null ? getWebhook(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CustomResourceConversionFluentImpl that = (CustomResourceConversionFluentImpl) o;
        if (strategy != null ? !strategy.equals(that.strategy) :that.strategy != null) return false;
        if (webhook != null ? !webhook.equals(that.webhook) :that.webhook != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(strategy,  webhook,  super.hashCode());
    }

    public class WebhookNestedImpl<N> extends WebhookConversionFluentImpl<CustomResourceConversionFluent.WebhookNested<N>> implements CustomResourceConversionFluent.WebhookNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final WebhookConversionBuilder builder;

            WebhookNestedImpl(WebhookConversion item) {
                this.builder = new WebhookConversionBuilder(this, item);
                        
            }

            WebhookNestedImpl() {
                this.builder = new WebhookConversionBuilder(this);
                        
            }

            public N and() {
                return (N) CustomResourceConversionFluentImpl.this.withWebhook(builder.build());
            }

            public N endWebhook() {
                return and();
            }
    }


}
