/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.rendering;

import io.javalin.rendering.FileRenderer;
import io.javalin.rendering.markdown.JavalinCommonmark;
import io.javalin.rendering.template.JavalinFreemarker;
import io.javalin.rendering.template.JavalinJtwig;
import io.javalin.rendering.template.JavalinMustache;
import io.javalin.rendering.template.JavalinPebble;
import io.javalin.rendering.template.JavalinThymeleaf;
import io.javalin.rendering.template.JavalinVelocity;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0012\u0010\u0016\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u0017\"\u00020\u0005H\u0007\u00a2\u0006\u0002\u0010\u0018J$\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u00052\u0014\u0010\u001b\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001cR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\n\u001a\u00020\u0005*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00020\u0005*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0018\u0010\u000f\u001a\u00020\u0010*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lio/javalin/rendering/JavalinRenderer;", "", "()V", "extensions", "", "", "Lio/javalin/rendering/FileRenderer;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "doubleExtension", "getDoubleExtension", "(Ljava/lang/String;)Ljava/lang/String;", "extension", "getExtension", "hasTwoDots", "", "getHasTwoDots", "(Ljava/lang/String;)Z", "register", "", "fileRenderer", "ext", "", "(Lio/javalin/rendering/FileRenderer;[Ljava/lang/String;)V", "renderBasedOnExtension", "filePath", "model", "", "javalin"})
public final class JavalinRenderer {
    private static final Logger log;
    private static final Map<String, FileRenderer> extensions;
    public static final JavalinRenderer INSTANCE;

    @NotNull
    public final String renderBasedOnExtension(@NotNull String filePath, @NotNull Map<String, ? extends Object> model) {
        Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
        Intrinsics.checkParameterIsNotNull(model, (String)"model");
        String extension = this.getHasTwoDots(filePath) ? this.getDoubleExtension(filePath) : this.getExtension(filePath);
        FileRenderer fileRenderer = extensions.get(extension);
        if (fileRenderer == null) {
            fileRenderer = extensions.get(this.getExtension(filePath));
        }
        if (fileRenderer == null) {
            throw (Throwable)new IllegalArgumentException("No Renderer registered for extension '" + this.getExtension(filePath) + "'.");
        }
        FileRenderer renderer = fileRenderer;
        String string = renderer.render(filePath, model);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"renderer.render(filePath, model)");
        return string;
    }

    @JvmStatic
    public static final void register(@NotNull FileRenderer fileRenderer, String ... ext) {
        Intrinsics.checkParameterIsNotNull((Object)fileRenderer, (String)"fileRenderer");
        Intrinsics.checkParameterIsNotNull((Object)ext, (String)"ext");
        for (String element$iv : ext) {
            String it = element$iv;
            if (extensions.get(it) != null) {
                StringBuilder stringBuilder = new StringBuilder().append('\'').append(it).append("' is already registered to ");
                FileRenderer fileRenderer2 = extensions.get(it);
                if (fileRenderer2 == null) {
                    Intrinsics.throwNpe();
                }
                log.info(stringBuilder.append(fileRenderer2.getClass()).append(". Overriding.").toString());
            }
            Map<String, FileRenderer> map = extensions;
            FileRenderer fileRenderer3 = fileRenderer;
            map.put(it, fileRenderer3);
        }
    }

    private final String getExtension(@NotNull String $receiver) {
        return StringsKt.replaceBeforeLast$default((String)$receiver, (String)".", (String)"", null, (int)4, null);
    }

    private final String getDoubleExtension(@NotNull String $receiver) {
        return this.getExtension(StringsKt.substringBeforeLast((String)$receiver, (String)".", (String)"")) + this.getExtension($receiver);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean getHasTwoDots(@NotNull String $receiver) {
        void var3_3;
        CharSequence $receiver$iv = $receiver;
        int count$iv = 0;
        CharSequence charSequence = $receiver$iv;
        for (int i = 0; i < charSequence.length(); ++i) {
            char element$iv = charSequence.charAt(i);
            char it = element$iv;
            if (!(it == '.')) continue;
            ++count$iv;
        }
        return var3_3 > true;
    }

    private JavalinRenderer() {
    }

    static {
        JavalinRenderer javalinRenderer;
        INSTANCE = javalinRenderer = new JavalinRenderer();
        log = LoggerFactory.getLogger(INSTANCE.getClass());
        extensions = new LinkedHashMap();
        JavalinRenderer.register(JavalinVelocity.INSTANCE, ".vm", ".vtl");
        JavalinRenderer.register(JavalinFreemarker.INSTANCE, ".ftl");
        JavalinRenderer.register(JavalinMustache.INSTANCE, ".mustache");
        JavalinRenderer.register(JavalinJtwig.INSTANCE, ".jtwig", ".twig", ".html.twig");
        JavalinRenderer.register(JavalinPebble.INSTANCE, ".peb", ".pebble");
        JavalinRenderer.register(JavalinThymeleaf.INSTANCE, ".html", ".tl", ".thyme", ".thymeleaf");
        JavalinRenderer.register(JavalinCommonmark.INSTANCE, ".md", ".markdown");
    }
}

