/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.websocket;

import io.javalin.core.util.ContextUtil;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.websocket.api.CloseStatus;
import org.eclipse.jetty.websocket.api.RemoteEndpoint;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.SuspendToken;
import org.eclipse.jetty.websocket.api.UpgradeRequest;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u001f\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0010\"\u00020\u0003\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0013H\u0016J\u0013\u0010\u001a\u001a\u00020\u000e2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0096\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\u0003H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020 H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\u0015H\u0016J\u0010\u0010,\u001a\u0004\u0018\u00010\u00032\u0006\u0010,\u001a\u00020\u0003J\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006J\b\u0010.\u001a\u0004\u0018\u00010\u0003J\b\u0010/\u001a\u00020\u000eH\u0016J\b\u00100\u001a\u00020\u000eH\u0016J'\u00101\u001a\n\u0012\u0004\u0012\u00020\u0003\u0018\u0001022\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0010\"\u00020\u0003\u00a2\u0006\u0002\u00103J\u0006\u0010\u0007\u001a\u00020\u0003J\u000e\u00104\u001a\u00020\u00032\u0006\u00104\u001a\u00020\u0003J\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006J\u001e\u00105\u001a\u0004\u0018\u00010\u00032\u0006\u00105\u001a\u00020\u00032\n\b\u0002\u00106\u001a\u0004\u0018\u00010\u0003H\u0007J\u0018\u00107\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u0003020\u0006J\u0014\u00108\u001a\b\u0012\u0004\u0012\u00020\u0003022\u0006\u00105\u001a\u00020\u0003J\b\u00109\u001a\u0004\u0018\u00010\u0003J\u000e\u0010:\u001a\u00020\u00132\u0006\u0010;\u001a\u00020<J\u000e\u0010:\u001a\u00020\u00132\u0006\u0010;\u001a\u00020\u0003J\u0010\u0010=\u001a\u00020\u00132\u0006\u0010>\u001a\u00020\u001eH\u0016J\b\u0010?\u001a\u00020@H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lio/javalin/websocket/WsSession;", "Lorg/eclipse/jetty/websocket/api/Session;", "id", "", "session", "pathParamMap", "", "matchedPath", "(Ljava/lang/String;Lorg/eclipse/jetty/websocket/api/Session;Ljava/util/Map;Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "webSocketSession", "Lorg/eclipse/jetty/websocket/common/WebSocketSession;", "anyQueryParamNull", "", "keys", "", "([Ljava/lang/String;)Z", "close", "", "statusCode", "", "reason", "closeStatus", "Lorg/eclipse/jetty/websocket/api/CloseStatus;", "disconnect", "equals", "other", "", "getIdleTimeout", "", "getLocalAddress", "Ljava/net/InetSocketAddress;", "getPolicy", "Lorg/eclipse/jetty/websocket/api/WebSocketPolicy;", "getProtocolVersion", "getRemote", "Lorg/eclipse/jetty/websocket/api/RemoteEndpoint;", "getRemoteAddress", "getUpgradeRequest", "Lorg/eclipse/jetty/websocket/api/UpgradeRequest;", "getUpgradeResponse", "Lorg/eclipse/jetty/websocket/api/UpgradeResponse;", "hashCode", "header", "headerMap", "host", "isOpen", "isSecure", "mapQueryParams", "", "([Ljava/lang/String;)Ljava/util/List;", "pathParam", "queryParam", "default", "queryParamMap", "queryParams", "queryString", "send", "message", "Ljava/nio/ByteBuffer;", "setIdleTimeout", "ms", "suspend", "Lorg/eclipse/jetty/websocket/api/SuspendToken;", "javalin"})
public final class WsSession
implements Session {
    private final WebSocketSession webSocketSession;
    @NotNull
    private final String id;
    private Map<String, String> pathParamMap;
    private final String matchedPath;

    public final void send(@NotNull String message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.webSocketSession.getRemote().sendString(message);
    }

    public final void send(@NotNull ByteBuffer message) {
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        this.webSocketSession.getRemote().sendBytes(message);
    }

    @Nullable
    public final String queryString() {
        UpgradeRequest upgradeRequest = this.webSocketSession.getUpgradeRequest();
        if (upgradeRequest == null) {
            Intrinsics.throwNpe();
        }
        return upgradeRequest.getQueryString();
    }

    @JvmOverloads
    @Nullable
    public final String queryParam(@NotNull String queryParam, @Nullable String string) {
        Intrinsics.checkParameterIsNotNull((Object)queryParam, (String)"queryParam");
        String string2 = (String)CollectionsKt.firstOrNull(this.queryParams(queryParam));
        if (string2 == null) {
            string2 = string;
        }
        return string2;
    }

    @JvmOverloads
    @Nullable
    public static /* bridge */ /* synthetic */ String queryParam$default(WsSession wsSession, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return wsSession.queryParam(string, string2);
    }

    @JvmOverloads
    @Nullable
    public final String queryParam(@NotNull String queryParam) {
        return WsSession.queryParam$default(this, queryParam, null, 2, null);
    }

    @NotNull
    public final List<String> queryParams(@NotNull String queryParam) {
        Intrinsics.checkParameterIsNotNull((Object)queryParam, (String)"queryParam");
        List list = this.queryParamMap().get(queryParam);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Map<String, List<String>> queryParamMap() {
        String string = this.queryString();
        if (string == null) {
            string = "";
        }
        return ContextUtil.INSTANCE.splitKeyValueStringAndGroupByKey(string);
    }

    @Nullable
    public final List<String> mapQueryParams(String ... keys) {
        Intrinsics.checkParameterIsNotNull((Object)keys, (String)"keys");
        return ContextUtil.INSTANCE.mapKeysOrReturnNullIfAnyNulls(keys, (Function1<? super String, String>)((Function1)new Function1<String, String>(this){
            final /* synthetic */ WsSession this$0;

            @Nullable
            public final String invoke(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return WsSession.queryParam$default(this.this$0, it, null, 2, null);
            }
            {
                this.this$0 = wsSession;
                super(1);
            }
        }));
    }

    public final boolean anyQueryParamNull(String ... keys) {
        boolean bl;
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)keys, (String)"keys");
            for (String element$iv : keys) {
                String it = element$iv;
                if (!(WsSession.queryParam$default(this, it, null, 2, null) == null)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final String pathParam(@NotNull String pathParam) {
        Intrinsics.checkParameterIsNotNull((Object)pathParam, (String)"pathParam");
        return ContextUtil.INSTANCE.pathParamOrThrow(this.pathParamMap, pathParam, this.matchedPath);
    }

    @NotNull
    public final Map<String, String> pathParamMap() {
        return this.pathParamMap;
    }

    @Nullable
    public final String host() {
        UpgradeRequest upgradeRequest = this.webSocketSession.getUpgradeRequest();
        Intrinsics.checkExpressionValueIsNotNull((Object)upgradeRequest, (String)"webSocketSession.upgradeRequest");
        return upgradeRequest.getHost();
    }

    @Nullable
    public final String header(@NotNull String header) {
        Intrinsics.checkParameterIsNotNull((Object)header, (String)"header");
        return this.webSocketSession.getUpgradeRequest().getHeader(header);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, String> headerMap() {
        void var3_3;
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        UpgradeRequest upgradeRequest = this.webSocketSession.getUpgradeRequest();
        Intrinsics.checkExpressionValueIsNotNull((Object)upgradeRequest, (String)"webSocketSession.upgradeRequest");
        Iterable iterable = $receiver$iv = (Iterable)upgradeRequest.getHeaders().keySet();
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            Pair pair = TuplesKt.to((Object)it, (Object)this.webSocketSession.getUpgradeRequest().getHeader((String)it));
            collection.add(pair);
        }
        return MapsKt.toMap((Iterable)((List)var3_3));
    }

    @NotNull
    public final String matchedPath() {
        return this.matchedPath;
    }

    public void close() {
        this.webSocketSession.close();
    }

    public void close(@NotNull CloseStatus closeStatus) {
        Intrinsics.checkParameterIsNotNull((Object)closeStatus, (String)"closeStatus");
        this.webSocketSession.close(closeStatus);
    }

    public void close(int statusCode, @NotNull String reason) {
        Intrinsics.checkParameterIsNotNull((Object)reason, (String)"reason");
        this.webSocketSession.close(statusCode, reason);
    }

    public void disconnect() {
        this.webSocketSession.disconnect();
    }

    public long getIdleTimeout() {
        return this.webSocketSession.getIdleTimeout();
    }

    @NotNull
    public InetSocketAddress getLocalAddress() {
        InetSocketAddress inetSocketAddress = this.webSocketSession.getLocalAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)inetSocketAddress, (String)"webSocketSession.localAddress");
        return inetSocketAddress;
    }

    @NotNull
    public WebSocketPolicy getPolicy() {
        WebSocketPolicy webSocketPolicy = this.webSocketSession.getPolicy();
        Intrinsics.checkExpressionValueIsNotNull((Object)webSocketPolicy, (String)"webSocketSession.policy");
        return webSocketPolicy;
    }

    @NotNull
    public String getProtocolVersion() {
        String string = this.webSocketSession.getProtocolVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"webSocketSession.protocolVersion");
        return string;
    }

    @NotNull
    public RemoteEndpoint getRemote() {
        RemoteEndpoint remoteEndpoint = this.webSocketSession.getRemote();
        Intrinsics.checkExpressionValueIsNotNull((Object)remoteEndpoint, (String)"webSocketSession.remote");
        return remoteEndpoint;
    }

    @NotNull
    public InetSocketAddress getRemoteAddress() {
        InetSocketAddress inetSocketAddress = this.webSocketSession.getRemoteAddress();
        Intrinsics.checkExpressionValueIsNotNull((Object)inetSocketAddress, (String)"webSocketSession.remoteAddress");
        return inetSocketAddress;
    }

    @NotNull
    public UpgradeRequest getUpgradeRequest() {
        UpgradeRequest upgradeRequest = this.webSocketSession.getUpgradeRequest();
        Intrinsics.checkExpressionValueIsNotNull((Object)upgradeRequest, (String)"webSocketSession.upgradeRequest");
        return upgradeRequest;
    }

    @NotNull
    public UpgradeResponse getUpgradeResponse() {
        UpgradeResponse upgradeResponse = this.webSocketSession.getUpgradeResponse();
        Intrinsics.checkExpressionValueIsNotNull((Object)upgradeResponse, (String)"webSocketSession.upgradeResponse");
        return upgradeResponse;
    }

    public boolean isOpen() {
        return this.webSocketSession.isOpen();
    }

    public boolean isSecure() {
        return this.webSocketSession.isSecure();
    }

    public void setIdleTimeout(long ms) {
        this.webSocketSession.setIdleTimeout(ms);
    }

    @NotNull
    public SuspendToken suspend() {
        SuspendToken suspendToken = this.webSocketSession.suspend();
        Intrinsics.checkExpressionValueIsNotNull((Object)suspendToken, (String)"webSocketSession.suspend()");
        return suspendToken;
    }

    public boolean equals(@Nullable Object other) {
        Object object = other;
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type io.javalin.websocket.WsSession");
        }
        return Intrinsics.areEqual((Object)this.webSocketSession, (Object)((WsSession)object).webSocketSession);
    }

    public int hashCode() {
        return this.webSocketSession.hashCode();
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public WsSession(@NotNull String id, @NotNull Session session, @NotNull Map<String, String> pathParamMap, @NotNull String matchedPath) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull(pathParamMap, (String)"pathParamMap");
        Intrinsics.checkParameterIsNotNull((Object)matchedPath, (String)"matchedPath");
        this.id = id;
        this.pathParamMap = pathParamMap;
        this.matchedPath = matchedPath;
        this.webSocketSession = (WebSocketSession)session;
    }
}

