/*
 * Decompiled with CFR 0.152.
 */
package io.mockk.impl;

import io.mockk.impl.InternalPlatform;
import io.mockk.impl.MultiNotifier;
import io.mockk.impl.Ref;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001%B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u001aH\u0016J\u001e\u0010 \u001a\u00020!2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020#H\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lio/mockk/impl/JvmMultiNotifier;", "Lio/mockk/impl/MultiNotifier;", "()V", "condition", "Ljava/util/concurrent/locks/Condition;", "kotlin.jvm.PlatformType", "getCondition", "()Ljava/util/concurrent/locks/Condition;", "conditionMet", "", "Lio/mockk/impl/Ref;", "getConditionMet", "()Ljava/util/Set;", "counters", "", "", "getCounters", "()Ljava/util/Map;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "changeCounters", "", "keys", "", "", "delta", "checkAnyConditionsMet", "", "notify", "key", "openSession", "Lio/mockk/impl/MultiNotifier$Session;", "timeout", "", "time", "SessionImpl", "mockk"})
public final class JvmMultiNotifier
implements MultiNotifier {
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    @NotNull
    private final Set<Ref> conditionMet;
    @NotNull
    private final Map<Ref, Integer> counters;

    @NotNull
    public final ReentrantLock getLock() {
        return this.lock;
    }

    public final Condition getCondition() {
        return this.condition;
    }

    @NotNull
    public final Set<Ref> getConditionMet() {
        return this.conditionMet;
    }

    @NotNull
    public final Map<Ref, Integer> getCounters() {
        return this.counters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public MultiNotifier.Session openSession(@NotNull List<? extends Object> keys, long timeout) {
        Intrinsics.checkParameterIsNotNull(keys, (String)"keys");
        long start = this.time();
        Lock lock = this.lock;
        lock.lock();
        try {
            this.changeCounters(keys, 1);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return new SessionImpl(start, timeout, keys);
    }

    private final boolean checkAnyConditionsMet(List<? extends Object> keys) {
        boolean bl;
        block3: {
            Iterable $receiver$iv = keys;
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $receiver$iv) {
                    Object it = element$iv;
                    if (!this.conditionMet.contains(InternalPlatform.INSTANCE.ref(it))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final long time() {
        return System.currentTimeMillis();
    }

    private final void changeCounters(List<? extends Object> keys, int delta) {
        Iterable $receiver$iv = keys;
        for (Object element$iv : $receiver$iv) {
            Object it = element$iv;
            Ref ref = InternalPlatform.INSTANCE.ref(it);
            int value = ((Number)this.counters.getOrDefault(ref, 0)).intValue() + delta;
            if (value == 0) {
                this.conditionMet.remove(ref);
                this.counters.remove(ref);
                continue;
            }
            Map<Ref, Integer> map2 = this.counters;
            Integer n = value;
            map2.put(ref, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(@NotNull Object key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        Lock lock = this.lock;
        lock.lock();
        try {
            Unit unit;
            Ref ref = InternalPlatform.INSTANCE.ref(key);
            Unit unit2 = unit = this.counters;
            if (unit2.containsKey(ref)) {
                this.conditionMet.add(ref);
            }
            this.condition.signalAll();
            unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public JvmMultiNotifier() {
        JvmMultiNotifier jvmMultiNotifier = this;
        Object object = new LinkedHashSet();
        jvmMultiNotifier.conditionMet = object;
        jvmMultiNotifier = this;
        jvmMultiNotifier.counters = object = (Map)new LinkedHashMap();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/mockk/impl/JvmMultiNotifier$SessionImpl;", "Lio/mockk/impl/MultiNotifier$Session;", "start", "", "timeout", "keys", "", "", "(Lio/mockk/impl/JvmMultiNotifier;JJLjava/util/List;)V", "close", "", "wait", "", "mockk"})
    public final class SessionImpl
    implements MultiNotifier.Session {
        private final long start;
        private final long timeout;
        private final List<Object> keys;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean wait() {
            boolean ret = false;
            Lock lock = JvmMultiNotifier.this.getLock();
            lock.lock();
            try {
                long passed;
                while ((passed = JvmMultiNotifier.this.time() - this.start) < this.timeout) {
                    if (JvmMultiNotifier.this.checkAnyConditionsMet(this.keys)) {
                        ret = true;
                        break;
                    }
                    if (JvmMultiNotifier.this.getCondition().await(this.timeout - passed, TimeUnit.MILLISECONDS)) continue;
                    break;
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Lock lock = JvmMultiNotifier.this.getLock();
            lock.lock();
            try {
                JvmMultiNotifier.this.changeCounters(this.keys, -1);
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }

        public SessionImpl(long start, @NotNull long timeout, List<? extends Object> keys) {
            Intrinsics.checkParameterIsNotNull(keys, (String)"keys");
            this.start = start;
            this.timeout = timeout;
            this.keys = keys;
        }
    }
}

