/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.flowable;

import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.disposables.Disposable;
import io.reactivex.exceptions.Exceptions;
import io.reactivex.exceptions.MissingBackpressureException;
import io.reactivex.functions.Cancellable;
import io.reactivex.internal.disposables.CancellableDisposable;
import io.reactivex.internal.disposables.SequentialDisposable;
import io.reactivex.internal.fuseable.SimplePlainQueue;
import io.reactivex.internal.queue.SpscLinkedArrayQueue;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.internal.util.AtomicThrowable;
import io.reactivex.internal.util.BackpressureHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableCreate<T>
extends Flowable<T> {
    final FlowableOnSubscribe<T> source;
    final BackpressureStrategy backpressure;

    public FlowableCreate(FlowableOnSubscribe<T> source, BackpressureStrategy backpressure) {
        this.source = source;
        this.backpressure = backpressure;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> t) {
        BaseEmitter emitter;
        switch (this.backpressure) {
            case MISSING: {
                emitter = new MissingEmitter<T>(t);
                break;
            }
            case ERROR: {
                emitter = new ErrorAsyncEmitter<T>(t);
                break;
            }
            case DROP: {
                emitter = new DropAsyncEmitter<T>(t);
                break;
            }
            case LATEST: {
                emitter = new LatestAsyncEmitter<T>(t);
                break;
            }
            default: {
                emitter = new BufferAsyncEmitter<T>(t, FlowableCreate.bufferSize());
            }
        }
        t.onSubscribe(emitter);
        try {
            this.source.subscribe(emitter);
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            emitter.onError(ex);
        }
    }

    static final class LatestAsyncEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 4023437720691792495L;
        final AtomicReference<T> queue = new AtomicReference();
        Throwable error;
        volatile boolean done;
        final AtomicInteger wip = new AtomicInteger();

        LatestAsyncEmitter(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public void onNext(T t) {
            if (this.done || this.isCancelled()) {
                return;
            }
            if (t == null) {
                this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
                return;
            }
            this.queue.set(t);
            this.drain();
        }

        @Override
        public boolean tryOnError(Throwable e) {
            if (this.done || this.isCancelled()) {
                return false;
            }
            if (e == null) {
                this.onError(new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources."));
            }
            this.error = e;
            this.done = true;
            this.drain();
            return true;
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequested() {
            this.drain();
        }

        @Override
        void onUnsubscribed() {
            if (this.wip.getAndIncrement() == 0) {
                this.queue.lazySet(null);
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = this.actual;
            AtomicReference<T> q = this.queue;
            do {
                boolean d;
                long e;
                long r = this.get();
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.lazySet(null);
                        return;
                    }
                    d = this.done;
                    Object o = q.getAndSet(null);
                    boolean bl = empty = o == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.error(ex);
                        } else {
                            this.complete();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(o);
                }
                if (e == r) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.lazySet(null);
                        return;
                    }
                    d = this.done;
                    boolean bl = empty = q.get() == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.error(ex);
                        } else {
                            this.complete();
                        }
                        return;
                    }
                }
                if (e == 0L) continue;
                BackpressureHelper.produced(this, e);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }
    }

    static final class BufferAsyncEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 2427151001689639875L;
        final SpscLinkedArrayQueue<T> queue;
        Throwable error;
        volatile boolean done;
        final AtomicInteger wip;

        BufferAsyncEmitter(Subscriber<? super T> actual, int capacityHint) {
            super(actual);
            this.queue = new SpscLinkedArrayQueue(capacityHint);
            this.wip = new AtomicInteger();
        }

        @Override
        public void onNext(T t) {
            if (this.done || this.isCancelled()) {
                return;
            }
            if (t == null) {
                this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
                return;
            }
            this.queue.offer(t);
            this.drain();
        }

        @Override
        public boolean tryOnError(Throwable e) {
            if (this.done || this.isCancelled()) {
                return false;
            }
            if (e == null) {
                e = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
            }
            this.error = e;
            this.done = true;
            this.drain();
            return true;
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.drain();
        }

        @Override
        void onRequested() {
            this.drain();
        }

        @Override
        void onUnsubscribed() {
            if (this.wip.getAndIncrement() == 0) {
                this.queue.clear();
            }
        }

        void drain() {
            if (this.wip.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Subscriber a = this.actual;
            SpscLinkedArrayQueue<T> q = this.queue;
            do {
                boolean d;
                long e;
                long r = this.get();
                for (e = 0L; e != r; ++e) {
                    boolean empty;
                    if (this.isCancelled()) {
                        q.clear();
                        return;
                    }
                    d = this.done;
                    T o = q.poll();
                    boolean bl = empty = o == null;
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.error(ex);
                        } else {
                            this.complete();
                        }
                        return;
                    }
                    if (empty) break;
                    a.onNext(o);
                }
                if (e == r) {
                    if (this.isCancelled()) {
                        q.clear();
                        return;
                    }
                    d = this.done;
                    boolean empty = q.isEmpty();
                    if (d && empty) {
                        Throwable ex = this.error;
                        if (ex != null) {
                            this.error(ex);
                        } else {
                            this.complete();
                        }
                        return;
                    }
                }
                if (e == 0L) continue;
                BackpressureHelper.produced(this, e);
            } while ((missed = this.wip.addAndGet(-missed)) != 0);
        }
    }

    static final class ErrorAsyncEmitter<T>
    extends NoOverflowBaseAsyncEmitter<T> {
        private static final long serialVersionUID = 338953216916120960L;

        ErrorAsyncEmitter(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        void onOverflow() {
            this.onError(new MissingBackpressureException("create: could not emit value due to lack of requests"));
        }
    }

    static final class DropAsyncEmitter<T>
    extends NoOverflowBaseAsyncEmitter<T> {
        private static final long serialVersionUID = 8360058422307496563L;

        DropAsyncEmitter(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        void onOverflow() {
        }
    }

    static abstract class NoOverflowBaseAsyncEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 4127754106204442833L;

        NoOverflowBaseAsyncEmitter(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public final void onNext(T t) {
            if (this.isCancelled()) {
                return;
            }
            if (t == null) {
                this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
                return;
            }
            if (this.get() != 0L) {
                this.actual.onNext(t);
                BackpressureHelper.produced(this, 1L);
            } else {
                this.onOverflow();
            }
        }

        abstract void onOverflow();
    }

    static final class MissingEmitter<T>
    extends BaseEmitter<T> {
        private static final long serialVersionUID = 3776720187248809713L;

        MissingEmitter(Subscriber<? super T> actual) {
            super(actual);
        }

        @Override
        public void onNext(T t) {
            long r;
            if (this.isCancelled()) {
                return;
            }
            if (t != null) {
                this.actual.onNext(t);
            } else {
                this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
                return;
            }
            while ((r = this.get()) != 0L && !this.compareAndSet(r, r - 1L)) {
            }
        }
    }

    static abstract class BaseEmitter<T>
    extends AtomicLong
    implements FlowableEmitter<T>,
    Subscription {
        private static final long serialVersionUID = 7326289992464377023L;
        final Subscriber<? super T> actual;
        final SequentialDisposable serial;

        BaseEmitter(Subscriber<? super T> actual) {
            this.actual = actual;
            this.serial = new SequentialDisposable();
        }

        @Override
        public void onComplete() {
            this.complete();
        }

        protected void complete() {
            if (this.isCancelled()) {
                return;
            }
            try {
                this.actual.onComplete();
            }
            finally {
                this.serial.dispose();
            }
        }

        @Override
        public final void onError(Throwable e) {
            if (!this.tryOnError(e)) {
                RxJavaPlugins.onError(e);
            }
        }

        @Override
        public boolean tryOnError(Throwable e) {
            return this.error(e);
        }

        protected boolean error(Throwable e) {
            if (e == null) {
                e = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
            }
            if (this.isCancelled()) {
                return false;
            }
            try {
                this.actual.onError(e);
            }
            finally {
                this.serial.dispose();
            }
            return true;
        }

        public final void cancel() {
            this.serial.dispose();
            this.onUnsubscribed();
        }

        void onUnsubscribed() {
        }

        @Override
        public final boolean isCancelled() {
            return this.serial.isDisposed();
        }

        public final void request(long n) {
            if (SubscriptionHelper.validate(n)) {
                BackpressureHelper.add(this, n);
                this.onRequested();
            }
        }

        void onRequested() {
        }

        @Override
        public final void setDisposable(Disposable s) {
            this.serial.update(s);
        }

        @Override
        public final void setCancellable(Cancellable c) {
            this.setDisposable(new CancellableDisposable(c));
        }

        @Override
        public final long requested() {
            return this.get();
        }

        @Override
        public final FlowableEmitter<T> serialize() {
            return new SerializedEmitter(this);
        }
    }

    static final class SerializedEmitter<T>
    extends AtomicInteger
    implements FlowableEmitter<T> {
        private static final long serialVersionUID = 4883307006032401862L;
        final BaseEmitter<T> emitter;
        final AtomicThrowable error;
        final SimplePlainQueue<T> queue;
        volatile boolean done;

        SerializedEmitter(BaseEmitter<T> emitter) {
            this.emitter = emitter;
            this.error = new AtomicThrowable();
            this.queue = new SpscLinkedArrayQueue(16);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t) {
            if (this.emitter.isCancelled() || this.done) {
                return;
            }
            if (t == null) {
                this.onError(new NullPointerException("onNext called with null. Null values are generally not allowed in 2.x operators and sources."));
                return;
            }
            if (this.get() == 0 && this.compareAndSet(0, 1)) {
                this.emitter.onNext(t);
                if (this.decrementAndGet() == 0) {
                    return;
                }
            } else {
                SimplePlainQueue<T> q;
                SimplePlainQueue<T> simplePlainQueue = q = this.queue;
                synchronized (simplePlainQueue) {
                    q.offer(t);
                }
                if (this.getAndIncrement() != 0) {
                    return;
                }
            }
            this.drainLoop();
        }

        @Override
        public void onError(Throwable t) {
            if (!this.tryOnError(t)) {
                RxJavaPlugins.onError(t);
            }
        }

        @Override
        public boolean tryOnError(Throwable t) {
            if (this.emitter.isCancelled() || this.done) {
                return false;
            }
            if (t == null) {
                t = new NullPointerException("onError called with null. Null values are generally not allowed in 2.x operators and sources.");
            }
            if (this.error.addThrowable(t)) {
                this.done = true;
                this.drain();
                return true;
            }
            return false;
        }

        @Override
        public void onComplete() {
            if (this.emitter.isCancelled() || this.done) {
                return;
            }
            this.done = true;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() == 0) {
                this.drainLoop();
            }
        }

        void drainLoop() {
            BaseEmitter<T> e = this.emitter;
            SimplePlainQueue<T> q = this.queue;
            AtomicThrowable error = this.error;
            int missed = 1;
            while (true) {
                boolean empty;
                if (e.isCancelled()) {
                    q.clear();
                    return;
                }
                if (error.get() != null) {
                    q.clear();
                    e.onError(error.terminate());
                    return;
                }
                boolean d = this.done;
                T v = q.poll();
                boolean bl = empty = v == null;
                if (d && empty) {
                    e.onComplete();
                    return;
                }
                if (!empty) {
                    e.onNext(v);
                    continue;
                }
                if ((missed = this.addAndGet(-missed)) == 0) break;
            }
        }

        @Override
        public void setDisposable(Disposable s) {
            this.emitter.setDisposable(s);
        }

        @Override
        public void setCancellable(Cancellable c) {
            this.emitter.setCancellable(c);
        }

        @Override
        public long requested() {
            return this.emitter.requested();
        }

        @Override
        public boolean isCancelled() {
            return this.emitter.isCancelled();
        }

        @Override
        public FlowableEmitter<T> serialize() {
            return this;
        }
    }
}

