/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote;

import com.alibaba.nacos.common.JustForTest;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.PayloadRegistry;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.core.remote.RpcServerTlsConfig;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseRpcServer {
    @Autowired
    protected RpcServerTlsConfig grpcServerConfig;

    @JustForTest
    public void setGrpcServerConfig(RpcServerTlsConfig grpcServerConfig) {
        this.grpcServerConfig = grpcServerConfig;
    }

    @PostConstruct
    public void start() throws Exception {
        String serverName = this.getClass().getSimpleName();
        String tlsConfig = JacksonUtils.toJson((Object)((Object)this.grpcServerConfig));
        Loggers.REMOTE.info("Nacos {} Rpc server starting at port {} and tls config:{}", new Object[]{serverName, this.getServicePort(), tlsConfig});
        this.startServer();
        Loggers.REMOTE.info("Nacos {} Rpc server started at port {} and tls config:{}", new Object[]{serverName, this.getServicePort(), tlsConfig});
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            Loggers.REMOTE.info("Nacos {} Rpc server stopping", (Object)serverName);
            try {
                this.stopServer();
                Loggers.REMOTE.info("Nacos {} Rpc server stopped successfully...", (Object)serverName);
            }
            catch (Exception e) {
                Loggers.REMOTE.error("Nacos {} Rpc server stopped fail...", (Object)serverName, (Object)e);
            }
        }));
    }

    public abstract ConnectionType getConnectionType();

    public abstract void startServer() throws Exception;

    public abstract int rpcPortOffset();

    public int getServicePort() {
        return EnvUtil.getPort() + this.rpcPortOffset();
    }

    public final void stopServer() throws Exception {
        this.shutdownServer();
    }

    @PreDestroy
    public abstract void shutdownServer();

    static {
        PayloadRegistry.init();
    }
}

