/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc;

import com.alibaba.nacos.api.grpc.auto.Payload;
import com.alibaba.nacos.common.packagescan.resource.DefaultResourceLoader;
import com.alibaba.nacos.common.packagescan.resource.Resource;
import com.alibaba.nacos.common.packagescan.resource.ResourceLoader;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.TlsTypeResolve;
import com.alibaba.nacos.core.remote.BaseRpcServer;
import com.alibaba.nacos.core.remote.ConnectionManager;
import com.alibaba.nacos.core.remote.grpc.AddressTransportFilter;
import com.alibaba.nacos.core.remote.grpc.GrpcBiStreamRequestAcceptor;
import com.alibaba.nacos.core.remote.grpc.GrpcConnectionInterceptor;
import com.alibaba.nacos.core.remote.grpc.GrpcRequestAcceptor;
import com.alibaba.nacos.core.remote.grpc.GrpcServerConstants;
import com.alibaba.nacos.core.remote.grpc.OptionalTlsProtocolNegotiator;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.google.protobuf.Message;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.HandlerRegistry;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServerTransportFilter;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NettyServerBuilder;
import io.grpc.netty.shaded.io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslProvider;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.grpc.protobuf.ProtoUtils;
import io.grpc.stub.ServerCalls;
import io.grpc.stub.StreamObserver;
import io.grpc.util.MutableHandlerRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseGrpcServer
extends BaseRpcServer {
    private Server server;
    private final ResourceLoader resourceLoader = new DefaultResourceLoader();
    @Autowired
    private GrpcRequestAcceptor grpcCommonRequestAcceptor;
    @Autowired
    private GrpcBiStreamRequestAcceptor grpcBiStreamRequestAcceptor;
    @Autowired
    private ConnectionManager connectionManager;

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.GRPC;
    }

    @Override
    public void startServer() throws Exception {
        MutableHandlerRegistry handlerRegistry = new MutableHandlerRegistry();
        this.addServices(handlerRegistry, new GrpcConnectionInterceptor());
        NettyServerBuilder builder = (NettyServerBuilder)NettyServerBuilder.forPort((int)this.getServicePort()).executor((Executor)this.getRpcExecutor());
        if (this.grpcServerConfig.getEnableTls().booleanValue()) {
            if (this.grpcServerConfig.getCompatibility().booleanValue()) {
                builder.protocolNegotiator((ProtocolNegotiator)new OptionalTlsProtocolNegotiator(this.getSslContextBuilder()));
            } else {
                builder.sslContext(this.getSslContextBuilder());
            }
        }
        this.server = ((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)((NettyServerBuilder)builder.maxInboundMessageSize(this.getMaxInboundMessageSize()).fallbackHandlerRegistry((HandlerRegistry)handlerRegistry)).compressorRegistry(CompressorRegistry.getDefaultInstance())).decompressorRegistry(DecompressorRegistry.getDefaultInstance())).addTransportFilter((ServerTransportFilter)new AddressTransportFilter(this.connectionManager))).keepAliveTime(this.getKeepAliveTime(), TimeUnit.MILLISECONDS).keepAliveTimeout(this.getKeepAliveTimeout(), TimeUnit.MILLISECONDS).permitKeepAliveTime(this.getPermitKeepAliveTime(), TimeUnit.MILLISECONDS).build();
        this.server.start();
    }

    protected long getPermitKeepAliveTime() {
        return GrpcServerConstants.GrpcConfig.DEFAULT_GRPC_PERMIT_KEEP_ALIVE_TIME;
    }

    protected long getKeepAliveTime() {
        return GrpcServerConstants.GrpcConfig.DEFAULT_GRPC_KEEP_ALIVE_TIME;
    }

    protected long getKeepAliveTimeout() {
        return GrpcServerConstants.GrpcConfig.DEFAULT_GRPC_KEEP_ALIVE_TIMEOUT;
    }

    protected int getMaxInboundMessageSize() {
        Integer property = (Integer)EnvUtil.getProperty((String)"nacos.remote.server.grpc.maxinbound.message.size", Integer.class);
        if (property != null) {
            return property;
        }
        return 0xA00000;
    }

    private void addServices(MutableHandlerRegistry handlerRegistry, ServerInterceptor ... serverInterceptor) {
        MethodDescriptor unaryPayloadMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"Request", (String)"request")).setRequestMarshaller(ProtoUtils.marshaller((Message)Payload.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Payload.getDefaultInstance())).build();
        ServerCallHandler payloadHandler = ServerCalls.asyncUnaryCall((request, responseObserver) -> this.grpcCommonRequestAcceptor.request((Payload)request, (StreamObserver<Payload>)responseObserver));
        ServerServiceDefinition serviceDefOfUnaryPayload = ServerServiceDefinition.builder((String)"Request").addMethod(unaryPayloadMethod, payloadHandler).build();
        handlerRegistry.addService(ServerInterceptors.intercept((ServerServiceDefinition)serviceDefOfUnaryPayload, (ServerInterceptor[])serverInterceptor));
        ServerCallHandler biStreamHandler = ServerCalls.asyncBidiStreamingCall(responseObserver -> this.grpcBiStreamRequestAcceptor.requestBiStream((StreamObserver<Payload>)responseObserver));
        MethodDescriptor biStreamMethod = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.BIDI_STREAMING).setFullMethodName(MethodDescriptor.generateFullMethodName((String)"BiRequestStream", (String)"requestBiStream")).setRequestMarshaller(ProtoUtils.marshaller((Message)Payload.newBuilder().build())).setResponseMarshaller(ProtoUtils.marshaller((Message)Payload.getDefaultInstance())).build();
        ServerServiceDefinition serviceDefOfBiStream = ServerServiceDefinition.builder((String)"BiRequestStream").addMethod(biStreamMethod, biStreamHandler).build();
        handlerRegistry.addService(ServerInterceptors.intercept((ServerServiceDefinition)serviceDefOfBiStream, (ServerInterceptor[])serverInterceptor));
    }

    @Override
    public void shutdownServer() {
        if (this.server != null) {
            this.server.shutdownNow();
        }
    }

    private SslContext getSslContextBuilder() {
        try {
            if (StringUtils.isBlank((CharSequence)this.grpcServerConfig.getCertChainFile()) || StringUtils.isBlank((CharSequence)this.grpcServerConfig.getCertPrivateKey())) {
                throw new IllegalArgumentException("Server certChainFile or certPrivateKey must be not null");
            }
            InputStream certificateChainFile = this.getInputStream(this.grpcServerConfig.getCertChainFile(), "certChainFile");
            InputStream privateKeyFile = this.getInputStream(this.grpcServerConfig.getCertPrivateKey(), "certPrivateKey");
            SslContextBuilder sslClientContextBuilder = SslContextBuilder.forServer((InputStream)certificateChainFile, (InputStream)privateKeyFile, (String)this.grpcServerConfig.getCertPrivateKeyPassword());
            if (StringUtils.isNotBlank((String)this.grpcServerConfig.getProtocols())) {
                sslClientContextBuilder.protocols(this.grpcServerConfig.getProtocols().split(","));
            }
            if (StringUtils.isNotBlank((String)this.grpcServerConfig.getCiphers())) {
                sslClientContextBuilder.ciphers(Arrays.asList(this.grpcServerConfig.getCiphers().split(",")));
            }
            if (this.grpcServerConfig.getMutualAuthEnable().booleanValue()) {
                if (this.grpcServerConfig.getTrustAll().booleanValue()) {
                    sslClientContextBuilder.trustManager(InsecureTrustManagerFactory.INSTANCE);
                } else {
                    if (StringUtils.isBlank((CharSequence)this.grpcServerConfig.getTrustCollectionCertFile())) {
                        throw new IllegalArgumentException("enable mutual auth,trustCollectionCertFile must be not null");
                    }
                    InputStream clientCert = this.getInputStream(this.grpcServerConfig.getTrustCollectionCertFile(), "trustCollectionCertFile");
                    sslClientContextBuilder.trustManager(clientCert);
                }
                sslClientContextBuilder.clientAuth(ClientAuth.REQUIRE);
            }
            SslContextBuilder configure = GrpcSslContexts.configure((SslContextBuilder)sslClientContextBuilder, (SslProvider)TlsTypeResolve.getSslProvider((String)this.grpcServerConfig.getSslProvider()));
            return configure.build();
        }
        catch (SSLException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream getInputStream(String path, String config) {
        try {
            Resource resource = this.resourceLoader.getResource(path);
            return resource.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(config + " load fail", e);
        }
    }

    public abstract ThreadPoolExecutor getRpcExecutor();
}

