/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.camel;

import io.vertx.camel.CamelMapping;
import java.util.Objects;
import org.apache.camel.Endpoint;

public class InboundMapping
extends CamelMapping {
    public static final boolean DEFAULT_PUBLISH = false;
    private boolean publish = false;
    private Class bodyType;

    public static InboundMapping fromCamel(String uri) {
        Objects.requireNonNull(uri);
        return new InboundMapping().setUri(uri);
    }

    public static InboundMapping fromCamel(Endpoint endpoint) {
        Objects.requireNonNull(endpoint);
        return new InboundMapping().setEndpoint(endpoint);
    }

    public boolean isPublish() {
        return this.publish;
    }

    public Class getBodyType() {
        return this.bodyType;
    }

    public InboundMapping withBodyType(Class bodyType) {
        this.bodyType = bodyType;
        return this;
    }

    @Override
    public InboundMapping setAddress(String address) {
        super.setAddress(address);
        return this;
    }

    public InboundMapping toVertx(String address) {
        return this.setAddress(address);
    }

    public InboundMapping withoutHeadersCopy() {
        return this.setHeadersCopy(false);
    }

    @Override
    public InboundMapping setHeadersCopy(boolean headersCopy) {
        super.setHeadersCopy(headersCopy);
        return this;
    }

    @Override
    public InboundMapping setUri(String uri) {
        super.setUri(uri);
        return this;
    }

    @Override
    public InboundMapping setEndpoint(Endpoint endpoint) {
        super.setEndpoint(endpoint);
        return this;
    }

    public InboundMapping usePublish() {
        this.publish = true;
        return this;
    }
}

