/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.codetrans.lang.groovy;

import com.sun.source.tree.LambdaExpressionTree;
import io.vertx.codegen.type.ApiTypeInfo;
import io.vertx.codegen.type.ClassTypeInfo;
import io.vertx.codegen.type.EnumTypeInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codetrans.CodeModel;
import io.vertx.codetrans.CodeWriter;
import io.vertx.codetrans.MethodSignature;
import io.vertx.codetrans.expression.DataObjectLiteralModel;
import io.vertx.codetrans.expression.ExpressionModel;
import io.vertx.codetrans.expression.JsonArrayLiteralModel;
import io.vertx.codetrans.expression.JsonObjectLiteralModel;
import io.vertx.codetrans.expression.Member;
import io.vertx.codetrans.lang.groovy.GroovyCodeBuilder;
import io.vertx.codetrans.statement.StatementModel;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.lang.model.element.TypeElement;

class GroovyWriter
extends CodeWriter {
    final GroovyCodeBuilder builder;

    GroovyWriter(GroovyCodeBuilder builder) {
        super(builder);
        this.builder = builder;
    }

    @Override
    public void renderCharLiteral(char value) {
        this.append('\'');
        this.renderChars(Character.toString(value));
        this.append("' as char");
    }

    @Override
    public void renderStringLiteral(List<?> parts) {
        this.append('\"');
        for (Object part : parts) {
            if (part instanceof ExpressionModel) {
                this.append("${");
                ExpressionModel ex = (ExpressionModel)part;
                ex.render(this);
                this.append("}");
                continue;
            }
            this.renderChars(part.toString());
        }
        this.append('\"');
    }

    @Override
    public void renderStatement(StatementModel statement) {
        statement.render(this);
        this.append("\n");
    }

    @Override
    public void renderTryCatch(StatementModel tryBlock, StatementModel catchBlock) {
        this.append("try {\n");
        this.indent();
        tryBlock.render(this);
        this.unindent();
        this.append("} catch(Exception e) {\n");
        this.indent();
        catchBlock.render(this);
        this.unindent();
        this.append("}\n");
    }

    @Override
    public void renderLongLiteral(String value) {
        this.renderChars(value);
        this.append('L');
    }

    @Override
    public void renderFloatLiteral(String value) {
        this.renderChars(value);
        this.append('f');
    }

    @Override
    public void renderDoubleLiteral(String value) {
        this.renderChars(value);
        this.append('d');
    }

    @Override
    public void renderThis() {
        this.append("this");
    }

    @Override
    public void renderLambda(LambdaExpressionTree.BodyKind bodyKind, List<TypeInfo> parameterTypes, List<String> parameterNames, CodeModel body) {
        this.append("{");
        for (int i = 0; i < parameterNames.size(); ++i) {
            if (i == 0) {
                this.append(" ");
            } else {
                this.append(", ");
            }
            this.append(parameterNames.get(i));
        }
        this.append(" ->\n");
        this.indent();
        body.render(this);
        if (bodyKind == LambdaExpressionTree.BodyKind.EXPRESSION) {
            this.append("\n");
        }
        this.unindent();
        this.append("}");
    }

    @Override
    public void renderApiType(ApiTypeInfo apiType) {
        this.append(apiType.getSimpleName());
    }

    @Override
    public void renderJavaType(ClassTypeInfo javaType) {
        this.append(javaType.getName());
    }

    @Override
    public void renderAsyncResultSucceeded(TypeInfo resultType, String name) {
        this.append(name).append(".succeeded()");
    }

    @Override
    public void renderAsyncResultFailed(TypeInfo resultType, String name) {
        this.append(name).append(".failed()");
    }

    @Override
    public void renderAsyncResultCause(TypeInfo resultType, String name) {
        this.append(name).append(".cause()");
    }

    @Override
    public void renderAsyncResultValue(TypeInfo resultType, String name) {
        this.append(name).append(".result()");
    }

    @Override
    public void renderEnumConstant(EnumTypeInfo type, String constant) {
        this.append(type.getSimpleName()).append('.').append(constant);
    }

    @Override
    public void renderThrow(String throwableType, ExpressionModel reason) {
        if (reason == null) {
            this.append("throw new ").append(throwableType).append("()");
        } else {
            this.append("throw new ").append(throwableType).append("(");
            reason.render(this);
            this.append(")");
        }
    }

    @Override
    public void renderSystemOutPrintln(ExpressionModel expression) {
        this.append("println(");
        expression.render(this);
        this.append(")");
    }

    @Override
    public void renderSystemErrPrintln(ExpressionModel expression) {
        this.append("System.err.println(");
        expression.render(this);
        this.append(")");
    }

    @Override
    public void renderNewMap() {
        this.append("[:]");
    }

    @Override
    public void renderNewList() {
        this.append("[]");
    }

    @Override
    public void renderDataObject(DataObjectLiteralModel model) {
        this.renderJsonObject(model.getMembers());
    }

    @Override
    public void renderJsonObject(JsonObjectLiteralModel jsonObject) {
        this.renderJsonObject(jsonObject.getMembers());
    }

    @Override
    public void renderJsonArray(JsonArrayLiteralModel jsonArray) {
        this.renderJsonArray(jsonArray.getValues());
    }

    private boolean isValidMapLiteralKey(String s) {
        int len = s.length();
        if (len == 0) {
            return false;
        }
        if (!Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < len; ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void renderJsonObject(Iterable<Member> members) {
        Iterator<Member> iterator = members.iterator();
        if (iterator.hasNext()) {
            this.append("[\n").indent();
            while (iterator.hasNext()) {
                Member member = iterator.next();
                String name = member.getName();
                if (this.isValidMapLiteralKey(name)) {
                    this.append(name);
                } else {
                    this.append("'");
                    this.renderChars(name);
                    this.append("'");
                }
                this.append(":");
                if (member instanceof Member.Single) {
                    ((Member.Single)member).getValue().render(this);
                } else if (member instanceof Member.Sequence) {
                    this.renderJsonArray(((Member.Sequence)member).getValues());
                } else if (member instanceof Member.Entries) {
                    this.renderJsonObject(((Member.Entries)member).entries());
                }
                if (iterator.hasNext()) {
                    this.append(',');
                }
                this.append('\n');
            }
            this.unindent().append("]");
        } else {
            this.append("[:]");
        }
    }

    private void renderJsonArray(List<ExpressionModel> values) {
        this.append("[\n").indent();
        for (int i = 0; i < values.size(); ++i) {
            values.get(i).render(this);
            if (i < values.size() - 1) {
                this.append(',');
            }
            this.append('\n');
        }
        this.unindent().append(']');
    }

    @Override
    public void renderJsonObjectAssign(ExpressionModel expression, String name, ExpressionModel value) {
        expression.render(this);
        this.append('.');
        this.append(name);
        this.append(" = ");
        value.render(this);
    }

    @Override
    public void renderJsonArrayAdd(ExpressionModel expression, ExpressionModel value) {
        expression.render(this);
        this.append(".add(");
        value.render(this);
        this.append(")");
    }

    @Override
    public void renderDataObjectAssign(ExpressionModel expression, String name, ExpressionModel value) {
        this.renderJsonObjectAssign(expression, name, value);
    }

    @Override
    public void renderJsonObjectMemberSelect(ExpressionModel expression, Class<?> type, String name) {
        expression.render(this);
        this.append('.');
        this.append(name);
    }

    @Override
    public void renderJsonObjectToString(ExpressionModel expression) {
        this.append("groovy.json.JsonOutput.toJson(");
        expression.render(this);
        this.append(")");
    }

    @Override
    public void renderJsonArrayToString(ExpressionModel expression) {
        this.append("groovy.json.JsonOutput.toJson(");
        expression.render(this);
        this.append(")");
    }

    @Override
    public void renderDataObjectMemberSelect(ExpressionModel expression, String name) {
        this.renderJsonObjectMemberSelect(expression, Object.class, name);
    }

    @Override
    public void renderListAdd(ExpressionModel list, ExpressionModel value) {
        list.render(this);
        this.append(".add(");
        value.render(this);
        this.append(")");
    }

    @Override
    public void renderListSize(ExpressionModel list) {
        list.render(this);
        this.append(".size()");
    }

    @Override
    public void renderListGet(ExpressionModel list, ExpressionModel index) {
        list.render(this);
        this.append("[");
        index.render(this);
        this.append("]");
    }

    @Override
    public void renderListLiteral(List<ExpressionModel> arguments) {
        this.append("[");
        Iterator<ExpressionModel> it = arguments.iterator();
        while (it.hasNext()) {
            it.next().render(this);
            if (!it.hasNext()) continue;
            this.append(", ");
        }
        this.append("]");
    }

    @Override
    public void renderMapGet(ExpressionModel map, ExpressionModel key) {
        map.render(this);
        this.append('[');
        key.render(this);
        this.append(']');
    }

    @Override
    public void renderMapPut(ExpressionModel map, ExpressionModel key, ExpressionModel value) {
        map.render(this);
        this.append('[');
        key.render(this);
        this.append("] = ");
        value.render(this);
    }

    @Override
    public void renderMapForEach(ExpressionModel map, String keyName, TypeInfo keyType, String valueName, TypeInfo valueType, LambdaExpressionTree.BodyKind bodyKind, CodeModel block) {
        map.render(this);
        this.append(".each ");
        this.renderLambda(bodyKind, Arrays.asList(keyType, valueType), Arrays.asList(keyName, valueName), block);
    }

    @Override
    public void renderMethodReference(ExpressionModel expression, MethodSignature signature) {
        expression.render(this);
        this.append(".&").append(signature.getName());
    }

    @Override
    public void renderNew(ExpressionModel expression, TypeInfo type, List<ExpressionModel> argumentModels) {
        this.append("new ");
        expression.render(this);
        this.append('(');
        for (int i = 0; i < argumentModels.size(); ++i) {
            if (i > 0) {
                this.append(", ");
            }
            argumentModels.get(i).render(this);
        }
        this.append(')');
    }

    @Override
    public void renderInstanceOf(ExpressionModel expression, TypeElement type) {
        expression.render(this);
        this.append(" instanceof ");
        this.append(type.getQualifiedName());
    }
}

