/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.Fluent;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.AclToken;
import io.vertx.ext.consul.BlockingQueryOptions;
import io.vertx.ext.consul.Check;
import io.vertx.ext.consul.CheckList;
import io.vertx.ext.consul.CheckOptions;
import io.vertx.ext.consul.CheckQueryOptions;
import io.vertx.ext.consul.CheckStatus;
import io.vertx.ext.consul.ConsulClientOptions;
import io.vertx.ext.consul.CoordinateList;
import io.vertx.ext.consul.DcCoordinates;
import io.vertx.ext.consul.Event;
import io.vertx.ext.consul.EventList;
import io.vertx.ext.consul.EventListOptions;
import io.vertx.ext.consul.EventOptions;
import io.vertx.ext.consul.KeyValue;
import io.vertx.ext.consul.KeyValueList;
import io.vertx.ext.consul.KeyValueOptions;
import io.vertx.ext.consul.MaintenanceOptions;
import io.vertx.ext.consul.NodeList;
import io.vertx.ext.consul.NodeQueryOptions;
import io.vertx.ext.consul.PreparedQueryDefinition;
import io.vertx.ext.consul.PreparedQueryExecuteOptions;
import io.vertx.ext.consul.PreparedQueryExecuteResponse;
import io.vertx.ext.consul.Service;
import io.vertx.ext.consul.ServiceEntryList;
import io.vertx.ext.consul.ServiceList;
import io.vertx.ext.consul.ServiceOptions;
import io.vertx.ext.consul.ServiceQueryOptions;
import io.vertx.ext.consul.Session;
import io.vertx.ext.consul.SessionList;
import io.vertx.ext.consul.SessionOptions;
import io.vertx.ext.consul.TxnRequest;
import io.vertx.ext.consul.TxnResponse;
import io.vertx.ext.consul.impl.ConsulClientImpl;
import java.util.List;

@VertxGen
public interface ConsulClient {
    public static ConsulClient create(Vertx vertx) {
        return new ConsulClientImpl(vertx, new ConsulClientOptions());
    }

    public static ConsulClient create(Vertx vertx, ConsulClientOptions options) {
        return new ConsulClientImpl(vertx, options);
    }

    @Fluent
    public ConsulClient agentInfo(Handler<AsyncResult<JsonObject>> var1);

    @Fluent
    public ConsulClient coordinateNodes(Handler<AsyncResult<CoordinateList>> var1);

    @Fluent
    public ConsulClient coordinateNodesWithOptions(BlockingQueryOptions var1, Handler<AsyncResult<CoordinateList>> var2);

    @Fluent
    public ConsulClient coordinateDatacenters(Handler<AsyncResult<List<DcCoordinates>>> var1);

    @Fluent
    public ConsulClient getKeys(String var1, Handler<AsyncResult<List<String>>> var2);

    @Fluent
    public ConsulClient getKeysWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<List<String>>> var3);

    @Fluent
    public ConsulClient getValue(String var1, Handler<AsyncResult<KeyValue>> var2);

    @Fluent
    public ConsulClient getValueWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<KeyValue>> var3);

    @Fluent
    public ConsulClient deleteValue(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulClient getValues(String var1, Handler<AsyncResult<KeyValueList>> var2);

    @Fluent
    public ConsulClient getValuesWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<KeyValueList>> var3);

    @Fluent
    public ConsulClient deleteValues(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulClient putValue(String var1, String var2, Handler<AsyncResult<Boolean>> var3);

    @Fluent
    public ConsulClient putValueWithOptions(String var1, String var2, KeyValueOptions var3, Handler<AsyncResult<Boolean>> var4);

    @Fluent
    public ConsulClient transaction(TxnRequest var1, Handler<AsyncResult<TxnResponse>> var2);

    @Fluent
    public ConsulClient createAclToken(AclToken var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public ConsulClient updateAclToken(AclToken var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public ConsulClient cloneAclToken(String var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public ConsulClient listAclTokens(Handler<AsyncResult<List<AclToken>>> var1);

    @Fluent
    public ConsulClient infoAclToken(String var1, Handler<AsyncResult<AclToken>> var2);

    @Fluent
    public ConsulClient destroyAclToken(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulClient fireEvent(String var1, Handler<AsyncResult<Event>> var2);

    @Fluent
    public ConsulClient fireEventWithOptions(String var1, EventOptions var2, Handler<AsyncResult<Event>> var3);

    @Fluent
    public ConsulClient listEvents(Handler<AsyncResult<EventList>> var1);

    @Fluent
    public ConsulClient listEventsWithOptions(EventListOptions var1, Handler<AsyncResult<EventList>> var2);

    @Fluent
    public ConsulClient registerService(ServiceOptions var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulClient maintenanceService(MaintenanceOptions var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulClient deregisterService(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulClient catalogServiceNodes(String var1, Handler<AsyncResult<ServiceList>> var2);

    @Fluent
    public ConsulClient catalogServiceNodesWithOptions(String var1, ServiceQueryOptions var2, Handler<AsyncResult<ServiceList>> var3);

    @Fluent
    public ConsulClient catalogDatacenters(Handler<AsyncResult<List<String>>> var1);

    @Fluent
    public ConsulClient catalogNodes(Handler<AsyncResult<NodeList>> var1);

    @Fluent
    public ConsulClient catalogNodesWithOptions(NodeQueryOptions var1, Handler<AsyncResult<NodeList>> var2);

    @Fluent
    public ConsulClient healthChecks(String var1, Handler<AsyncResult<CheckList>> var2);

    @Fluent
    public ConsulClient healthChecksWithOptions(String var1, CheckQueryOptions var2, Handler<AsyncResult<CheckList>> var3);

    @Fluent
    public ConsulClient healthState(CheckStatus var1, Handler<AsyncResult<CheckList>> var2);

    @Fluent
    public ConsulClient healthStateWithOptions(CheckStatus var1, CheckQueryOptions var2, Handler<AsyncResult<CheckList>> var3);

    @Fluent
    public ConsulClient healthServiceNodes(String var1, boolean var2, Handler<AsyncResult<ServiceEntryList>> var3);

    @Fluent
    public ConsulClient healthServiceNodesWithOptions(String var1, boolean var2, ServiceQueryOptions var3, Handler<AsyncResult<ServiceEntryList>> var4);

    @Fluent
    public ConsulClient catalogServices(Handler<AsyncResult<ServiceList>> var1);

    @Fluent
    public ConsulClient catalogServicesWithOptions(BlockingQueryOptions var1, Handler<AsyncResult<ServiceList>> var2);

    @Fluent
    public ConsulClient catalogNodeServices(String var1, Handler<AsyncResult<ServiceList>> var2);

    @Fluent
    public ConsulClient catalogNodeServicesWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<ServiceList>> var3);

    @Fluent
    public ConsulClient localServices(Handler<AsyncResult<List<Service>>> var1);

    @Fluent
    public ConsulClient localChecks(Handler<AsyncResult<List<Check>>> var1);

    @Fluent
    public ConsulClient registerCheck(CheckOptions var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulClient deregisterCheck(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulClient passCheck(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulClient passCheckWithNote(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public ConsulClient warnCheck(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulClient warnCheckWithNote(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public ConsulClient failCheck(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulClient failCheckWithNote(String var1, String var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public ConsulClient updateCheck(String var1, CheckStatus var2, Handler<AsyncResult<Void>> var3);

    @Fluent
    public ConsulClient updateCheckWithNote(String var1, CheckStatus var2, String var3, Handler<AsyncResult<Void>> var4);

    @Fluent
    public ConsulClient leaderStatus(Handler<AsyncResult<String>> var1);

    @Fluent
    public ConsulClient peersStatus(Handler<AsyncResult<List<String>>> var1);

    @Fluent
    public ConsulClient createSession(Handler<AsyncResult<String>> var1);

    @Fluent
    public ConsulClient createSessionWithOptions(SessionOptions var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public ConsulClient infoSession(String var1, Handler<AsyncResult<Session>> var2);

    @Fluent
    public ConsulClient infoSessionWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<Session>> var3);

    @Fluent
    public ConsulClient renewSession(String var1, Handler<AsyncResult<Session>> var2);

    @Fluent
    public ConsulClient listSessions(Handler<AsyncResult<SessionList>> var1);

    @Fluent
    public ConsulClient listSessionsWithOptions(BlockingQueryOptions var1, Handler<AsyncResult<SessionList>> var2);

    @Fluent
    public ConsulClient listNodeSessions(String var1, Handler<AsyncResult<SessionList>> var2);

    @Fluent
    public ConsulClient listNodeSessionsWithOptions(String var1, BlockingQueryOptions var2, Handler<AsyncResult<SessionList>> var3);

    @Fluent
    public ConsulClient destroySession(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulClient createPreparedQuery(PreparedQueryDefinition var1, Handler<AsyncResult<String>> var2);

    @Fluent
    public ConsulClient getPreparedQuery(String var1, Handler<AsyncResult<PreparedQueryDefinition>> var2);

    @Fluent
    public ConsulClient getAllPreparedQueries(Handler<AsyncResult<List<PreparedQueryDefinition>>> var1);

    @Fluent
    public ConsulClient updatePreparedQuery(PreparedQueryDefinition var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulClient deletePreparedQuery(String var1, Handler<AsyncResult<Void>> var2);

    @Fluent
    public ConsulClient executePreparedQuery(String var1, Handler<AsyncResult<PreparedQueryExecuteResponse>> var2);

    @Fluent
    public ConsulClient executePreparedQueryWithOptions(String var1, PreparedQueryExecuteOptions var2, Handler<AsyncResult<PreparedQueryExecuteResponse>> var3);

    public void close();
}

