/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.PreparedQueryExecuteResponse;
import io.vertx.ext.consul.ServiceEntry;
import java.util.ArrayList;

public class PreparedQueryExecuteResponseConverter {
    public static void fromJson(JsonObject json, PreparedQueryExecuteResponse obj) {
        if (json.getValue("dc") instanceof String) {
            obj.setDc((String)json.getValue("dc"));
        }
        if (json.getValue("dnsTtl") instanceof String) {
            obj.setDnsTtl((String)json.getValue("dnsTtl"));
        }
        if (json.getValue("failovers") instanceof Number) {
            obj.setFailovers(((Number)json.getValue("failovers")).intValue());
        }
        if (json.getValue("nodes") instanceof JsonArray) {
            ArrayList<ServiceEntry> list = new ArrayList<ServiceEntry>();
            json.getJsonArray("nodes").forEach(item -> {
                if (item instanceof JsonObject) {
                    list.add(new ServiceEntry((JsonObject)item));
                }
            });
            obj.setNodes(list);
        }
        if (json.getValue("service") instanceof String) {
            obj.setService((String)json.getValue("service"));
        }
    }

    public static void toJson(PreparedQueryExecuteResponse obj, JsonObject json) {
        if (obj.getDc() != null) {
            json.put("dc", obj.getDc());
        }
        if (obj.getDnsTtl() != null) {
            json.put("dnsTtl", obj.getDnsTtl());
        }
        json.put("failovers", Integer.valueOf(obj.getFailovers()));
        if (obj.getNodes() != null) {
            JsonArray array = new JsonArray();
            obj.getNodes().forEach(item -> array.add(item.toJson()));
            json.put("nodes", array);
        }
        if (obj.getService() != null) {
            json.put("service", obj.getService());
        }
    }
}

