/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.SessionBehavior;
import io.vertx.ext.consul.impl.Utils;
import java.util.ArrayList;
import java.util.List;

@DataObject
public class SessionOptions {
    private static final String LOCK_KEY = "LockDelay";
    private static final String NAME_KEY = "Name";
    private static final String NODE_KEY = "Node";
    private static final String CHECKS_KEY = "Checks";
    private static final String BEHAVIOR_KEY = "Behavior";
    private static final String TTL_KEY = "TTL";
    private long lockDelay;
    private String name;
    private String node;
    private List<String> checks;
    private SessionBehavior behavior;
    private long ttl;

    public SessionOptions() {
    }

    public SessionOptions(SessionOptions options) {
        this.lockDelay = options.lockDelay;
        this.name = options.name;
        this.node = options.node;
        this.checks = new ArrayList<String>(options.checks);
        this.behavior = options.behavior;
        this.ttl = options.ttl;
    }

    public SessionOptions(JsonObject options) {
        this.lockDelay = SessionOptions.cutSeconds(options.getString(LOCK_KEY));
        this.name = options.getString(NAME_KEY);
        this.node = options.getString(NODE_KEY);
        JsonArray arr = options.getJsonArray(CHECKS_KEY);
        this.checks = Utils.listOf(arr);
        this.behavior = SessionBehavior.of(options.getString(BEHAVIOR_KEY));
        this.ttl = SessionOptions.cutSeconds(options.getString(TTL_KEY));
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        if (this.lockDelay != 0L) {
            jsonObject.put(LOCK_KEY, this.lockDelay + "s");
        }
        if (this.name != null) {
            jsonObject.put(NAME_KEY, this.name);
        }
        if (this.node != null) {
            jsonObject.put(NODE_KEY, this.node);
        }
        if (this.checks != null) {
            jsonObject.put(CHECKS_KEY, this.checks);
        }
        if (this.behavior != null) {
            jsonObject.put(BEHAVIOR_KEY, this.behavior.key);
        }
        if (this.ttl != 0L) {
            jsonObject.put(TTL_KEY, this.ttl + "s");
        }
        return jsonObject;
    }

    public long getLockDelay() {
        return this.lockDelay;
    }

    public SessionOptions setLockDelay(long lockDelay) {
        this.lockDelay = lockDelay;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public SessionOptions setName(String name) {
        this.name = name;
        return this;
    }

    public String getNode() {
        return this.node;
    }

    public SessionOptions setNode(String node) {
        this.node = node;
        return this;
    }

    public List<String> getChecks() {
        return this.checks;
    }

    public SessionOptions setChecks(List<String> checks) {
        this.checks = checks;
        return this;
    }

    public SessionBehavior getBehavior() {
        return this.behavior;
    }

    public SessionOptions setBehavior(SessionBehavior behavior) {
        this.behavior = behavior;
        return this;
    }

    public long getTtl() {
        return this.ttl;
    }

    public SessionOptions setTtl(long ttl) {
        this.ttl = ttl;
        return this;
    }

    private static long cutSeconds(String value) {
        if (value != null && value.endsWith("s")) {
            return Integer.parseInt(value.substring(0, value.length() - 1));
        }
        return 0L;
    }
}

