/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.consul.impl;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.consul.Session;
import io.vertx.ext.consul.impl.Utils;
import java.util.concurrent.TimeUnit;

class SessionParser {
    private static final String LOCK_KEY = "LockDelay";
    private static final String NODE_KEY = "Node";
    private static final String CHECKS_KEY = "Checks";
    private static final String ID_KEY = "ID";
    private static final String CREATE_INDEX_KEY = "CreateIndex";

    SessionParser() {
    }

    static Session parse(JsonObject session) {
        return SessionParser.parse(session, 0L);
    }

    static Session parse(JsonObject session, long index) {
        Session res = new Session();
        res.setLockDelay(TimeUnit.NANOSECONDS.toSeconds(session.getLong(LOCK_KEY, Long.valueOf(0L))));
        res.setNode(session.getString(NODE_KEY));
        res.setId(session.getString(ID_KEY));
        res.setCreateIndex(session.getLong(CREATE_INDEX_KEY, Long.valueOf(0L)));
        JsonArray arr = session.getJsonArray(CHECKS_KEY);
        res.setChecks(Utils.listOf(arr));
        res.setIndex(index);
        return res;
    }
}

