/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.ServiceHelper;
import io.vertx.core.Verticle;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.IsolatingClassLoader;
import io.vertx.core.impl.JavaVerticleFactory;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerExecutorInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.spi.VerticleFactory;
import io.vertx.core.spi.metrics.VertxMetrics;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class DeploymentManager {
    private static final Logger log = LoggerFactory.getLogger(DeploymentManager.class);
    private final VertxInternal vertx;
    private final Map<String, Deployment> deployments = new ConcurrentHashMap<String, Deployment>();
    private final Map<String, IsolatingClassLoader> classloaders = new HashMap<String, IsolatingClassLoader>();
    private final Map<String, List<VerticleFactory>> verticleFactories = new ConcurrentHashMap<String, List<VerticleFactory>>();
    private final List<VerticleFactory> defaultFactories = new ArrayList<VerticleFactory>();

    public DeploymentManager(VertxInternal vertx) {
        this.vertx = vertx;
        this.loadVerticleFactories();
    }

    private void loadVerticleFactories() {
        Collection<VerticleFactory> factories = ServiceHelper.loadFactories(VerticleFactory.class);
        factories.forEach(this::registerVerticleFactory);
        JavaVerticleFactory defaultFactory = new JavaVerticleFactory();
        defaultFactory.init(this.vertx);
        this.defaultFactories.add(defaultFactory);
    }

    private String generateDeploymentID() {
        return UUID.randomUUID().toString();
    }

    public void deployVerticle(Supplier<Verticle> verticleSupplier, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        if (options.getInstances() < 1) {
            throw new IllegalArgumentException("Can't specify < 1 instances to deploy");
        }
        if (options.isMultiThreaded() && !options.isWorker()) {
            throw new IllegalArgumentException("If multi-threaded then must be worker too");
        }
        if (options.getExtraClasspath() != null) {
            throw new IllegalArgumentException("Can't specify extraClasspath for already created verticle");
        }
        if (options.getIsolationGroup() != null) {
            throw new IllegalArgumentException("Can't specify isolationGroup for already created verticle");
        }
        if (options.getIsolatedClasses() != null) {
            throw new IllegalArgumentException("Can't specify isolatedClasses for already created verticle");
        }
        ContextInternal currentContext = this.vertx.getOrCreateContext();
        ClassLoader cl = this.getClassLoader(options);
        int nbInstances = options.getInstances();
        Set verticles = Collections.newSetFromMap(new IdentityHashMap());
        for (int i = 0; i < nbInstances; ++i) {
            Verticle verticle;
            try {
                verticle = verticleSupplier.get();
            }
            catch (Exception e) {
                if (completionHandler != null) {
                    completionHandler.handle(Future.failedFuture(e));
                }
                return;
            }
            if (verticle == null) {
                if (completionHandler != null) {
                    completionHandler.handle(Future.failedFuture("Supplied verticle is null"));
                }
                return;
            }
            verticles.add(verticle);
        }
        if (verticles.size() != nbInstances) {
            if (completionHandler != null) {
                completionHandler.handle(Future.failedFuture("Same verticle supplied more than once"));
            }
            return;
        }
        Verticle[] verticlesArray = verticles.toArray(new Verticle[verticles.size()]);
        String verticleClass = verticlesArray[0].getClass().getName();
        this.doDeploy("java:" + verticleClass, options, currentContext, currentContext, completionHandler, cl, verticlesArray);
    }

    public void deployVerticle(String identifier, DeploymentOptions options, Handler<AsyncResult<String>> completionHandler) {
        if (options.isMultiThreaded() && !options.isWorker()) {
            throw new IllegalArgumentException("If multi-threaded then must be worker too");
        }
        ContextInternal callingContext = this.vertx.getOrCreateContext();
        ClassLoader cl = this.getClassLoader(options);
        this.doDeployVerticle(identifier, options, callingContext, callingContext, cl, completionHandler);
    }

    private void doDeployVerticle(String identifier, DeploymentOptions options, ContextInternal parentContext, ContextInternal callingContext, ClassLoader cl, Handler<AsyncResult<String>> completionHandler) {
        List<VerticleFactory> verticleFactories = this.resolveFactories(identifier);
        Iterator<VerticleFactory> iter = verticleFactories.iterator();
        this.doDeployVerticle(iter, null, identifier, options, parentContext, callingContext, cl, completionHandler);
    }

    private void doDeployVerticle(Iterator<VerticleFactory> iter, Throwable prevErr, String identifier, DeploymentOptions options, ContextInternal parentContext, ContextInternal callingContext, ClassLoader cl, Handler<AsyncResult<String>> completionHandler) {
        if (iter.hasNext()) {
            VerticleFactory verticleFactory = iter.next();
            Promise<String> promise = Promise.promise();
            if (verticleFactory.requiresResolve()) {
                try {
                    verticleFactory.resolve(identifier, options, cl, promise);
                }
                catch (Exception e) {
                    try {
                        promise.fail(e);
                    }
                    catch (Exception exception) {}
                }
            } else {
                promise.complete(identifier);
            }
            promise.future().setHandler(ar -> {
                Throwable err;
                if (ar.succeeded()) {
                    String resolvedName = (String)ar.result();
                    if (!resolvedName.equals(identifier)) {
                        block8: {
                            try {
                                this.deployVerticle(resolvedName, options, (Handler<AsyncResult<String>>)completionHandler);
                            }
                            catch (Exception e) {
                                if (completionHandler == null) break block8;
                                completionHandler.handle(Future.failedFuture(e));
                            }
                        }
                        return;
                    }
                    if (verticleFactory.blockingCreate()) {
                        this.vertx.executeBlocking(createFut -> {
                            try {
                                Verticle[] verticles = this.createVerticles(verticleFactory, identifier, options.getInstances(), cl);
                                createFut.complete(verticles);
                            }
                            catch (Exception e) {
                                createFut.fail(e);
                            }
                        }, res -> {
                            if (res.succeeded()) {
                                this.doDeploy(identifier, options, parentContext, callingContext, completionHandler, cl, (Verticle[])res.result());
                            } else {
                                this.doDeployVerticle(iter, res.cause(), identifier, options, parentContext, callingContext, cl, completionHandler);
                            }
                        });
                        return;
                    }
                    try {
                        Verticle[] verticles = this.createVerticles(verticleFactory, identifier, options.getInstances(), cl);
                        this.doDeploy(identifier, options, parentContext, callingContext, completionHandler, cl, verticles);
                        return;
                    }
                    catch (Exception e) {
                        err = e;
                    }
                } else {
                    err = ar.cause();
                }
                this.doDeployVerticle(iter, err, identifier, options, parentContext, callingContext, cl, completionHandler);
            });
        } else if (prevErr != null) {
            this.reportFailure(prevErr, callingContext, completionHandler);
        }
    }

    private Verticle[] createVerticles(VerticleFactory verticleFactory, String identifier, int instances, ClassLoader cl) throws Exception {
        Verticle[] verticles = new Verticle[instances];
        for (int i = 0; i < instances; ++i) {
            verticles[i] = verticleFactory.createVerticle(identifier, cl);
            if (verticles[i] != null) continue;
            throw new NullPointerException("VerticleFactory::createVerticle returned null");
        }
        return verticles;
    }

    private String getSuffix(int pos, String str) {
        if (pos + 1 >= str.length()) {
            throw new IllegalArgumentException("Invalid name: " + str);
        }
        return str.substring(pos + 1);
    }

    public void undeployVerticle(String deploymentID, Handler<AsyncResult<Void>> completionHandler) {
        Deployment deployment = this.deployments.get(deploymentID);
        ContextInternal currentContext = this.vertx.getOrCreateContext();
        if (deployment == null) {
            this.reportFailure(new IllegalStateException("Unknown deployment"), currentContext, completionHandler);
        } else {
            deployment.undeploy(completionHandler);
        }
    }

    public Set<String> deployments() {
        return Collections.unmodifiableSet(this.deployments.keySet());
    }

    public Deployment getDeployment(String deploymentID) {
        return this.deployments.get(deploymentID);
    }

    public void undeployAll(Handler<AsyncResult<Void>> completionHandler) {
        HashSet<String> deploymentIDs = new HashSet<String>();
        for (Map.Entry<String, Deployment> entry : this.deployments.entrySet()) {
            if (entry.getValue().isChild()) continue;
            deploymentIDs.add(entry.getKey());
        }
        if (!deploymentIDs.isEmpty()) {
            AtomicInteger count = new AtomicInteger(0);
            for (String deploymentID : deploymentIDs) {
                this.undeployVerticle(deploymentID, ar -> {
                    if (ar.failed()) {
                        log.error((Object)"Undeploy failed", ar.cause());
                    }
                    if (count.incrementAndGet() == deploymentIDs.size()) {
                        completionHandler.handle(Future.succeededFuture());
                    }
                });
            }
        } else {
            ContextInternal context = this.vertx.getOrCreateContext();
            context.runOnContext(v -> completionHandler.handle(Future.succeededFuture()));
        }
    }

    public void registerVerticleFactory(VerticleFactory factory) {
        String prefix = factory.prefix();
        if (prefix == null) {
            throw new IllegalArgumentException("factory.prefix() cannot be null");
        }
        List<VerticleFactory> facts = this.verticleFactories.get(prefix);
        if (facts == null) {
            facts = new ArrayList<VerticleFactory>();
            this.verticleFactories.put(prefix, facts);
        }
        if (facts.contains(factory)) {
            throw new IllegalArgumentException("Factory already registered");
        }
        facts.add(factory);
        facts.sort((fact1, fact2) -> fact1.order() - fact2.order());
        factory.init(this.vertx);
    }

    public void unregisterVerticleFactory(VerticleFactory factory) {
        String prefix = factory.prefix();
        if (prefix == null) {
            throw new IllegalArgumentException("factory.prefix() cannot be null");
        }
        List<VerticleFactory> facts = this.verticleFactories.get(prefix);
        boolean removed = false;
        if (facts != null) {
            if (facts.remove(factory)) {
                removed = true;
            }
            if (facts.isEmpty()) {
                this.verticleFactories.remove(prefix);
            }
        }
        if (!removed) {
            throw new IllegalArgumentException("factory isn't registered");
        }
    }

    public Set<VerticleFactory> verticleFactories() {
        HashSet<VerticleFactory> facts = new HashSet<VerticleFactory>();
        for (List<VerticleFactory> list : this.verticleFactories.values()) {
            facts.addAll(list);
        }
        return facts;
    }

    private List<VerticleFactory> resolveFactories(String identifier) {
        List<VerticleFactory> factoryList = null;
        int pos = identifier.indexOf(58);
        String lookup = null;
        if (pos != -1) {
            lookup = identifier.substring(0, pos);
        } else {
            pos = identifier.lastIndexOf(46);
            if (pos != -1) {
                lookup = this.getSuffix(pos, identifier);
            } else {
                factoryList = this.defaultFactories;
            }
        }
        if (factoryList == null && (factoryList = this.verticleFactories.get(lookup)) == null) {
            factoryList = this.defaultFactories;
        }
        return factoryList;
    }

    private static URL mapToURL(String path) {
        try {
            return new URL(path);
        }
        catch (MalformedURLException e) {
            try {
                return new File(path).toURI().toURL();
            }
            catch (MalformedURLException e1) {
                throw new IllegalArgumentException(e1);
            }
        }
    }

    private static List<URL> extractCPFromProperty() {
        ArrayList<URL> classpathURLs = new ArrayList<URL>();
        String classpath = System.getProperty("java.class.path");
        if (Objects.nonNull(classpath)) {
            for (String path : classpath.split(File.pathSeparator)) {
                classpathURLs.add(DeploymentManager.mapToURL(path));
            }
        }
        return classpathURLs;
    }

    static List<URL> extractCPByManifest(ClassLoader current) {
        Enumeration<URL> urls;
        ArrayList<URL> classpathURLs = new ArrayList<URL>();
        String searchFile = "META-INF/MANIFEST.MF";
        try {
            urls = current.getResources(searchFile);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (URL url : Collections.list(urls)) {
            String urlString = url.toExternalForm();
            if ("jar".equals(url.getProtocol().toLowerCase())) {
                String prefix = "jar:";
                String suffix = "!/" + searchFile;
                urlString = urlString.replace(prefix, "").replace(suffix, "").trim();
            }
            urlString = urlString.replace(searchFile, "").trim();
            try {
                classpathURLs.add(new URL(urlString));
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
        }
        return classpathURLs;
    }

    static List<URL> extractClasspath(ClassLoader current) {
        if (current instanceof URLClassLoader) {
            URLClassLoader urlc = (URLClassLoader)current;
            return Arrays.asList(urlc.getURLs());
        }
        List<URL> classpathURLs = DeploymentManager.extractCPFromProperty();
        for (URL url : DeploymentManager.extractCPByManifest(current)) {
            if (classpathURLs.contains(url)) continue;
            classpathURLs.add(url);
        }
        return classpathURLs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getClassLoader(DeploymentOptions options) {
        ClassLoader cl;
        String isolationGroup = options.getIsolationGroup();
        if (isolationGroup == null) {
            cl = this.getCurrentClassLoader();
        } else {
            DeploymentManager deploymentManager = this;
            synchronized (deploymentManager) {
                IsolatingClassLoader icl = this.classloaders.get(isolationGroup);
                if (icl == null) {
                    ClassLoader current = this.getCurrentClassLoader();
                    ArrayList<URL> urls = new ArrayList<URL>();
                    List<String> extraClasspath = options.getExtraClasspath();
                    if (extraClasspath != null) {
                        for (String pathElement : extraClasspath) {
                            urls.add(DeploymentManager.mapToURL(pathElement));
                        }
                    }
                    urls.addAll(DeploymentManager.extractClasspath(current));
                    icl = new IsolatingClassLoader(urls.toArray(new URL[urls.size()]), this.getCurrentClassLoader(), options.getIsolatedClasses());
                    this.classloaders.put(isolationGroup, icl);
                }
                icl.refCount += options.getInstances();
                cl = icl;
            }
        }
        return cl;
    }

    private ClassLoader getCurrentClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClass().getClassLoader();
        }
        return cl;
    }

    private <T> void reportFailure(Throwable t, Context context, Handler<AsyncResult<T>> completionHandler) {
        if (completionHandler != null) {
            this.reportResult(context, completionHandler, Future.failedFuture(t));
        } else {
            log.error((Object)t.getMessage(), t);
        }
    }

    private <T> void reportSuccess(T result, Context context, Handler<AsyncResult<T>> completionHandler) {
        if (completionHandler != null) {
            this.reportResult(context, completionHandler, Future.succeededFuture(result));
        }
    }

    private <T> void reportResult(Context context, Handler<AsyncResult<T>> completionHandler, AsyncResult<T> result) {
        context.runOnContext(v -> {
            try {
                completionHandler.handle(result);
            }
            catch (Throwable t) {
                log.error((Object)"Failure in calling handler", t);
                throw t;
            }
        });
    }

    private void doDeploy(String identifier, DeploymentOptions options, ContextInternal parentContext, ContextInternal callingContext, Handler<AsyncResult<String>> completionHandler, ClassLoader tccl, Verticle ... verticles) {
        JsonObject conf = options.getConfig() == null ? new JsonObject() : options.getConfig().copy();
        String poolName = options.getWorkerPoolName();
        Deployment parent = parentContext.getDeployment();
        String deploymentID = this.generateDeploymentID();
        DeploymentImpl deployment = new DeploymentImpl(parent, deploymentID, identifier, options);
        AtomicInteger deployCount = new AtomicInteger();
        AtomicBoolean failureReported = new AtomicBoolean();
        for (Verticle verticle : verticles) {
            WorkerExecutorInternal workerExec = poolName != null ? this.vertx.createSharedWorkerExecutor(poolName, options.getWorkerPoolSize(), options.getMaxWorkerExecuteTime(), options.getMaxWorkerExecuteTimeUnit()) : null;
            WorkerPool pool = workerExec != null ? workerExec.getPool() : null;
            ContextImpl context = (ContextImpl)(options.isWorker() ? this.vertx.createWorkerContext(options.isMultiThreaded(), deploymentID, pool, conf, tccl) : this.vertx.createEventLoopContext(deploymentID, pool, conf, tccl));
            if (workerExec != null) {
                context.addCloseHook(workerExec);
            }
            context.setDeployment(deployment);
            deployment.addVerticle(new VerticleHolder(verticle, context));
            context.runOnContext(v -> {
                block2: {
                    try {
                        verticle.init(this.vertx, context);
                        Promise<Void> startPromise = Promise.promise();
                        Future startFuture = startPromise.future();
                        verticle.start(startPromise);
                        startFuture.setHandler(ar -> {
                            if (ar.succeeded()) {
                                VertxMetrics metrics;
                                if (parent != null) {
                                    if (parent.addChild(deployment)) {
                                        deployment.child = true;
                                    } else {
                                        deployment.undeploy(event -> this.reportFailure(new NoStackTraceThrowable("Verticle deployment failed.Could not be added as child of parent verticle"), context, completionHandler));
                                        return;
                                    }
                                }
                                if ((metrics = this.vertx.metricsSPI()) != null) {
                                    metrics.verticleDeployed(verticle);
                                }
                                this.deployments.put(deploymentID, deployment);
                                if (deployCount.incrementAndGet() == verticles.length) {
                                    this.reportSuccess(deploymentID, callingContext, completionHandler);
                                }
                            } else if (failureReported.compareAndSet(false, true)) {
                                deployment.rollback(callingContext, completionHandler, context, ar.cause());
                            }
                        });
                    }
                    catch (Throwable t) {
                        if (!failureReported.compareAndSet(false, true)) break block2;
                        deployment.rollback(callingContext, completionHandler, context, t);
                    }
                }
            });
        }
    }

    private class DeploymentImpl
    implements Deployment {
        private static final int ST_DEPLOYED = 0;
        private static final int ST_UNDEPLOYING = 1;
        private static final int ST_UNDEPLOYED = 2;
        private final Deployment parent;
        private final String deploymentID;
        private final String verticleIdentifier;
        private final List<VerticleHolder> verticles = new CopyOnWriteArrayList<VerticleHolder>();
        private final Set<Deployment> children = new ConcurrentHashSet<Deployment>();
        private final DeploymentOptions options;
        private int status = 0;
        private volatile boolean child;

        private DeploymentImpl(Deployment parent, String deploymentID, String verticleIdentifier, DeploymentOptions options) {
            this.parent = parent;
            this.deploymentID = deploymentID;
            this.verticleIdentifier = verticleIdentifier;
            this.options = options;
        }

        public void addVerticle(VerticleHolder holder) {
            this.verticles.add(holder);
        }

        private synchronized void rollback(ContextInternal callingContext, Handler<AsyncResult<String>> completionHandler, ContextImpl context, Throwable cause) {
            if (this.status == 0) {
                this.status = 1;
                this.doUndeployChildren(callingContext, childrenResult -> {
                    DeploymentImpl deploymentImpl = this;
                    synchronized (deploymentImpl) {
                        this.status = 2;
                    }
                    if (childrenResult.failed()) {
                        DeploymentManager.this.reportFailure(cause, callingContext, completionHandler);
                    } else {
                        context.runCloseHooks(closeHookAsyncResult -> DeploymentManager.this.reportFailure(cause, callingContext, completionHandler));
                    }
                });
            }
        }

        @Override
        public void undeploy(Handler<AsyncResult<Void>> completionHandler) {
            ContextInternal currentContext = DeploymentManager.this.vertx.getOrCreateContext();
            this.doUndeploy(currentContext, completionHandler);
        }

        private synchronized void doUndeployChildren(ContextInternal undeployingContext, Handler<AsyncResult<Void>> completionHandler) {
            if (!this.children.isEmpty()) {
                int size = this.children.size();
                AtomicInteger childCount = new AtomicInteger();
                boolean undeployedSome = false;
                for (Deployment childDeployment : new HashSet<Deployment>(this.children)) {
                    undeployedSome = true;
                    childDeployment.doUndeploy(undeployingContext, ar -> {
                        this.children.remove(childDeployment);
                        if (ar.failed()) {
                            DeploymentManager.this.reportFailure(ar.cause(), undeployingContext, completionHandler);
                        } else if (childCount.incrementAndGet() == size) {
                            completionHandler.handle(Future.succeededFuture());
                        }
                    });
                }
                if (!undeployedSome) {
                    completionHandler.handle(Future.succeededFuture());
                }
            } else {
                completionHandler.handle(Future.succeededFuture());
            }
        }

        @Override
        public synchronized void doUndeploy(ContextInternal undeployingContext, Handler<AsyncResult<Void>> completionHandler) {
            if (this.status == 2) {
                DeploymentManager.this.reportFailure(new IllegalStateException("Already undeployed"), undeployingContext, completionHandler);
                return;
            }
            if (!this.children.isEmpty()) {
                this.status = 1;
                this.doUndeployChildren(undeployingContext, ar -> {
                    if (ar.failed()) {
                        DeploymentManager.this.reportFailure(ar.cause(), undeployingContext, completionHandler);
                    } else {
                        this.doUndeploy(undeployingContext, completionHandler);
                    }
                });
            } else {
                this.status = 2;
                AtomicInteger undeployCount = new AtomicInteger();
                int numToUndeploy = this.verticles.size();
                if (this.parent != null) {
                    this.parent.removeChild(this);
                }
                for (VerticleHolder verticleHolder : this.verticles) {
                    ContextImpl context = verticleHolder.context;
                    context.runOnContext(v -> {
                        block2: {
                            Promise<Void> stopPromise = Promise.promise();
                            Future stopFuture = stopPromise.future();
                            AtomicBoolean failureReported = new AtomicBoolean();
                            stopFuture.setHandler(ar -> {
                                DeploymentManager.this.deployments.remove(this.deploymentID);
                                VertxMetrics metrics = DeploymentManager.this.vertx.metricsSPI();
                                if (metrics != null) {
                                    metrics.verticleUndeployed(verticleHolder.verticle);
                                }
                                context.runCloseHooks(ar2 -> {
                                    String group;
                                    if (ar2.failed()) {
                                        log.error((Object)"Failed to run close hook", ar2.cause());
                                    }
                                    if ((group = this.options.getIsolationGroup()) != null) {
                                        DeploymentManager deploymentManager = DeploymentManager.this;
                                        synchronized (deploymentManager) {
                                            IsolatingClassLoader icl = (IsolatingClassLoader)DeploymentManager.this.classloaders.get(group);
                                            if (--icl.refCount == 0) {
                                                DeploymentManager.this.classloaders.remove(group);
                                                try {
                                                    icl.close();
                                                }
                                                catch (IOException e) {
                                                    log.debug((Object)"Issue when closing isolation group loader", e);
                                                }
                                            }
                                        }
                                    }
                                    if (ar.succeeded() && undeployCount.incrementAndGet() == numToUndeploy) {
                                        DeploymentManager.this.reportSuccess(null, undeployingContext, completionHandler);
                                    } else if (ar.failed() && !failureReported.get()) {
                                        failureReported.set(true);
                                        DeploymentManager.this.reportFailure(ar.cause(), undeployingContext, completionHandler);
                                    }
                                });
                            });
                            try {
                                verticleHolder.verticle.stop(stopPromise);
                            }
                            catch (Throwable t) {
                                if (stopPromise.tryFail(t)) break block2;
                                undeployingContext.reportException(t);
                            }
                        }
                    });
                }
            }
        }

        @Override
        public String verticleIdentifier() {
            return this.verticleIdentifier;
        }

        @Override
        public DeploymentOptions deploymentOptions() {
            return this.options;
        }

        @Override
        public synchronized boolean addChild(Deployment deployment) {
            if (this.status == 0) {
                this.children.add(deployment);
                return true;
            }
            return false;
        }

        @Override
        public void removeChild(Deployment deployment) {
            this.children.remove(deployment);
        }

        @Override
        public Set<Verticle> getVerticles() {
            HashSet<Verticle> verts = new HashSet<Verticle>();
            for (VerticleHolder holder : this.verticles) {
                verts.add(holder.verticle);
            }
            return verts;
        }

        @Override
        public boolean isChild() {
            return this.child;
        }

        @Override
        public String deploymentID() {
            return this.deploymentID;
        }
    }

    static class VerticleHolder {
        final Verticle verticle;
        final ContextImpl context;

        VerticleHolder(Verticle verticle, ContextImpl context) {
            this.verticle = verticle;
            this.context = context;
        }
    }
}

