/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl.launcher.commands;

import io.vertx.core.AsyncResult;
import io.vertx.core.ServiceHelper;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.VertxOptions;
import io.vertx.core.cli.annotations.DefaultValue;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Option;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.eventbus.EventBusOptions;
import io.vertx.core.impl.launcher.VertxLifecycleHooks;
import io.vertx.core.impl.launcher.commands.ClasspathHandler;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.launcher.ExecutionContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Objects;
import java.util.Properties;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

@Summary(value="Creates a bare instance of vert.x.")
@Description(value="This command launches a vert.x instance but do not deploy any verticles. It will receive a verticle if another node of the cluster dies.")
@Name(value="bare")
public class BareCommand
extends ClasspathHandler {
    public static final String VERTX_OPTIONS_PROP_PREFIX = "vertx.options.";
    public static final String DEPLOYMENT_OPTIONS_PROP_PREFIX = "vertx.deployment.options.";
    public static final String METRICS_OPTIONS_PROP_PREFIX = "vertx.metrics.options.";
    protected Vertx vertx;
    protected int clusterPort;
    protected String clusterHost;
    protected int clusterPublicPort;
    protected String clusterPublicHost;
    protected int quorum;
    protected String haGroup;
    protected String vertxOptions;
    protected VertxOptions options;
    protected Runnable finalAction;

    @Option(longName="quorum", argName="q")
    @Description(value="Used in conjunction with -ha this specifies the minimum number of nodes in the cluster for any HA deploymentIDs to be active. Defaults to 1.")
    @DefaultValue(value="-1")
    public void setQuorum(int quorum) {
        this.quorum = quorum;
    }

    @Option(longName="hagroup", argName="group")
    @Description(value="used in conjunction with -ha this specifies the HA group this node will join. There can be multiple HA groups in a cluster. Nodes will only failover to other nodes in the same group. Defaults to '__DEFAULT__'.")
    @DefaultValue(value="__DEFAULT__")
    public void setHAGroup(String group) {
        this.haGroup = group;
    }

    @Option(longName="cluster-port", argName="port")
    @Description(value="Port to use for cluster communication. Default is 0 which means choose a spare random port.")
    @DefaultValue(value="0")
    public void setClusterPort(int port) {
        this.clusterPort = port;
    }

    @Option(longName="cluster-host", argName="host")
    @Description(value="host to bind to for cluster communication. If this is not specified vert.x will attempt to choose one from the available interfaces.")
    public void setClusterHost(String host) {
        this.clusterHost = host;
    }

    @Option(longName="cluster-public-port", argName="public-port")
    @Description(value="Public port to use for cluster communication. Default is -1 which means same as cluster port.")
    @DefaultValue(value="-1")
    public void setClusterPublicPort(int port) {
        this.clusterPublicPort = port;
    }

    @Option(longName="cluster-public-host", argName="public-host")
    @Description(value="Public host to bind to for cluster communication. If not specified, Vert.x will use the same as cluster host.")
    public void setClusterPublicHost(String host) {
        this.clusterPublicHost = host;
    }

    @Option(longName="options", argName="options")
    @Description(value="Specifies the Vert.x options. It should reference either a JSON file which represents the options OR be a JSON string.")
    public void setVertxOptions(String vertxOptions) {
        this.vertxOptions = vertxOptions != null ? vertxOptions.trim().replaceAll("^\"|\"$", "").replaceAll("^'|'$", "") : null;
    }

    public boolean isClustered() {
        return true;
    }

    public boolean getHA() {
        return true;
    }

    @Override
    public void run() {
        this.run(null);
    }

    public void run(Runnable action) {
        this.finalAction = action;
        this.vertx = this.startVertx();
    }

    protected Vertx startVertx() {
        Vertx instance;
        MetricsOptions metricsOptions;
        JsonObject optionsJson = this.getJsonFromFileOrString(this.vertxOptions, "options");
        if (optionsJson == null) {
            metricsOptions = this.getMetricsOptions();
            this.options = new VertxOptions().setMetricsOptions(metricsOptions);
        } else {
            metricsOptions = this.getMetricsOptions(optionsJson.getJsonObject("metricsOptions"));
            this.options = new VertxOptions(optionsJson).setMetricsOptions(metricsOptions);
        }
        this.configureFromSystemProperties(this.options, VERTX_OPTIONS_PROP_PREFIX);
        this.beforeStartingVertx(this.options);
        if (this.isClustered()) {
            this.log.info("Starting clustering...");
            EventBusOptions eventBusOptions = this.options.getEventBusOptions();
            if (!Objects.equals(eventBusOptions.getHost(), "localhost")) {
                this.clusterHost = eventBusOptions.getHost();
            }
            if (eventBusOptions.getPort() != 0) {
                this.clusterPort = eventBusOptions.getPort();
            }
            if (!Objects.equals(eventBusOptions.getClusterPublicHost(), EventBusOptions.DEFAULT_CLUSTER_PUBLIC_HOST)) {
                this.clusterPublicHost = eventBusOptions.getClusterPublicHost();
            }
            if (eventBusOptions.getClusterPublicPort() != -1) {
                this.clusterPublicPort = eventBusOptions.getClusterPublicPort();
            }
            if (this.clusterHost == null) {
                this.clusterHost = this.getDefaultAddress();
                if (this.clusterHost == null) {
                    this.log.error("Unable to find a default network interface for clustering. Please specify one using -cluster-host");
                    return null;
                }
                this.log.info("No cluster-host specified so using address " + this.clusterHost);
            }
            CountDownLatch latch = new CountDownLatch(1);
            AtomicReference result = new AtomicReference();
            eventBusOptions.setClustered(true).setHost(this.clusterHost).setPort(this.clusterPort).setClusterPublicHost(this.clusterPublicHost);
            if (this.clusterPublicPort != -1) {
                eventBusOptions.setClusterPublicPort(this.clusterPublicPort);
            }
            if (this.getHA()) {
                this.options.setHAEnabled(true);
                if (this.haGroup != null) {
                    this.options.setHAGroup(this.haGroup);
                }
                if (this.quorum != -1) {
                    this.options.setQuorumSize(this.quorum);
                }
            }
            this.create(this.options, ar -> {
                result.set(ar);
                latch.countDown();
            });
            try {
                if (!latch.await(2L, TimeUnit.MINUTES)) {
                    this.log.error("Timed out in starting clustered Vert.x");
                    return null;
                }
            }
            catch (InterruptedException e) {
                this.log.error("Thread interrupted in startup");
                Thread.currentThread().interrupt();
                return null;
            }
            if (((AsyncResult)result.get()).failed()) {
                this.log.error("Failed to form cluster");
                ((AsyncResult)result.get()).cause().printStackTrace();
                return null;
            }
            instance = (Vertx)((AsyncResult)result.get()).result();
        } else {
            instance = this.create(this.options);
        }
        BareCommand.addShutdownHook(instance, this.log, this.finalAction);
        this.afterStartingVertx(instance);
        return instance;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected JsonObject getJsonFromFileOrString(String jsonFileOrString, String argName) {
        if (jsonFileOrString == null) {
            return null;
        }
        try (Scanner scanner = new Scanner(new File(jsonFileOrString), "UTF-8").useDelimiter("\\A");){
            String sconf = scanner.next();
            try {
                JsonObject conf = new JsonObject(sconf);
                return conf;
            }
            catch (DecodeException e) {
                this.log.error("Configuration file " + sconf + " does not contain a valid JSON object");
                JsonObject jsonObject = null;
                if (scanner == null) return jsonObject;
                if (throwable != null) {
                    try {
                        scanner.close();
                        return jsonObject;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                        return jsonObject;
                    }
                }
                scanner.close();
                return jsonObject;
            }
        }
        catch (FileNotFoundException e) {
            try {
                return new JsonObject(jsonFileOrString);
            }
            catch (DecodeException e2) {
                this.log.error("The -" + argName + " argument does not point to an existing file or is not a valid JSON object");
                e2.printStackTrace();
                return null;
            }
        }
    }

    protected void afterStartingVertx(Vertx instance) {
        Object main = this.executionContext.main();
        if (main instanceof VertxLifecycleHooks) {
            ((VertxLifecycleHooks)main).afterStartingVertx(instance);
        }
    }

    protected void beforeStartingVertx(VertxOptions options) {
        Object main = this.executionContext.main();
        if (main instanceof VertxLifecycleHooks) {
            ((VertxLifecycleHooks)main).beforeStartingVertx(options);
        }
    }

    protected MetricsOptions getMetricsOptions() {
        return this.getMetricsOptions(null);
    }

    protected MetricsOptions getMetricsOptions(JsonObject jsonObject) {
        VertxMetricsFactory factory = ServiceHelper.loadFactoryOrNull(VertxMetricsFactory.class);
        MetricsOptions metricsOptions = factory != null ? (jsonObject == null ? factory.newOptions() : factory.newOptions(jsonObject)) : (jsonObject == null ? new MetricsOptions() : new MetricsOptions(jsonObject));
        this.configureFromSystemProperties(metricsOptions, METRICS_OPTIONS_PROP_PREFIX);
        return metricsOptions;
    }

    protected void configureFromSystemProperties(Object options, String prefix) {
        Properties props = System.getProperties();
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            Object arg;
            Method setter;
            block11: {
                String propName = (String)e.nextElement();
                String propVal = props.getProperty(propName);
                if (!propName.startsWith(prefix)) continue;
                String fieldName = propName.substring(prefix.length());
                setter = this.getSetter(fieldName, options.getClass());
                if (setter == null) {
                    this.log.warn("No such property to configure on options: " + options.getClass().getName() + "." + fieldName);
                    continue;
                }
                Class<?> argType = setter.getParameterTypes()[0];
                try {
                    if (argType.equals(String.class)) {
                        arg = propVal;
                        break block11;
                    }
                    if (argType.equals(Integer.TYPE)) {
                        arg = Integer.valueOf(propVal);
                        break block11;
                    }
                    if (argType.equals(Long.TYPE)) {
                        arg = Long.valueOf(propVal);
                        break block11;
                    }
                    if (argType.equals(Boolean.TYPE)) {
                        arg = Boolean.valueOf(propVal);
                        break block11;
                    }
                    if (argType.isEnum()) {
                        arg = Enum.valueOf(argType, propVal);
                        break block11;
                    }
                    this.log.warn("Invalid type for setter: " + argType);
                }
                catch (IllegalArgumentException e2) {
                    this.log.warn("Invalid argtype:" + argType + " on options: " + options.getClass().getName() + "." + fieldName);
                }
                continue;
            }
            try {
                setter.invoke(options, arg);
            }
            catch (Exception ex) {
                throw new VertxException("Failed to invoke setter: " + setter, ex);
            }
        }
    }

    private Method getSetter(String fieldName, Class<?> clazz) {
        Method[] meths;
        for (Method meth : meths = clazz.getDeclaredMethods()) {
            if (!("set" + fieldName).toLowerCase().equals(meth.getName().toLowerCase())) continue;
            return meth;
        }
        for (Method meth : meths = clazz.getMethods()) {
            if (!("set" + fieldName).toLowerCase().equals(meth.getName().toLowerCase())) continue;
            return meth;
        }
        return null;
    }

    protected static void addShutdownHook(Vertx vertx, Logger log, Runnable action) {
        Runtime.getRuntime().addShutdownHook(new Thread(BareCommand.getTerminationRunnable(vertx, log, action)));
    }

    public static Runnable getTerminationRunnable(Vertx vertx, Logger log, Runnable action) {
        return () -> {
            CountDownLatch latch = new CountDownLatch(1);
            if (vertx != null) {
                vertx.close(ar -> {
                    if (!ar.succeeded()) {
                        log.error((Object)"Failure in stopping Vert.x", ar.cause());
                    }
                    latch.countDown();
                });
                try {
                    if (!latch.await(2L, TimeUnit.MINUTES)) {
                        log.error("Timed out waiting to undeploy all");
                    }
                    if (action != null) {
                        action.run();
                    }
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
            }
        };
    }

    protected String getDefaultAddress() {
        Enumeration<NetworkInterface> nets;
        try {
            nets = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            return null;
        }
        while (nets.hasMoreElements()) {
            NetworkInterface netinf = nets.nextElement();
            Enumeration<InetAddress> addresses = netinf.getInetAddresses();
            while (addresses.hasMoreElements()) {
                InetAddress address = addresses.nextElement();
                if (address.isAnyLocalAddress() || address.isMulticastAddress() || address instanceof Inet6Address) continue;
                return address.getHostAddress();
            }
        }
        return null;
    }

    public void setExecutionContext(ExecutionContext context) {
        this.executionContext = context;
    }

    public synchronized Vertx vertx() {
        return this.vertx;
    }
}

