/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.shareddata.AsyncMap;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.ExpiryPolicy;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;
import org.apache.ignite.lang.IgniteFuture;
import org.apache.ignite.lang.IgniteInClosure;

public class AsyncMapImpl<K, V>
implements AsyncMap<K, V> {
    private final Vertx vertx;
    private final IgniteCache<K, V> cache;

    public AsyncMapImpl(IgniteCache<K, V> cache, Vertx vertx) {
        this.cache = cache.withAsync();
        this.vertx = vertx;
    }

    public void get(K key, Handler<AsyncResult<V>> handler) {
        this.execute(cache -> cache.get(key), handler);
    }

    public void put(K key, V value, Handler<AsyncResult<Void>> handler) {
        this.execute(cache -> cache.put(key, value), handler);
    }

    public void put(K key, V value, long ttl, Handler<AsyncResult<Void>> handler) {
        this.executeWithTtl(cache -> cache.put(key, value), handler, ttl);
    }

    public void putIfAbsent(K key, V value, Handler<AsyncResult<V>> handler) {
        this.execute(cache -> cache.getAndPutIfAbsent(key, value), handler);
    }

    public void putIfAbsent(K key, V value, long ttl, Handler<AsyncResult<V>> handler) {
        this.executeWithTtl(cache -> cache.getAndPutIfAbsent(key, value), handler, ttl);
    }

    public void remove(K key, Handler<AsyncResult<V>> handler) {
        this.execute(cache -> cache.getAndRemove(key), handler);
    }

    public void removeIfPresent(K key, V value, Handler<AsyncResult<Boolean>> handler) {
        this.execute(cache -> cache.remove(key, value), handler);
    }

    public void replace(K key, V value, Handler<AsyncResult<V>> handler) {
        this.execute(cache -> cache.getAndReplace(key, value), handler);
    }

    public void replaceIfPresent(K key, V oldValue, V newValue, Handler<AsyncResult<Boolean>> handler) {
        this.execute(cache -> cache.replace(key, oldValue, newValue), handler);
    }

    public void clear(Handler<AsyncResult<Void>> handler) {
        this.execute(IgniteCache::clear, handler);
    }

    public void size(Handler<AsyncResult<Integer>> handler) {
        this.execute(rec$ -> ((IgniteCache)rec$).size(new CachePeekMode[0]), handler);
    }

    private <T> void execute(Consumer<IgniteCache<K, V>> cacheOp, Handler<AsyncResult<T>> handler) {
        this.executeWithTtl(cacheOp, handler, -1L);
    }

    private <T> void executeWithTtl(Consumer<IgniteCache<K, V>> cacheOp, Handler<AsyncResult<T>> handler, long ttl) {
        try {
            IgniteCache cache0 = ttl > 0L ? this.cache.withExpiryPolicy((ExpiryPolicy)new CreatedExpiryPolicy(new Duration(TimeUnit.MILLISECONDS, ttl))) : this.cache;
            cacheOp.accept(cache0);
            IgniteFuture future = cache0.future();
            future.listen((IgniteInClosure & Serializable)fut -> this.vertx.executeBlocking(f -> f.complete(future.get()), handler));
        }
        catch (Exception e) {
            handler.handle((Object)Future.failedFuture((Throwable)e));
        }
    }
}

