/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.spi.cluster.ignite.impl;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;
import org.apache.ignite.IgniteCache;
import org.apache.ignite.cache.CachePeekMode;

public class MapImpl<K, V>
implements Map<K, V> {
    private final IgniteCache<K, V> cache;

    public MapImpl(IgniteCache<K, V> cache) {
        this.cache = cache;
    }

    IgniteCache<K, V> getCache() {
        return this.cache;
    }

    @Override
    public int size() {
        return this.cache.size(new CachePeekMode[0]);
    }

    @Override
    public boolean isEmpty() {
        return this.cache.size(new CachePeekMode[0]) == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Cache.Entry entry : this.cache) {
            if (!entry.getValue().equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        return (V)this.cache.get(key);
    }

    @Override
    public V put(K key, V value) {
        return (V)this.cache.getAndPut(key, value);
    }

    @Override
    public V remove(Object key) {
        return (V)this.cache.getAndRemove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        this.cache.putAll(map);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public Set<K> keySet() {
        HashSet<Object> res = new HashSet<Object>();
        for (Cache.Entry entry : this.cache) {
            res.add(entry.getKey());
        }
        return res;
    }

    @Override
    public Collection<V> values() {
        ArrayList<Object> res = new ArrayList<Object>();
        for (Cache.Entry entry : this.cache) {
            res.add(entry.getValue());
        }
        return res;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet<Map.Entry<K, V>> res = new HashSet<Map.Entry<K, V>>();
        for (Cache.Entry entry : this.cache) {
            res.add(new AbstractMap.SimpleImmutableEntry<Object, Object>(entry.getKey(), entry.getValue()));
        }
        return res;
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return (V)this.cache.getAndPutIfAbsent(key, value);
    }

    @Override
    public boolean remove(Object key, Object value) {
        return this.cache.remove(key, value);
    }

    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        return this.cache.replace(key, oldValue, newValue);
    }

    @Override
    public V replace(K key, V value) {
        return (V)this.cache.getAndReplace(key, value);
    }
}

