/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.jwt;

public interface Crypto {
    public static final String[] ECDSA_ALGORITHMS = new String[]{"SHA256withECDSA", "SHA384withECDSA", "SHA512withECDSA"};

    public byte[] sign(byte[] var1);

    public boolean verify(byte[] var1, byte[] var2);

    default public boolean isECDSA(String algorithm) {
        for (String alg : ECDSA_ALGORITHMS) {
            if (!alg.equals(algorithm)) continue;
            return true;
        }
        return false;
    }

    default public int ECDSALength(String algorithm) {
        switch (algorithm) {
            case "SHA256withECDSA": {
                return 64;
            }
            case "SHA384withECDSA": {
                return 96;
            }
            case "SHA512withECDSA": {
                return 132;
            }
        }
        return -1;
    }
}

